/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewRemoteConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 2806958431387531044L;
    private final ConfigManager configManager;
    private DialogDescriptor descriptor;
    private JLabel connectionNameLabel;
    private JTextField connectionNameTextField;
    private JComboBox connectionTypeComboBox;
    private JLabel connectionTypeLabel;
    private JLabel errorLabel;

    public NewRemoteConnectionPanel(ConfigManager configManager) {
        this.configManager = configManager;
        this.initComponents();
        this.errorLabel.setText(" ");
        this.connectionTypeComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(RemoteConnections.get().getRemoteConnectionTypes())));
        this.registerListeners();
    }

    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"LBL_CreateNewConnection"), true, 2, DialogDescriptor.OK_OPTION, null);
        this.descriptor.setValid(false);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)this.descriptor) == NotifyDescriptor.OK_OPTION;
    }

    public String getConnectionName() {
        return this.connectionNameTextField.getText().trim();
    }

    public String getConfigName() {
        return this.getConnectionName().replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    public String getConnectionType() {
        return (String)this.connectionTypeComboBox.getSelectedItem();
    }

    void validateFields() {
        String string = this.getConnectionName();
        String string2 = this.getConfigName();
        String string3 = this.getConnectionType();
        String string4 = null;
        if (string.length() == 0) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionName");
        } else if (string3.length() == 0) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionType");
        } else if (this.configManager.exists(string2)) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_ConnectionExists", (Object)string2);
        }
        this.setError(string4);
    }

    private void registerListeners() {
        this.connectionNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
        this.connectionTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
    }

    private void setError(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(string);
        assert (this.descriptor != null);
        this.descriptor.setValid(string == null);
    }

    private void initComponents() {
        this.connectionNameLabel = new JLabel();
        this.connectionNameTextField = new JTextField();
        this.connectionTypeLabel = new JLabel();
        this.connectionTypeComboBox = new JComboBox();
        this.errorLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionNameTextField;
            }

            public Component getFirstComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionNameTextField;
            }

            public Component getLastComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == NewRemoteConnectionPanel.this.connectionNameTextField) {
                    return NewRemoteConnectionPanel.this.connectionTypeComboBox;
                }
                return NewRemoteConnectionPanel.this.connectionNameTextField;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == NewRemoteConnectionPanel.this.connectionTypeComboBox) {
                    return NewRemoteConnectionPanel.this.connectionNameTextField;
                }
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }
        });
        this.connectionNameLabel.setLabelFor(this.connectionNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.connectionNameLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.text"));
        this.connectionNameTextField.setText(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.text"));
        this.connectionTypeLabel.setLabelFor(this.connectionTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.connectionTypeLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"dummy");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.connectionNameLabel).add((Component)this.connectionTypeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.connectionTypeComboBox, 0, 221, Short.MAX_VALUE).add(1, (Component)this.connectionNameTextField, -1, 221, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionNameLabel).add((Component)this.connectionNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionTypeLabel).add((Component)this.connectionTypeComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.connectionNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleName"));
        this.connectionNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleDescription"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleName"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleDescription"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleName"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleDescription"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleName"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleDescription"));
    }
}

