/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.environment.MacPhpEnvironment;
import org.netbeans.modules.php.project.environment.SolarisPhpEnvironment;
import org.netbeans.modules.php.project.environment.UnixPhpEnvironment;
import org.netbeans.modules.php.project.environment.UnknownPhpEnvironment;
import org.netbeans.modules.php.project.environment.WindowsPhpEnvironment;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhpEnvironment {
    public static final DocumentRoot PENDING_DOCUMENT_ROOT = new DocumentRoot(NbBundle.getMessage(PhpEnvironment.class, (String)"LBL_PleaseWait"), null, null, true);
    protected static final Logger LOGGER = Logger.getLogger(PhpEnvironment.class.getName());
    static final String HTDOCS = "htdocs";
    static final FilenameFilter APACHE_FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.toLowerCase().startsWith("apache");
        }
    };
    private static final PhpEnvironment UNKNOWN_PHP_ENVIRONMENT = new UnknownPhpEnvironment();
    private static final RequestProcessor READ_DOCUMENT_ROOTS_THREAD = new RequestProcessor("Read document roots", 3);

    PhpEnvironment() {
    }

    public static PhpEnvironment get() {
        if (PhpEnvironment.isSolaris()) {
            return new SolarisPhpEnvironment();
        }
        if (Utilities.isWindows()) {
            return new WindowsPhpEnvironment();
        }
        if (Utilities.isMac()) {
            return new MacPhpEnvironment();
        }
        if (Utilities.isUnix()) {
            return new UnixPhpEnvironment();
        }
        return UNKNOWN_PHP_ENVIRONMENT;
    }

    public DocumentRoot readDocumentRoots(final ReadDocumentRootsNotifier readDocumentRootsNotifier, final String string) {
        assert (readDocumentRootsNotifier != null);
        RequestProcessor.Task task = READ_DOCUMENT_ROOTS_THREAD.create(new Runnable(){

            public void run() {
                List<DocumentRoot> list = PhpEnvironment.this.getDocumentRoots(string);
                assert (list != null);
                readDocumentRootsNotifier.finished(list);
            }
        });
        task.schedule(0);
        return PENDING_DOCUMENT_ROOT;
    }

    public DocumentRoot readDocumentRoots(ReadDocumentRootsNotifier readDocumentRootsNotifier) {
        return this.readDocumentRoots(readDocumentRootsNotifier, null);
    }

    public abstract List<String> getAllPhpInterpreters();

    public String getAnyPhpInterpreter() {
        List<String> list = this.getAllPhpInterpreters();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getAllPhpUnits() {
        return PhpEnvironment.findFileOnUsersPath("phpunit");
    }

    public String getAnyPhpUnit() {
        List<String> list = this.getAllPhpUnits();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected abstract List<DocumentRoot> getDocumentRoots(String var1);

    static boolean isSolaris() {
        return (Utilities.getOperatingSystem() & 8) != 0 || (Utilities.getOperatingSystem() & 0x100) != 0;
    }

    static String getFolderName(File file, String string) {
        if (string == null) {
            return file.getAbsolutePath();
        }
        return new File(file, string).getAbsolutePath();
    }

    static String getDefaultUrl(String string) {
        return PhpEnvironment.getDefaultUrl(string, null);
    }

    static String getDefaultUrl(String string, Integer n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("http://localhost");
        if (n != null) {
            stringBuilder.append(":");
            stringBuilder.append(n);
        }
        stringBuilder.append("/");
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    static File findHtDocsDirectory(File file, FilenameFilter filenameFilter) {
        LOGGER.fine("Searching for htdocs in " + file);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            File file3 = new File(file2, HTDOCS);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("\t%s - exists: %s, directory: %s, file: %s", file3, file3.exists(), file3.isDirectory(), file3.isFile()));
            }
            if (file3.isDirectory()) {
                return file3;
            }
            file3 = PhpEnvironment.findHtDocsDirectory(file2, filenameFilter);
            if (file3 == null || !file3.isDirectory()) continue;
            return file3;
        }
        return null;
    }

    static DocumentRoot getUserPublicHtmlDocumentRoot(String string) {
        DocumentRoot documentRoot = null;
        File file = new File(System.getProperty("user.home"), "public_html");
        if (file.isDirectory()) {
            String string2 = PhpEnvironment.getFolderName(file, string);
            String string3 = System.getProperty("user.name");
            String string4 = string != null ? "/" + string : "";
            String string5 = PhpEnvironment.getDefaultUrl("~" + string3 + string4);
            String string6 = NbBundle.getMessage(PhpEnvironment.class, (String)"TXT_UserDir");
            documentRoot = new DocumentRoot(string2, string5, string6, file.canWrite());
        }
        return documentRoot;
    }

    static List<String> getAllPhpInterpreters(String string) {
        return PhpEnvironment.findFileOnUsersPath(string);
    }

    protected static List<String> findFileOnUsersPath(String string) {
        String string2 = System.getenv("PATH");
        if (string2 == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string2.split(File.pathSeparator)));
        ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet.size());
        for (String string3 : linkedHashSet) {
            File file = new File(string3, string);
            if (!file.isFile()) continue;
            arrayList.add(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReadDocumentRootsNotifier {
        public void finished(List<DocumentRoot> var1);
    }

    public static final class DocumentRoot {
        private final String documentRoot;
        private final String url;
        private final String hint;
        private final boolean preferred;

        public DocumentRoot(String string, String string2, String string3, boolean bl) {
            this.documentRoot = string;
            this.url = string2;
            this.hint = string3;
            this.preferred = bl;
        }

        public String getDocumentRoot() {
            return this.documentRoot;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isPreferred() {
            return this.preferred;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append(" { documentRoot : ");
            stringBuilder.append(this.documentRoot);
            stringBuilder.append(" , url : ");
            stringBuilder.append(this.url);
            stringBuilder.append(" , hint : ");
            stringBuilder.append(this.hint);
            stringBuilder.append(" , preferred : ");
            stringBuilder.append(this.preferred);
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }
}

