/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.PhpUnitSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.project.util.PhpUnit;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateTestsAction
extends NodeAction {
    private static final long serialVersionUID = 952382987542628824L;
    private static final Logger LOGGER = Logger.getLogger(CreateTestsAction.class.getName());
    private static final String PHP_OPEN_TAG = "<?php";
    private static final String INCLUDE_PATH_TPL = "ini_set(\"include_path\", %sini_get(\"include_path\"));";
    private static final String INCLUDE_PATH_PART = "\"%s\".PATH_SEPARATOR.";
    private static final ExecutionDescriptor EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(false).frontWindow(false);
    private static final RequestProcessor RP = new RequestProcessor("Generate PHP Unit tests", 1);
    static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        public void run() {
            Runnable runnable = RUNNABLES.poll();
            while (runnable != null) {
                runnable.run();
                runnable = RUNNABLES.poll();
            }
        }
    }, true);

    public CreateTestsAction() {
        this.putValue("noIconInMenu", true);
    }

    public boolean asynchronous() {
        return false;
    }

    protected void performAction(final Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final PhpUnit phpUnit = CommandUtils.getPhpUnit(true);
        if (phpUnit == null) {
            return;
        }
        final PhpProject phpProject = PhpProjectUtils.getPhpProject(nodeArray[0]);
        assert (phpProject != null) : "PHP project must be found for " + nodeArray[0];
        if (ProjectPropertiesSupport.getTestDirectory(phpProject, true) == null) {
            return;
        }
        RUNNABLES.add(new Runnable(){

            public void run() {
                CreateTestsAction.this.generateTests(nodeArray, phpUnit, phpProject);
            }
        });
        TASK.schedule(0);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        PhpProject phpProject = null;
        for (Node node : nodeArray) {
            FileObject fileObject = CommandUtils.getFileObject(node);
            if (fileObject == null) {
                return false;
            }
            if (fileObject.isData() && !CommandUtils.isPhpFile(fileObject)) {
                return false;
            }
            PhpProject phpProject2 = PhpProjectUtils.getPhpProject(fileObject);
            if (phpProject2 == null) {
                return false;
            }
            if (phpProject == null) {
                phpProject = phpProject2;
            } else if (!phpProject.equals(phpProject2)) {
                return false;
            }
            if (CommandUtils.isUnderSources(phpProject2, fileObject) && !CommandUtils.isUnderTests(phpProject2, fileObject, false)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreateTests");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    void generateTests(Node[] nodeArray, PhpUnit phpUnit, PhpProject phpProject) {
        HashSet<File> hashSet;
        assert (phpProject != null);
        List<FileObject> list = CommandUtils.getFileObjects(nodeArray);
        assert (!list.isEmpty()) : "No files for tests?!";
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        HashSet<FileObject> hashSet3 = new HashSet<FileObject>();
        HashSet<File> hashSet4 = new HashSet<File>();
        try {
            for (FileObject object : list) {
                this.generateTest(phpUnit, phpProject, object, hashSet2, hashSet3, hashSet4);
                Enumeration enumeration = object.getChildren(true);
                while (enumeration.hasMoreElements()) {
                    this.generateTest(phpUnit, phpProject, (FileObject)enumeration.nextElement(), hashSet2, hashSet3, hashSet4);
                }
            }
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
            CommandUtils.processExecutionException(executionException);
        }
        if (!hashSet3.isEmpty()) {
            hashSet = new StringBuilder();
            for (FileObject fileObject : hashSet3) {
                ((StringBuilder)((Object)hashSet)).append(fileObject.getNameExt());
                ((StringBuilder)((Object)hashSet)).append("\n");
            }
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateTestsAction.class, (String)"MSG_TestNotGenerated", (Object)((StringBuilder)((Object)hashSet)).toString()), 2));
        }
        hashSet = new HashSet<File>();
        for (File file : hashSet4) {
            assert (file.isFile()) : "File must be given to open: " + file;
            hashSet.add(file.getParentFile());
            try {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                assert (fileObject != null) : "File object not found for " + file;
                assert (fileObject.isValid()) : "File object not valid for " + file;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                editorCookie.open();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, null, dataObjectNotFoundException);
            }
        }
        if (!hashSet.isEmpty()) {
            FileUtil.refreshFor((File[])hashSet.toArray(new File[hashSet.size()]));
        }
    }

    private void generateTest(PhpUnit phpUnit, PhpProject phpProject, FileObject fileObject, Set<FileObject> set, Set<FileObject> set2, Set<File> set3) throws ExecutionException {
        if (fileObject.isFolder() || !CommandUtils.isPhpFile(fileObject) || set.contains(fileObject)) {
            return;
        }
        set.add(fileObject);
        String string = phpUnit.supportedVersionFound() ? "--skeleton-test" : "--skeleton";
        File file = FileUtil.toFile((FileObject)fileObject.getParent());
        PhpUnitSupport phpUnitSupport = (PhpUnitSupport)Lookup.getDefault().lookup(PhpUnitSupport.class);
        assert (phpUnitSupport != null) : "PHP unit support must exist";
        Collection<? extends String> collection = phpUnitSupport.getClassNames(fileObject);
        if (collection.size() == 0) {
            this.generateSkeleton(phpUnit, fileObject.getName(), fileObject, file, string);
            set2.add(fileObject);
            return;
        }
        for (String string2 : collection) {
            File file2 = this.getTestFile(phpProject, fileObject, string2);
            if (file2.isFile()) {
                set3.add(file2);
                continue;
            }
            File file3 = this.getGeneratedFile(string2, file);
            Future<Integer> future = this.generateSkeleton(phpUnit, string2, fileObject, file, string);
            try {
                if (future.get() != 0) {
                    set2.add(fileObject);
                    continue;
                }
                File file4 = this.moveAndAdjustGeneratedFile(file3, file2, this.getTestDirectory(phpProject));
                if (file4 == null) {
                    set2.add(fileObject);
                    continue;
                }
                set3.add(file4);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.WARNING, null, interruptedException);
            }
        }
    }

    private Future<Integer> generateSkeleton(PhpUnit phpUnit, String string, FileObject fileObject, File file, String string2) {
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(phpUnit.getProgram()).workingDirectory(file).addArgument(string2).addArgument(string).addArgument(fileObject.getNameExt());
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)EXECUTION_DESCRIPTOR, (String)String.format("%s %s %s %s", phpUnit.getProgram(), string2, string, fileObject.getNameExt()));
        return executionService.run();
    }

    private File getGeneratedFile(String string, File file) {
        return new File(file, string + "Test.php");
    }

    private File getTestDirectory(PhpProject phpProject) {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (fileObject != null && fileObject.isValid()) : "Valid folder for tests must be found for " + phpProject;
        return FileUtil.toFile((FileObject)fileObject);
    }

    private File getTestFile(PhpProject phpProject, FileObject fileObject, String string) {
        assert (phpProject != null);
        assert (fileObject != null);
        FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
        String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent());
        assert (string2 != null) : String.format("Relative path must be found for sources %s and folder %s", fileObject2, fileObject.getParent());
        File file = new File(this.getTestDirectory(phpProject), string2.replace('/', File.separatorChar));
        return new File(file, string + "Test.php");
    }

    private File moveAndAdjustGeneratedFile(File file, File file2, File file3) {
        assert (file.isFile()) : "Generated files must exist: " + file;
        assert (!file2.exists()) : "Test file cannot exist: " + file2;
        try {
            FileUtil.createFolder((File)file2.getParentFile());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
            return file;
        }
        file2 = this.adjustFileContent(file, file2, CreateTestsAction.getIncludePaths(file, file2, file3));
        if (file2 == null) {
            return null;
        }
        assert (file2.isFile()) : "Test file must exist: " + file2;
        return file2;
    }

    static List<String> getIncludePaths(File file, File file2, File file3) {
        File file4 = file.getParentFile();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(PropertyUtils.relativizeFile((File)file3, (File)file4));
        File file5 = file2.getParentFile();
        if (!file3.equals(file5)) {
            linkedList.add(PropertyUtils.relativizeFile((File)file5, (File)file4));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File adjustFileContent(File file, File file2, List<String> list) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                try {
                    StringBuilder stringBuilder = new StringBuilder(200);
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        String string = object.next();
                        stringBuilder.append(String.format(INCLUDE_PATH_PART, string));
                    }
                    boolean bl = false;
                    while ((object = bufferedReader.readLine()) != null) {
                        bufferedWriter.write((String)object);
                        bufferedWriter.newLine();
                        if (bl || !PHP_OPEN_TAG.equals(((String)object).trim())) continue;
                        bufferedWriter.write(String.format(INCLUDE_PATH_TPL, stringBuilder.toString()));
                        bufferedWriter.newLine();
                        bl = true;
                    }
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            {
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
            return null;
        }
        if (!file.delete()) {
            LOGGER.info("Cannot delete generated file " + file);
        }
        return file2;
    }
}

