/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.IncludePathUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpProjectProperties
implements ConfigManager.ConfigProvider {
    public static final int DEFAULT_DEBUG_PROXY_PORT = 9001;
    public static final String SRC_DIR = "src.dir";
    public static final String TEST_SRC_DIR = "test.src.dir";
    public static final String SELENIUM_SRC_DIR = "selenium.src.dir";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String COPY_SRC_FILES = "copy.src.files";
    public static final String COPY_SRC_TARGET = "copy.src.target";
    public static final String WEB_ROOT = "web.root";
    public static final String URL = "url";
    public static final String INDEX_FILE = "index.file";
    public static final String INCLUDE_PATH = "include.path";
    public static final String GLOBAL_INCLUDE_PATH = "php.global.include.path";
    public static final String ARGS = "script.arguments";
    public static final String INTERPRETER = "interpreter";
    public static final String RUN_AS = "run.as";
    public static final String REMOTE_CONNECTION = "remote.connection";
    public static final String REMOTE_DIRECTORY = "remote.directory";
    public static final String REMOTE_UPLOAD = "remote.upload";
    public static final String REMOTE_PERMISSIONS = "remote.permissions";
    public static final String REMOTE_UPLOAD_DIRECTLY = "remote.upload.directly";
    public static final String DEBUG_URL = "debug.url";
    public static final String DEBUG_PATH_MAPPING_REMOTE = "debug.path.mapping.remote";
    public static final String DEBUG_PATH_MAPPING_LOCAL = "debug.path.mapping.local";
    public static final String DEBUG_PROXY_HOST = "debug.proxy.host";
    public static final String DEBUG_PROXY_PORT = "debug.proxy.port";
    public static final String SHORT_TAGS = "tags.short";
    public static final String ASP_TAGS = "tags.asp";
    public static final String DEBUG_PATH_MAPPING_SEPARATOR = "||NB||";
    public static final String[] CFG_PROPS = new String[]{"url", "index.file", "script.arguments", "interpreter", "run.as", "remote.connection", "remote.directory", "remote.upload", "remote.permissions", "remote.upload.directly", "debug.url", "debug.path.mapping.remote", "debug.path.mapping.local", "debug.proxy.host", "debug.proxy.port"};
    static final String CONFIG_PRIVATE_PROPERTIES_PATH = "nbproject/private/config.properties";
    private final PhpProject project;
    private final IncludePathSupport includePathSupport;
    private String srcDir;
    private String copySrcFiles;
    private String copySrcTarget;
    private String webRoot;
    private String url;
    private String indexFile;
    private String encoding;
    private String shortTags;
    private String aspTags;
    Map<String, Map<String, String>> runConfigs;
    String activeConfig;
    private DefaultListModel includePathListModel = null;
    private ListCellRenderer includePathListRenderer = null;

    public PhpProjectProperties(PhpProject phpProject, IncludePathSupport includePathSupport) {
        assert (phpProject != null);
        assert (includePathSupport != null);
        this.project = phpProject;
        this.includePathSupport = includePathSupport;
        this.runConfigs = this.readRunConfigs();
        this.activeConfig = ProjectPropertiesSupport.getPropertyEvaluator(phpProject).getProperty("config");
    }

    @Override
    public String[] getConfigProperties() {
        return CFG_PROPS;
    }

    @Override
    public Map<String, Map<String, String>> getConfigs() {
        return this.runConfigs;
    }

    @Override
    public String getActiveConfig() {
        return this.activeConfig;
    }

    @Override
    public void setActiveConfig(String string) {
        this.activeConfig = string;
    }

    public String getCopySrcFiles() {
        if (this.copySrcFiles == null) {
            this.copySrcFiles = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_FILES);
        }
        return this.copySrcFiles;
    }

    public void setCopySrcFiles(String string) {
        this.copySrcFiles = string;
    }

    public String getCopySrcTarget() {
        if (this.copySrcTarget == null) {
            this.copySrcTarget = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_TARGET);
        }
        return this.copySrcTarget;
    }

    public void setCopySrcTarget(String string) {
        this.copySrcTarget = string;
    }

    public String getShortTags() {
        if (this.shortTags == null) {
            this.shortTags = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SHORT_TAGS);
        }
        return this.shortTags;
    }

    public void setShortTags(String string) {
        this.shortTags = string;
    }

    public String getAspTags() {
        if (this.aspTags == null) {
            this.aspTags = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(ASP_TAGS);
        }
        return this.aspTags;
    }

    public void setAspTags(String string) {
        this.aspTags = string;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            this.webRoot = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(WEB_ROOT);
        }
        return this.webRoot != null ? this.webRoot : "";
    }

    public void setWebRoot(String string) {
        this.webRoot = string;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SOURCE_ENCODING);
        }
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getSrcDir() {
        if (this.srcDir == null) {
            this.srcDir = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SRC_DIR);
        }
        return this.srcDir;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(URL);
        }
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getIndexFile() {
        if (this.indexFile == null) {
            this.indexFile = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(INDEX_FILE);
        }
        return this.indexFile;
    }

    public void setIndexFile(String string) {
        this.indexFile = string;
    }

    public DefaultListModel getIncludePathListModel() {
        if (this.includePathListModel == null) {
            EditableProperties editableProperties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.includePathListModel = IncludePathUiSupport.createListModel(this.includePathSupport.itemsIterator(editableProperties.getProperty(INCLUDE_PATH)));
        }
        return this.includePathListModel;
    }

    public ListCellRenderer getIncludePathListRenderer() {
        if (this.includePathListRenderer == null) {
            this.includePathListRenderer = new IncludePathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.includePathListRenderer;
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    PhpProjectProperties.this.saveProperties();
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void saveProperties() throws IOException {
        AntProjectHelper antProjectHelper = this.project.getHelper();
        String[] stringArray = null;
        if (this.includePathListModel != null) {
            stringArray = this.includePathSupport.encodeToStrings(IncludePathUiSupport.getIterator(this.includePathListModel));
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
        if (this.copySrcFiles != null) {
            editableProperties2.setProperty(COPY_SRC_FILES, this.copySrcFiles);
        }
        if (this.copySrcTarget != null) {
            editableProperties2.setProperty(COPY_SRC_TARGET, this.copySrcTarget);
        }
        if (this.encoding != null) {
            editableProperties.setProperty(SOURCE_ENCODING, this.encoding);
        }
        if (this.webRoot != null) {
            editableProperties.setProperty(WEB_ROOT, this.webRoot);
        }
        if (this.shortTags != null) {
            editableProperties.setProperty(SHORT_TAGS, this.shortTags);
        }
        if (this.aspTags != null) {
            editableProperties.setProperty(ASP_TAGS, this.aspTags);
        }
        if (stringArray != null) {
            editableProperties.setProperty(INCLUDE_PATH, stringArray);
        }
        this.storeRunConfigs(this.runConfigs, editableProperties, editableProperties2);
        EditableProperties editableProperties3 = antProjectHelper.getProperties(CONFIG_PRIVATE_PROPERTIES_PATH);
        if (this.activeConfig == null) {
            editableProperties3.remove((Object)"config");
        } else {
            editableProperties3.setProperty("config", this.activeConfig);
        }
        antProjectHelper.putProperties(CONFIG_PRIVATE_PROPERTIES_PATH, editableProperties3);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        if (this.encoding != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(this.encoding));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        ProjectSettings.resetLastUpload(this.project);
        this.logUsage(antProjectHelper.getProjectDirectory(), ProjectPropertiesSupport.getSourcesDirectory(this.project), this.getActiveRunAsType(), this.getNumOfRunConfigs(), Boolean.valueOf(this.getCopySrcFiles()));
    }

    private String getActiveRunAsType() {
        if (this.activeConfig == null) {
            return "";
        }
        Map<String, String> map = this.runConfigs.get(this.activeConfig);
        return map.get(RUN_AS);
    }

    private int getNumOfRunConfigs() {
        int n = 0;
        for (Map.Entry<String, Map<String, String>> entry : this.runConfigs.entrySet()) {
            Map<String, String> map = entry.getValue();
            if (map == null) continue;
            ++n;
        }
        return n;
    }

    private void logUsage(FileObject fileObject, FileObject fileObject2, String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(200);
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_PHP");
        logRecord.setLoggerName("org.netbeans.ui.metrics.php");
        logRecord.setResourceBundle(NbBundle.getBundle(PhpProjectProperties.class));
        logRecord.setResourceBundleName(PhpProjectProperties.class.getPackage().getName() + ".Bundle");
        logRecord.setParameters(new Object[]{FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", string, Integer.toString(n), bl ? "COPY_FILES_YES" : "COPY_FILES_NO"});
        Logger.getLogger("org.netbeans.ui.metrics.php").log(logRecord);
    }

    public PhpProject getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Map<String, String>> readRunConfigs() {
        Object object;
        Map<String, Map<String, String>> map = ConfigManager.createEmptyConfigs();
        TreeMap<String, void> treeMap = new TreeMap<String, void>();
        EditableProperties editableProperties = this.getProject().getHelper().getProperties("nbproject/private/private.properties");
        EditableProperties editableProperties2 = this.getProject().getHelper().getProperties("nbproject/project.properties");
        for (String string : CFG_PROPS) {
            void string2;
            String string3 = editableProperties.getProperty(string);
            if (string3 == null) {
                String string4 = editableProperties2.getProperty(string);
            }
            if (string2 == null) continue;
            treeMap.put(string, string2);
        }
        map.put(null, treeMap);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.hasExt("properties")) continue;
                object = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject2);
                map.put(fileObject2.getName(), new TreeMap(this.getProject().getHelper().getProperties((String)object)));
            }
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject fileObject3 : fileObject.getChildren()) {
                if (!fileObject3.hasExt("properties") || (object = map.get(fileObject3.getName())) == null) continue;
                String string = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject3);
                object.putAll(new HashMap(this.getProject().getHelper().getProperties(string)));
            }
        }
        return map;
    }

    void storeRunConfigs(Map<String, Map<String, String>> map, EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        Object object;
        String string;
        Map<String, String> map2 = map.get(null);
        for (String string2 : CFG_PROPS) {
            string = map2.get(string2);
            Object object2 = object = this.isPrivateProperty(string2) ? editableProperties2 : editableProperties;
            if (Utilities.compareObjects((Object)string, (Object)object.getProperty(string2))) continue;
            if (string != null && string.length() > 0) {
                object.setProperty(string2, string);
                continue;
            }
            object.remove((Object)string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (string3 == null) continue;
            string2 = "nbproject/configs/" + string3 + ".properties";
            string = "nbproject/private/configs/" + string3 + ".properties";
            object = (Map)entry.getValue();
            if (object == null) {
                this.getProject().getHelper().putProperties(string2, null);
                this.getProject().getHelper().putProperties(string, null);
                continue;
            }
            for (Map.Entry entry2 : object.entrySet()) {
                String string4;
                String string5 = (String)entry2.getKey();
                String string6 = (String)entry2.getValue();
                String string7 = string4 = this.isPrivateProperty(string5) ? string : string2;
                EditableProperties editableProperties3 = this.getProject().getHelper().getProperties(string4);
                if (Utilities.compareObjects((Object)string6, (Object)editableProperties3.getProperty(string5))) continue;
                if (string6 != null && (string6.length() > 0 || map2.get(string5) != null && map2.get(string5).length() > 0)) {
                    editableProperties3.setProperty(string5, string6);
                } else {
                    editableProperties3.remove((Object)string5);
                }
                this.getProject().getHelper().putProperties(string4, editableProperties3);
            }
            this.getProject().getHelper().putProperties(string2, this.getProject().getHelper().getProperties(string2));
        }
    }

    private boolean isPrivateProperty(String string) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugUrl {
        DEFAULT_URL,
        ASK_FOR_URL,
        DO_NOT_OPEN_BROWSER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadFiles {
        MANUALLY("LBL_UploadFilesManually", "TXT_UploadFilesManually"),
        ON_RUN("LBL_UploadFilesOnRun", "TXT_UploadFilesOnRun"),
        ON_SAVE("LBL_UploadFilesOnSave", "TXT_UploadFilesOnSave");

        private final String label;
        private final String description;

        private UploadFiles(String string2, String string3) {
            this.label = NbBundle.getMessage(PhpProjectProperties.class, (String)string2);
            this.description = NbBundle.getMessage(PhpProjectProperties.class, (String)string3);
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunAsType {
        LOCAL,
        SCRIPT,
        REMOTE;

    }
}

