/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.Pair;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.customizer.RunAsWebAdvanced;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RunAsRemoteWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -5593389531357591271L;
    private static final String NO_CONFIG = "no-config";
    private static final String MISSING_CONFIG = "missing-config";
    private static final RemoteConfiguration NO_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("no-config", NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_NoRemoteConfiguration"));
    private static final RemoteConfiguration MISSING_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("missing-config", NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_MissingRemoteConfiguration"));
    private static final PhpProjectProperties.UploadFiles DEFAULT_UPLOAD_FILES = PhpProjectProperties.UploadFiles.ON_RUN;
    private final PhpProjectProperties properties;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    final ProjectCustomizer.Category category;
    private JButton advancedButton;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton manageRemoteConnectionButton;
    private JCheckBox preservePermissionsCheckBox;
    private JLabel preservePermissionsLabel;
    private JComboBox remoteConnectionComboBox;
    private JLabel remoteConnectionHintLabel;
    private JLabel remoteConnectionLabel;
    private JComboBox runAsComboBox;
    private JLabel runAsLabel;
    private JCheckBox uploadDirectlyCheckBox;
    private JLabel uploadDirectlyLabel;
    private JLabel uploadDirectoryLabel;
    private JTextField uploadDirectoryTextField;
    private JComboBox uploadFilesComboBox;
    private JLabel uploadFilesHintLabel;
    private JLabel uploadFilesLabel;
    private JTextArea urlHintLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsRemoteWeb(PhpProjectProperties phpProjectProperties, ConfigManager configManager, ProjectCustomizer.Category category) {
        super(configManager);
        this.properties = phpProjectProperties;
        this.category = category;
        this.project = phpProjectProperties.getProject();
        this.displayName = NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ConfigRemoteWeb");
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel, this.uploadDirectoryLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField, this.uploadDirectoryTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments", "remote.directory"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        this.populateRemoteConnectionComboBox();
        this.remoteConnectionComboBox.setRenderer(new RemoteConnectionRenderer());
        for (PhpProjectProperties.UploadFiles uploadFiles : PhpProjectProperties.UploadFiles.values()) {
            this.uploadFilesComboBox.addItem(uploadFiles);
        }
        this.uploadFilesComboBox.setRenderer(new RemoteUploadRenderer());
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                RemoteConfiguration remoteConfiguration = (RemoteConfiguration)jComboBox.getSelectedItem();
                assert (remoteConfiguration != null);
                return remoteConfiguration.getName();
            }
        };
        this.remoteConnectionComboBox.addActionListener(new ComboBoxUpdater("remote.connection", this.remoteConnectionLabel, this.remoteConnectionComboBox, comboBoxSelectedItemConvertor));
        ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor2 = new ComboBoxSelectedItemConvertor(){

            public String convert(JComboBox jComboBox) {
                PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)jComboBox.getSelectedItem());
                assert (uploadFiles != null);
                RunAsRemoteWeb.this.uploadFilesHintLabel.setText(uploadFiles.getDescription());
                return uploadFiles.name();
            }
        };
        this.uploadFilesComboBox.addActionListener(new ComboBoxUpdater("remote.upload", this.uploadFilesLabel, this.uploadFilesComboBox, comboBoxSelectedItemConvertor2));
        this.remoteConnectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.uploadDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.updateRemoteConnectionHint();
        this.preservePermissionsCheckBox.addActionListener(new CheckBoxUpdater("remote.permissions", this.preservePermissionsCheckBox));
        this.uploadDirectlyCheckBox.addActionListener(new CheckBoxUpdater("remote.upload.directly", this.uploadDirectlyCheckBox));
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.REMOTE;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected JComboBox getRunAsCombo() {
        return this.runAsComboBox;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
        this.selectRemoteConnection();
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String string = this.getValue("remote.upload");
        if (string == null) {
            uploadFiles = DEFAULT_UPLOAD_FILES;
        } else {
            try {
                uploadFiles = PhpProjectProperties.UploadFiles.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uploadFiles = DEFAULT_UPLOAD_FILES;
            }
        }
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
        boolean bl = Boolean.parseBoolean(this.getValue("remote.permissions"));
        this.preservePermissionsCheckBox.setSelected(bl);
        boolean bl2 = Boolean.parseBoolean(this.getValue("remote.upload.directly"));
        this.uploadDirectlyCheckBox.setSelected(bl2);
    }

    protected void validateFields() {
        String string = this.urlTextField.getText();
        String string2 = this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText();
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
        assert (remoteConfiguration != null);
        if (remoteConfiguration == NO_REMOTE_CONFIGURATION) {
            this.validateCategory(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NoConfigurationSelected"));
            return;
        }
        if (remoteConfiguration == MISSING_REMOTE_CONFIGURATION) {
            this.validateCategory(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NonExistingConfigurationSelected"));
            return;
        }
        String string4 = RunAsValidator.validateUploadDirectory(this.uploadDirectoryTextField.getText(), true);
        if (string4 != null) {
            this.validateCategory(string4);
            return;
        }
        if (!PhpProjectUtils.hasText(string2)) {
            string2 = null;
        }
        if ((string4 = RunAsValidator.validateWebFields(string, FileUtil.toFile((FileObject)this.getWebRoot()), string2, string3)) != null) {
            this.validateCategory(string4);
            return;
        }
        this.validateCategory(null);
    }

    private void validateCategory(String string) {
        this.category.setErrorMessage(string);
        this.category.setValid(true);
    }

    private FileObject getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void populateRemoteConnectionComboBox() {
        List<RemoteConfiguration> list = RemoteConnections.get().getRemoteConfigurations();
        if (list.isEmpty()) {
            list = Arrays.asList(NO_REMOTE_CONFIGURATION);
        }
        DefaultComboBoxModel<RemoteConfiguration> defaultComboBoxModel = new DefaultComboBoxModel<RemoteConfiguration>(new Vector<RemoteConfiguration>(list));
        this.remoteConnectionComboBox.setModel(defaultComboBoxModel);
    }

    private void selectRemoteConnection() {
        this.selectRemoteConnection(null);
    }

    private void selectRemoteConnection(String string) {
        if (string == null) {
            string = this.getValue("remote.connection");
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.remoteConnectionComboBox.getModel();
        if (string == null || NO_CONFIG.equals(string)) {
            if (defaultComboBoxModel.getIndexOf(NO_REMOTE_CONFIGURATION) < 0) {
                defaultComboBoxModel.insertElementAt(NO_REMOTE_CONFIGURATION, 0);
            }
            this.remoteConnectionComboBox.setSelectedItem(NO_REMOTE_CONFIGURATION);
            return;
        }
        int n = this.remoteConnectionComboBox.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getItemAt(i);
            if (!string.equals(remoteConfiguration.getName())) continue;
            this.remoteConnectionComboBox.setSelectedItem(remoteConfiguration);
            return;
        }
        this.remoteConnectionComboBox.addItem(MISSING_REMOTE_CONFIGURATION);
        this.remoteConnectionComboBox.setSelectedItem(MISSING_REMOTE_CONFIGURATION);
        defaultComboBoxModel.removeElement(NO_REMOTE_CONFIGURATION);
    }

    void updateRemoteConnectionHint() {
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem();
        if (remoteConfiguration == NO_REMOTE_CONFIGURATION || remoteConfiguration == MISSING_REMOTE_CONFIGURATION) {
            this.remoteConnectionHintLabel.setText(" ");
            return;
        }
        this.remoteConnectionHintLabel.setText(remoteConfiguration.getUrl(this.uploadDirectoryTextField.getText()));
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.urlHintLabel = new JTextArea();
        this.remoteConnectionLabel = new JLabel();
        this.remoteConnectionComboBox = new JComboBox();
        this.manageRemoteConnectionButton = new JButton();
        this.uploadDirectoryLabel = new JLabel();
        this.uploadDirectoryTextField = new JTextField();
        this.remoteConnectionHintLabel = new JLabel();
        this.uploadFilesLabel = new JLabel();
        this.uploadFilesComboBox = new JComboBox();
        this.uploadFilesHintLabel = new JLabel();
        this.preservePermissionsCheckBox = new JCheckBox();
        this.preservePermissionsLabel = new JLabel();
        this.uploadDirectlyCheckBox = new JCheckBox();
        this.uploadDirectlyLabel = new JLabel();
        this.advancedButton = new JButton();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return RunAsRemoteWeb.this.urlHintLabel;
            }

            public Component getFirstComponent(Container container) {
                return RunAsRemoteWeb.this.urlHintLabel;
            }

            public Component getLastComponent(Container container) {
                return RunAsRemoteWeb.this.advancedButton;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == RunAsRemoteWeb.this.urlHintLabel) {
                    return RunAsRemoteWeb.this.remoteConnectionComboBox;
                }
                if (component == RunAsRemoteWeb.this.runAsComboBox) {
                    return RunAsRemoteWeb.this.urlTextField;
                }
                if (component == RunAsRemoteWeb.this.remoteConnectionComboBox) {
                    return RunAsRemoteWeb.this.manageRemoteConnectionButton;
                }
                if (component == RunAsRemoteWeb.this.manageRemoteConnectionButton) {
                    return RunAsRemoteWeb.this.uploadDirectoryTextField;
                }
                if (component == RunAsRemoteWeb.this.uploadDirectoryTextField) {
                    return RunAsRemoteWeb.this.uploadFilesComboBox;
                }
                if (component == RunAsRemoteWeb.this.indexFileTextField) {
                    return RunAsRemoteWeb.this.indexFileBrowseButton;
                }
                if (component == RunAsRemoteWeb.this.urlTextField) {
                    return RunAsRemoteWeb.this.indexFileTextField;
                }
                if (component == RunAsRemoteWeb.this.uploadDirectlyCheckBox) {
                    return RunAsRemoteWeb.this.advancedButton;
                }
                if (component == RunAsRemoteWeb.this.preservePermissionsCheckBox) {
                    return RunAsRemoteWeb.this.uploadDirectlyCheckBox;
                }
                if (component == RunAsRemoteWeb.this.uploadFilesComboBox) {
                    return RunAsRemoteWeb.this.preservePermissionsCheckBox;
                }
                if (component == RunAsRemoteWeb.this.indexFileBrowseButton) {
                    return RunAsRemoteWeb.this.argsTextField;
                }
                if (component == RunAsRemoteWeb.this.argsTextField) {
                    return RunAsRemoteWeb.this.urlHintLabel;
                }
                return RunAsRemoteWeb.this.urlHintLabel;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == RunAsRemoteWeb.this.remoteConnectionComboBox) {
                    return RunAsRemoteWeb.this.urlHintLabel;
                }
                if (component == RunAsRemoteWeb.this.urlTextField) {
                    return RunAsRemoteWeb.this.runAsComboBox;
                }
                if (component == RunAsRemoteWeb.this.manageRemoteConnectionButton) {
                    return RunAsRemoteWeb.this.remoteConnectionComboBox;
                }
                if (component == RunAsRemoteWeb.this.uploadDirectoryTextField) {
                    return RunAsRemoteWeb.this.manageRemoteConnectionButton;
                }
                if (component == RunAsRemoteWeb.this.uploadFilesComboBox) {
                    return RunAsRemoteWeb.this.uploadDirectoryTextField;
                }
                if (component == RunAsRemoteWeb.this.indexFileBrowseButton) {
                    return RunAsRemoteWeb.this.indexFileTextField;
                }
                if (component == RunAsRemoteWeb.this.indexFileTextField) {
                    return RunAsRemoteWeb.this.urlTextField;
                }
                if (component == RunAsRemoteWeb.this.advancedButton) {
                    return RunAsRemoteWeb.this.uploadDirectlyCheckBox;
                }
                if (component == RunAsRemoteWeb.this.uploadDirectlyCheckBox) {
                    return RunAsRemoteWeb.this.preservePermissionsCheckBox;
                }
                if (component == RunAsRemoteWeb.this.preservePermissionsCheckBox) {
                    return RunAsRemoteWeb.this.uploadFilesComboBox;
                }
                if (component == RunAsRemoteWeb.this.argsTextField) {
                    return RunAsRemoteWeb.this.indexFileBrowseButton;
                }
                if (component == RunAsRemoteWeb.this.urlHintLabel) {
                    return RunAsRemoteWeb.this.argsTextField;
                }
                return RunAsRemoteWeb.this.advancedButton;
            }
        });
        this.runAsLabel.setLabelFor(this.runAsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ProjectUrl"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Arguments"));
        this.urlHintLabel.setEditable(false);
        this.urlHintLabel.setLineWrap(true);
        this.urlHintLabel.setRows(2);
        this.urlHintLabel.setWrapStyleWord(true);
        this.urlHintLabel.setBorder(null);
        this.urlHintLabel.setDisabledTextColor(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.urlHintLabel.setEnabled(false);
        this.urlHintLabel.setOpaque(false);
        this.remoteConnectionLabel.setLabelFor(this.remoteConnectionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RemoteConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageRemoteConnectionButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Manage"));
        this.manageRemoteConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.manageRemoteConnectionButtonActionPerformed(actionEvent);
            }
        });
        this.uploadDirectoryLabel.setLabelFor(this.uploadDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectoryLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadDirectory"));
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionHintLabel, (String)"dummy");
        this.remoteConnectionHintLabel.setEnabled(false);
        this.uploadFilesLabel.setLabelFor(this.uploadFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadFiles"));
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesHintLabel, (String)"dummy");
        this.uploadFilesHintLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.preservePermissionsCheckBox, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsCheckBox.text"));
        this.preservePermissionsLabel.setLabelFor(this.preservePermissionsCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.preservePermissionsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsLabel.text"));
        this.preservePermissionsLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.uploadDirectlyCheckBox, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyCheckBox.text"));
        this.uploadDirectlyLabel.setLabelFor(this.uploadDirectlyCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectlyLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyLabel.text"));
        this.uploadDirectlyLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.text"));
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsRemoteWeb.this.advancedButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.remoteConnectionLabel).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadFilesLabel).add((Component)this.urlLabel).add((Component)this.runAsLabel).add((Component)this.indexFileLabel).add((Component)this.argsLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionHintLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.urlTextField, -1, 322, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 225, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add((Component)this.argsTextField, -1, 322, Short.MAX_VALUE).add(1, (Component)this.uploadFilesHintLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteConnectionComboBox, 0, 225, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.manageRemoteConnectionButton)).add(1, (Component)this.uploadDirectoryTextField, -1, 322, Short.MAX_VALUE).add(1, (Component)this.uploadFilesComboBox, 0, 322, Short.MAX_VALUE).add(1, (Component)this.runAsComboBox, 0, 322, Short.MAX_VALUE).add(1, (Component)this.urlHintLabel, -1, 322, Short.MAX_VALUE).add((Component)this.advancedButton)).add(0, 0, 0)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.preservePermissionsCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.preservePermissionsLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.uploadDirectlyCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.uploadDirectlyLabel).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.indexFileBrowseButton, this.manageRemoteConnectionButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsComboBox, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileLabel).add((Component)this.indexFileTextField, -2, -1, -2).add((Component)this.indexFileBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.argsLabel).add((Component)this.argsTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.urlHintLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.remoteConnectionLabel).add((Component)this.manageRemoteConnectionButton).add((Component)this.remoteConnectionComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadDirectoryLabel).add((Component)this.uploadDirectoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.remoteConnectionHintLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uploadFilesLabel).add((Component)this.uploadFilesComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.uploadFilesHintLabel).addPreferredGap(0).add((Component)this.preservePermissionsCheckBox).addPreferredGap(0).add((Component)this.preservePermissionsLabel).addPreferredGap(0).add((Component)this.uploadDirectlyCheckBox).addPreferredGap(0).add((Component)this.uploadDirectlyLabel).addPreferredGap(1).add((Component)this.advancedButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleName"));
        this.runAsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.urlHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlHintLabel.AccessibleContext.accessibleName"));
        this.urlHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlHintLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleName"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleDescription"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleName"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleName"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleName"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleName"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleName"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleDescription"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleName"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleDescription"));
        this.preservePermissionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsCheckBox.AccessibleContext.accessibleDescription"));
        this.preservePermissionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.preservePermissionsLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectlyCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyCheckBox.AccessibleContext.accessibleDescription"));
        this.uploadDirectlyLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectlyLabel.AccessibleContext.accessibleDescription"));
        this.advancedButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.AccessibleContext.accessibleName"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.advancedButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleDescription"));
    }

    private void manageRemoteConnectionButtonActionPerformed(ActionEvent actionEvent) {
        if (RemoteConnections.get().openManager((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem())) {
            this.populateRemoteConnectionComboBox();
            String string = null;
            ComboBoxModel comboBoxModel = this.remoteConnectionComboBox.getModel();
            if (comboBoxModel.getSize() == 1) {
                string = ((RemoteConfiguration)comboBoxModel.getElementAt(0)).getName();
            }
            this.selectRemoteConnection(string);
        }
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseFolderFile(this.getWebRoot(), this.indexFileTextField);
    }

    private void advancedButtonActionPerformed(ActionEvent actionEvent) {
        RunAsWebAdvanced.Properties properties = new RunAsWebAdvanced.Properties(this.getValue("debug.url"), this.urlHintLabel.getText(), this.getValue("debug.path.mapping.remote"), this.getValue("debug.path.mapping.local"), this.getValue("debug.proxy.host"), this.getValue("debug.proxy.port"));
        RunAsWebAdvanced runAsWebAdvanced = new RunAsWebAdvanced(this.project, properties);
        if (runAsWebAdvanced.open()) {
            Pair<String, String> pair = runAsWebAdvanced.getPathMapping();
            Pair<String, String> pair2 = runAsWebAdvanced.getDebugProxy();
            this.putValue("debug.url", runAsWebAdvanced.getDebugUrl().name());
            this.putValue("debug.path.mapping.remote", (String)pair.first);
            this.putValue("debug.path.mapping.local", (String)pair.second);
            this.putValue("debug.proxy.host", (String)pair2.first);
            this.putValue("debug.proxy.port", (String)pair2.second);
        }
    }

    private static class RemoteUploadRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 86192358777523629L;

        public RemoteUploadRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof PhpProjectProperties.UploadFiles);
            this.setName("ComboBox.listRenderer");
            this.setText(((PhpProjectProperties.UploadFiles)((Object)object)).getLabel());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private static class RemoteConnectionRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 93621381917558630L;

        public RemoteConnectionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof RemoteConfiguration);
            this.setName("ComboBox.listRenderer");
            RemoteConfiguration remoteConfiguration = (RemoteConfiguration)object;
            this.setText(remoteConfiguration.getDisplayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setBackground(jList.getBackground());
            }
            this.setForeground(this.getForeground(remoteConfiguration, jList, bl));
            return this;
        }

        private Color getForeground(RemoteConfiguration remoteConfiguration, JList jList, boolean bl) {
            if (remoteConfiguration == MISSING_REMOTE_CONFIGURATION || remoteConfiguration == NO_REMOTE_CONFIGURATION) {
                return UIManager.getColor("nb.errorForeground");
            }
            return bl ? jList.getSelectionForeground() : jList.getForeground();
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class CheckBoxUpdater
    implements ActionListener {
        private final JCheckBox field;
        private final String propName;

        public CheckBoxUpdater(String string, JCheckBox jCheckBox) {
            this.field = jCheckBox;
            this.propName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Boolean.toString(this.field.isSelected());
            RunAsRemoteWeb.this.putValue(this.propName, string);
            RunAsRemoteWeb.this.markAsModified(this.field, this.propName, string);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    private class ComboBoxUpdater
    implements ActionListener {
        private final JLabel label;
        private final JComboBox field;
        private final String propName;
        private final ComboBoxSelectedItemConvertor comboBoxConvertor;

        public ComboBoxUpdater(String string, JLabel jLabel, JComboBox jComboBox, ComboBoxSelectedItemConvertor comboBoxSelectedItemConvertor) {
            this.propName = string;
            this.label = jLabel;
            this.field = jComboBox;
            this.comboBoxConvertor = comboBoxSelectedItemConvertor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.comboBoxConvertor.convert(this.field);
            RunAsRemoteWeb.this.putValue(this.propName, string);
            RunAsRemoteWeb.this.markAsModified(this.label, this.propName, string);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    static interface ComboBoxSelectedItemConvertor {
        public String convert(JComboBox var1);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsRemoteWeb.this.getDefaultValue(this.getPropName());
        }

        protected void processUpdate() {
            super.processUpdate();
            String string = "";
            try {
                string = RunAsValidator.composeUrlHint(RunAsRemoteWeb.this.urlTextField.getText(), RunAsRemoteWeb.this.indexFileTextField.getText(), RunAsRemoteWeb.this.argsTextField.getText());
            }
            catch (RunAsValidator.InvalidUrlException invalidUrlException) {
                RunAsRemoteWeb.this.category.setErrorMessage(invalidUrlException.getMessage());
                RunAsRemoteWeb.this.category.setValid(false);
            }
            RunAsRemoteWeb.this.urlHintLabel.setText(string);
        }
    }
}

