/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class RunAsScript
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -559447897914071L;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    private final PropertyChangeListener phpInterpreterListener;
    final ProjectCustomizer.Category category;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton configureButton;
    private JCheckBox defaultInterpreterCheckBox;
    private JLabel hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton interpreterBrowseButton;
    private JLabel interpreterLabel;
    private JTextField interpreterTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;

    public RunAsScript(PhpProject phpProject, ConfigManager configManager, ProjectCustomizer.Category category) {
        this(phpProject, configManager, category, NbBundle.getMessage(RunAsScript.class, (String)"LBL_ConfigScript"));
    }

    private RunAsScript(PhpProject phpProject, ConfigManager configManager, ProjectCustomizer.Category category, String string) {
        super(configManager);
        this.project = phpProject;
        this.category = category;
        this.displayName = string;
        this.initComponents();
        this.labels = new JLabel[]{this.indexFileLabel, this.interpreterLabel, this.argsLabel};
        this.textFields = new JTextField[]{this.indexFileTextField, this.interpreterTextField, this.argsTextField};
        this.propertyNames = new String[]{"index.file", "interpreter", "script.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
        this.defaultInterpreterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RunAsScript.this.defaultInterpreterCheckBox.isSelected();
                RunAsScript.this.interpreterBrowseButton.setEnabled(!bl);
                RunAsScript.this.interpreterTextField.setEditable(!bl);
                String string = null;
                string = bl ? RunAsScript.this.getDefaultPhpInterpreter() : RunAsScript.this.interpreterTextField.getText();
                RunAsScript.this.interpreterTextField.setText(string + " ");
            }
        });
        this.phpInterpreterListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("propPhpInterpreter".equals(propertyChangeEvent.getPropertyName()) && RunAsScript.this.defaultInterpreterCheckBox.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RunAsScript.this.interpreterTextField.setText(RunAsScript.this.getDefaultPhpInterpreter());
                            RunAsScript.this.composeHint();
                        }
                    });
                }
            }
        };
        PhpOptions phpOptions = PhpOptions.getInstance();
        phpOptions.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.phpInterpreterListener, (Object)phpOptions));
        this.composeHint();
    }

    private String getDefaultPhpInterpreter() {
        String string = PhpOptions.getInstance().getPhpInterpreter();
        return string != null ? string : "";
    }

    private String initPhpInterpreterFields() {
        String string = this.getValue("interpreter");
        boolean bl = string == null || string.length() == 0;
        this.defaultInterpreterCheckBox.setSelected(bl);
        this.interpreterBrowseButton.setEnabled(!bl);
        this.interpreterTextField.setEditable(!bl);
        if (bl) {
            return this.getDefaultPhpInterpreter();
        }
        return string;
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.SCRIPT;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            String string = this.getValue(this.propertyNames[i]);
            if ("interpreter".equals(this.propertyNames[i])) {
                string = this.initPhpInterpreterFields();
            }
            this.textFields[i].setText(string);
        }
    }

    protected void validateFields() {
        String string = this.interpreterTextField.getText().trim();
        String string2 = this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText().trim();
        String string4 = RunAsValidator.validateScriptFields(string, FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(this.project)), string2, string3);
        this.category.setErrorMessage(string4);
        this.category.setValid(true);
    }

    void composeHint() {
        String string = this.interpreterTextField.getText();
        String string2 = "./" + this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText();
        this.hintLabel.setText(string + " " + string2 + " " + string3);
    }

    private void initComponents() {
        this.interpreterLabel = new JLabel();
        this.interpreterTextField = new JTextField();
        this.interpreterBrowseButton = new JButton();
        this.defaultInterpreterCheckBox = new JCheckBox();
        this.configureButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.hintLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return RunAsScript.this.argsTextField;
            }

            public Component getFirstComponent(Container container) {
                return RunAsScript.this.argsTextField;
            }

            public Component getLastComponent(Container container) {
                return RunAsScript.this.argsTextField;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == RunAsScript.this.runAsCombo) {
                    return RunAsScript.this.interpreterTextField;
                }
                if (component == RunAsScript.this.interpreterBrowseButton) {
                    return RunAsScript.this.defaultInterpreterCheckBox;
                }
                if (component == RunAsScript.this.defaultInterpreterCheckBox) {
                    return RunAsScript.this.configureButton;
                }
                if (component == RunAsScript.this.configureButton) {
                    return RunAsScript.this.indexFileTextField;
                }
                if (component == RunAsScript.this.indexFileTextField) {
                    return RunAsScript.this.indexFileBrowseButton;
                }
                if (component == RunAsScript.this.interpreterTextField) {
                    return RunAsScript.this.interpreterBrowseButton;
                }
                if (component == RunAsScript.this.indexFileBrowseButton) {
                    return RunAsScript.this.argsTextField;
                }
                return RunAsScript.this.argsTextField;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == RunAsScript.this.interpreterTextField) {
                    return RunAsScript.this.runAsCombo;
                }
                if (component == RunAsScript.this.defaultInterpreterCheckBox) {
                    return RunAsScript.this.interpreterBrowseButton;
                }
                if (component == RunAsScript.this.configureButton) {
                    return RunAsScript.this.defaultInterpreterCheckBox;
                }
                if (component == RunAsScript.this.indexFileTextField) {
                    return RunAsScript.this.configureButton;
                }
                if (component == RunAsScript.this.indexFileBrowseButton) {
                    return RunAsScript.this.indexFileTextField;
                }
                if (component == RunAsScript.this.interpreterBrowseButton) {
                    return RunAsScript.this.interpreterTextField;
                }
                if (component == RunAsScript.this.argsTextField) {
                    return RunAsScript.this.indexFileBrowseButton;
                }
                return RunAsScript.this.argsTextField;
            }
        });
        this.interpreterLabel.setLabelFor(this.interpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.interpreterLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_PhpInterpreter"));
        this.interpreterTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.interpreterBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_BrowseInterpreter"));
        this.interpreterBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.interpreterBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.defaultInterpreterCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultInterpreterCheckBox, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_UseDefaultInterpreter"));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Configure"));
        this.configureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.configureButtonActionPerformed(actionEvent);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Arguments"));
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_RunAs"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsScript.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"dummy");
        this.hintLabel.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.runAsLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.interpreterLabel).add((Component)this.indexFileLabel).add((Component)this.argsLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.hintLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.argsTextField, -1, 302, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 191, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add(2, (Component)this.runAsCombo, 0, 302, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.interpreterTextField, -1, 191, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.interpreterBrowseButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.defaultInterpreterCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.configureButton))).add(0, 0, 0)))));
        groupLayout.linkSize(new Component[]{this.configureButton, this.indexFileBrowseButton, this.interpreterBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsLabel).add((Component)this.runAsCombo, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.interpreterLabel).add((Component)this.interpreterBrowseButton).add((Component)this.interpreterTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.defaultInterpreterCheckBox).add((Component)this.configureButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.indexFileTextField, -2, -1, -2).add((Component)this.indexFileLabel).add((Component)this.indexFileBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.argsTextField, -2, 19, -2).add((Component)this.argsLabel)).addPreferredGap(0).add((Component)this.hintLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.interpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleName"));
        this.interpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleDescription"));
        this.interpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleName"));
        this.interpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleDescription"));
        this.interpreterBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterBrowseButton.AccessibleContext.accessibleName"));
        this.interpreterBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterBrowseButton.AccessibleContext.accessibleDescription"));
        this.defaultInterpreterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.defaultInterpreterCheckBox.AccessibleContext.accessibleName"));
        this.defaultInterpreterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.defaultInterpreterCheckBox.AccessibleContext.accessibleDescription"));
        this.configureButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleName"));
        this.configureButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsTextField.AccessibleContext.accessibleDescription"));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.hintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.hintLabel.AccessibleContext.accessibleName"));
        this.hintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.hintLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleDescription"));
    }

    private void configureButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory");
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseSourceFile(this.project, this.indexFileTextField);
    }

    private void interpreterBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browsePhpInterpreter(this, this.interpreterTextField);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsScript.this.getDefaultValue(this.getPropName());
        }

        protected void processUpdate() {
            super.processUpdate();
            RunAsScript.this.composeHint();
        }

        protected String getPropValue() {
            if ("interpreter".equals(this.getPropName()) && RunAsScript.this.defaultInterpreterCheckBox.isSelected()) {
                return "";
            }
            return super.getPropValue().trim();
        }
    }
}

