/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;

public class PhpSourcesFilter
implements ChangeListener,
ChangeableDataFilter {
    private static final long serialVersionUID = -74397897465486955L;
    private final PhpProject project;
    private final FileObject rootFolder;
    private final File nbProject;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public PhpSourcesFilter(PhpProject phpProject) {
        this(phpProject, null);
    }

    public PhpSourcesFilter(PhpProject phpProject, FileObject fileObject) {
        assert (phpProject != null);
        this.project = phpProject;
        this.rootFolder = fileObject;
        this.nbProject = phpProject.getHelper().resolveFile("nbproject/project.xml").getParentFile();
        assert (this.nbProject != null) : "NB metadata folder was not found for project: " + phpProject;
        VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
    }

    public boolean acceptDataObject(DataObject dataObject) {
        return !this.isProjectFile(dataObject) && !this.isTestDirectory(dataObject) && !this.isSeleniumDirectory(dataObject) && VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile());
    }

    private boolean isProjectFile(DataObject dataObject) {
        File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
        return this.nbProject.equals(file);
    }

    private boolean isTestDirectory(DataObject dataObject) {
        return this.isDirectory(dataObject, ProjectPropertiesSupport.getTestDirectory(this.project, false));
    }

    private boolean isSeleniumDirectory(DataObject dataObject) {
        return this.isDirectory(dataObject, ProjectPropertiesSupport.getSeleniumDirectory(this.project, false));
    }

    private boolean isDirectory(DataObject dataObject, FileObject fileObject) {
        if (this.rootFolder == null || fileObject == null) {
            return false;
        }
        if (!fileObject.equals(this.rootFolder)) {
            return fileObject.equals(dataObject.getPrimaryFile());
        }
        return false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }
}

