/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.ui.options.PhpOptionsPanel;
import org.netbeans.modules.php.project.util.PhpUnit;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private static final String TAB_FOLDER = "org.netbeans.modules.php/options/";
    private final PhpOptionsPanel phpOptionsPanel = new PhpOptionsPanel();
    private final Collection<? extends AdvancedOption> options;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Map<OptionsPanelController, AdvancedOption> controllers2Options;
    private JTabbedPane pane;
    private boolean changed;

    public PhpOptionsPanelController() {
        this.options = Lookups.forPath((String)TAB_FOLDER).lookupAll(AdvancedOption.class);
        this.phpOptionsPanel.addChangeListener(this);
    }

    private synchronized Map<OptionsPanelController, AdvancedOption> getControllers2Options() {
        if (this.controllers2Options == null) {
            this.controllers2Options = new LinkedHashMap<OptionsPanelController, AdvancedOption>();
            for (AdvancedOption advancedOption : this.options) {
                OptionsPanelController optionsPanelController = advancedOption.create();
                this.controllers2Options.put(optionsPanelController, advancedOption);
            }
        }
        return this.controllers2Options;
    }

    private Set<OptionsPanelController> getControllers() {
        return this.getControllers2Options().keySet();
    }

    public void update() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.update();
        }
        this.phpOptionsPanel.setPhpInterpreter(this.getPhpOptions().getPhpInterpreter());
        this.phpOptionsPanel.setOpenResultInOutputWindow(this.getPhpOptions().isOpenResultInOutputWindow());
        this.phpOptionsPanel.setOpenResultInBrowser(this.getPhpOptions().isOpenResultInBrowser());
        this.phpOptionsPanel.setOpenResultInEditor(this.getPhpOptions().isOpenResultInEditor());
        this.phpOptionsPanel.setDebuggerPort(this.getPhpOptions().getDebuggerPort());
        this.phpOptionsPanel.setDebuggerSessionId(this.getPhpOptions().getDebuggerSessionId());
        this.phpOptionsPanel.setDebuggerStoppedAtTheFirstLine(this.getPhpOptions().isDebuggerStoppedAtTheFirstLine());
        this.phpOptionsPanel.setPhpUnit(this.getPhpOptions().getPhpUnit());
        this.changed = false;
    }

    public void applyChanges() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.applyChanges();
        }
        this.getPhpOptions().setPhpInterpreter(this.phpOptionsPanel.getPhpInterpreter());
        this.getPhpOptions().setOpenResultInOutputWindow(this.phpOptionsPanel.isOpenResultInOutputWindow());
        this.getPhpOptions().setOpenResultInBrowser(this.phpOptionsPanel.isOpenResultInBrowser());
        this.getPhpOptions().setOpenResultInEditor(this.phpOptionsPanel.isOpenResultInEditor());
        this.getPhpOptions().setDebuggerPort(this.phpOptionsPanel.getDebuggerPort());
        this.getPhpOptions().setDebuggerSessionId(this.phpOptionsPanel.getDebuggerSessionId());
        this.getPhpOptions().setDebuggerStoppedAtTheFirstLine(this.phpOptionsPanel.isDebuggerStoppedAtTheFirstLine());
        this.getPhpOptions().setPhpGlobalIncludePath(this.phpOptionsPanel.getPhpGlobalIncludePath());
        this.getPhpOptions().setPhpUnit(this.phpOptionsPanel.getPhpUnit());
        this.changed = false;
    }

    public void cancel() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.cancel();
        }
    }

    public boolean isValid() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            if (optionsPanelController.isValid()) continue;
            return false;
        }
        return this.validateComponent();
    }

    public boolean isChanged() {
        Object object2;
        for (Object object2 : this.getControllers()) {
            if (!object2.isChanged()) continue;
            return true;
        }
        if (!this.phpOptionsPanel.getPhpInterpreter().equals(this.getPhpOptions().getPhpInterpreter())) {
            return true;
        }
        if (this.getPhpOptions().isOpenResultInOutputWindow() != this.phpOptionsPanel.isOpenResultInOutputWindow()) {
            return true;
        }
        if (this.getPhpOptions().isOpenResultInBrowser() != this.phpOptionsPanel.isOpenResultInBrowser()) {
            return true;
        }
        if (this.getPhpOptions().isOpenResultInEditor() != this.phpOptionsPanel.isOpenResultInEditor()) {
            return true;
        }
        Integer n = this.phpOptionsPanel.getDebuggerPort();
        if (n != null && this.getPhpOptions().getDebuggerPort() != n.intValue()) {
            return true;
        }
        object2 = this.phpOptionsPanel.getDebuggerSessionId();
        if (object2 != null && !this.getPhpOptions().getDebuggerSessionId().equals(object2)) {
            return true;
        }
        if (this.getPhpOptions().isDebuggerStoppedAtTheFirstLine() != this.phpOptionsPanel.isDebuggerStoppedAtTheFirstLine()) {
            return true;
        }
        if (!this.phpOptionsPanel.getPhpUnit().equals(this.getPhpOptions().getPhpUnit())) {
            return true;
        }
        return !this.getPhpOptions().getPhpGlobalIncludePath().equals(this.phpOptionsPanel.getPhpGlobalIncludePath());
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.pane == null) {
            this.pane = new JTabbedPane();
            this.pane.add(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"LBL_GeneralOPtions"), this.phpOptionsPanel);
            for (Map.Entry<OptionsPanelController, AdvancedOption> entry : this.getControllers2Options().entrySet()) {
                OptionsPanelController optionsPanelController = entry.getKey();
                AdvancedOption advancedOption = entry.getValue();
                this.pane.add(advancedOption.getDisplayName(), optionsPanelController.getComponent(optionsPanelController.getLookup()));
            }
        }
        return this.pane;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changed();
    }

    private boolean validateComponent() {
        Integer n = this.phpOptionsPanel.getDebuggerPort();
        if (n == null || n < 1) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidPort"));
            return false;
        }
        String string = this.phpOptionsPanel.getDebuggerSessionId();
        if (string == null || string.trim().length() == 0 || string.contains(" ")) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidSessionId"));
            return false;
        }
        String string2 = Utils.validatePhpInterpreter(this.phpOptionsPanel.getPhpInterpreter());
        if (string2 != null) {
            this.phpOptionsPanel.setWarning(string2);
            return true;
        }
        string2 = Utils.validatePhpUnit(this.phpOptionsPanel.getPhpUnit());
        if (string2 != null) {
            this.phpOptionsPanel.setWarning(string2);
            return true;
        }
        PhpUnit.resetVersion();
        PhpUnit phpUnit = new PhpUnit(this.phpOptionsPanel.getPhpUnit());
        if (!phpUnit.supportedVersionFound()) {
            this.phpOptionsPanel.setWarning(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_OldPhpUnit", (Object[])PhpUnit.getVersions(phpUnit)));
            return true;
        }
        this.phpOptionsPanel.setError(" ");
        return true;
    }

    private void changed() {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }
}

