/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.util.FileOperationFactory;
import org.netbeans.modules.php.project.util.LocalOperationFactory;
import org.netbeans.modules.php.project.util.RemoteOperationFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopySupport
extends FileChangeAdapter
implements PropertyChangeListener,
FileChangeListener {
    private static final int PROGRESS_INITIAL_DELAY = 1000;
    private volatile PhpProject project;
    private volatile boolean isProjectOpened;
    private ProxyOperationFactory operationFactory;
    private FileSystem fileSystem;
    private FileChangeListener weakFileChangeListener;
    private static final RequestProcessor RP = new RequestProcessor("PHP file change handler");
    private static final Queue<Callable<Boolean>> operationsQueue = new ConcurrentLinkedQueue<Callable<Boolean>>();
    private static final RequestProcessor.Task processingTask = CopySupport.createProcessingTask();
    private static final Logger LOGGER = Logger.getLogger(CopySupport.class.getName());
    private static final boolean IS_FINE_LOGGABLE = LOGGER.isLoggable(Level.FINE);

    public static CopySupport getInstance() {
        return new CopySupport();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && CopySupport.isHandled(fileObject, fileObject2)) {
            if (IS_FINE_LOGGABLE) {
                String string = "processing fileFolderCreated event \"%s\" from project \"%s\"";
                LOGGER.fine(String.format(string, fileEvent.toString(), this.project.getName()));
            }
            this.prepareOperation(this.getOperationFactory().createCopyHandler(fileObject2));
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && CopySupport.isHandled(fileObject, fileObject2)) {
            if (IS_FINE_LOGGABLE) {
                String string = "processing fileDataCreated event \"%s\" from project \"%s\"";
                LOGGER.fine(String.format(string, fileEvent.toString(), this.project.getName()));
            }
            this.prepareOperation(this.getOperationFactory().createCopyHandler(fileObject2));
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && CopySupport.isHandled(fileObject, fileObject2)) {
            if (IS_FINE_LOGGABLE) {
                String string = "processing fileChanged event \"%s\" from project \"%s\"";
                LOGGER.fine(String.format(string, fileEvent.toString(), this.project.getName()));
            }
            this.prepareOperation(this.getOperationFactory().createCopyHandler(fileObject2));
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && CopySupport.isHandled(fileObject, fileObject2)) {
            if (IS_FINE_LOGGABLE) {
                String string = "processing fileDeleted event \"%s\" from project \"%s\"";
                LOGGER.fine(String.format(string, fileEvent.toString(), this.project.getName()));
            }
            this.prepareOperation(this.getOperationFactory().createDeleteHandler(fileObject2));
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        String string = fileRenameEvent.getName();
        String string2 = fileRenameEvent.getExt();
        if (string2 != null && string2.trim().length() > 0) {
            string = string + "." + string2;
        }
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        FileObject fileObject2 = fileRenameEvent.getFile();
        if (fileObject != null && CopySupport.isHandled(fileObject, fileObject2)) {
            if (IS_FINE_LOGGABLE) {
                String string3 = "processing fileRenamed event \"%s\" from project \"%s\"";
                LOGGER.fine(String.format(string3, fileRenameEvent.toString(), this.project.getName()));
            }
            this.prepareOperation(this.getOperationFactory().createRenameHandler(fileObject2, string));
        }
    }

    public void projectOpened(PhpProject phpProject) {
        this.isProjectOpened = true;
        if (this.project == null) {
            this.project = phpProject;
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(phpProject, this);
            this.operationFactory = new ProxyOperationFactory(phpProject);
        }
        this.operationFactory.init();
        this.init(true);
    }

    public void projectClosed(PhpProject phpProject) {
        this.isProjectOpened = false;
        this.unregisterFileChangeListener();
    }

    PhpProject getProject() {
        return this.project;
    }

    private static RequestProcessor.Task createProcessingTask() {
        return RP.create(new Runnable(){

            public void run() {
                Callable callable = (Callable)operationsQueue.poll();
                while (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    callable = (Callable)operationsQueue.poll();
                }
            }
        });
    }

    private synchronized FileOperationFactory getOperationFactory() {
        assert (this.operationFactory != null);
        return this.operationFactory;
    }

    private static boolean isHandled(FileObject fileObject, FileObject fileObject2) {
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject == fileObject2;
    }

    private void prepareOperation(Callable<Boolean> callable) {
        if (callable != null) {
            operationsQueue.offer(callable);
            processingTask.schedule(300);
        }
    }

    private void registerFileChangeListener(FileObject fileObject) {
        if (this.weakFileChangeListener == null) {
            try {
                this.fileSystem = fileObject.getFileSystem();
                this.weakFileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fileSystem);
                if (IS_FINE_LOGGABLE) {
                    String string = "+Copy support for project \"%s\" registers FS listener: \"%s\"";
                    LOGGER.fine(String.format(string, this.project.getName(), this.fileSystem.getDisplayName()));
                }
                this.fileSystem.addFileChangeListener(this.weakFileChangeListener);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
    }

    private synchronized void unregisterFileChangeListener() {
        if (this.weakFileChangeListener != null) {
            if (IS_FINE_LOGGABLE) {
                String string = "-Copy support for project \"%s\" unregisters FS listener: \"%s\"";
                LOGGER.fine(String.format(string, this.project.getName(), this.fileSystem.getDisplayName()));
            }
            this.fileSystem.removeFileChangeListener(this.weakFileChangeListener);
            this.fileSystem = null;
            this.weakFileChangeListener = null;
        }
    }

    synchronized void init(boolean bl) {
        String string;
        if (IS_FINE_LOGGABLE) {
            string = "Copy support for project \"%s\" INIT";
            LOGGER.fine(String.format(string, this.project.getName()));
        }
        this.unregisterFileChangeListener();
        string = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        if (string != null) {
            if (bl) {
                this.prepareOperation(this.getOperationFactory().createInitHandler((FileObject)string));
            }
            this.registerFileChangeListener((FileObject)string);
        }
    }

    public void waitFinished() {
        processingTask.schedule(0);
        processingTask.waitFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isProjectOpened) {
            this.operationFactory.invalidate();
            if (string.equals("copy.src.target") || string.equals("src.dir") || string.equals("copy.src.files")) {
                ProjectManager.mutex().readAccess(new Runnable(){

                    public void run() {
                        if (IS_FINE_LOGGABLE) {
                            String string = "Copy support for project \"%s\" propertyChange processing...";
                            LOGGER.fine(String.format(string, CopySupport.this.project.getName()));
                        }
                        CopySupport.this.init(true);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyOperationFactory
    extends FileOperationFactory {
        final FileOperationFactory localFactory;
        final FileOperationFactory remoteFactory;
        boolean localFactoryError;
        boolean remoteFactoryError;

        ProxyOperationFactory(PhpProject phpProject) {
            this.localFactory = new LocalOperationFactory(phpProject);
            this.remoteFactory = new RemoteOperationFactory(phpProject);
        }

        void init() {
            this.localFactoryError = false;
            this.remoteFactoryError = false;
        }

        @Override
        void invalidate() {
            this.localFactory.invalidate();
            this.remoteFactory.invalidate();
        }

        @Override
        Callable<Boolean> createCopyHandler(FileObject fileObject) {
            return this.createHandler(this.localFactory.createCopyHandler(fileObject), this.remoteFactory.createCopyHandler(fileObject));
        }

        @Override
        Callable<Boolean> createDeleteHandler(FileObject fileObject) {
            return this.createHandler(this.localFactory.createDeleteHandler(fileObject), this.remoteFactory.createDeleteHandler(fileObject));
        }

        @Override
        Callable<Boolean> createInitHandler(FileObject fileObject) {
            return this.createHandler(this.localFactory.createInitHandler(fileObject), this.remoteFactory.createInitHandler(fileObject));
        }

        @Override
        Callable<Boolean> createRenameHandler(FileObject fileObject, String string) {
            return this.createHandler(this.localFactory.createRenameHandler(fileObject, string), this.remoteFactory.createRenameHandler(fileObject, string));
        }

        private Callable<Boolean> createHandler(final Callable<Boolean> callable, final Callable<Boolean> callable2) {
            return callable != null || callable2 != null ? new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Boolean call() throws Exception {
                    boolean bl;
                    boolean bl2;
                    boolean bl22;
                    block14: {
                        Object object;
                        String string;
                        ProgressHandle progressHandle;
                        block13: {
                            bl22 = true;
                            bl2 = true;
                            if (!ProxyOperationFactory.this.localFactoryError && callable != null) {
                                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_LocalSynchronization"));
                                progressHandle.setInitialDelay(1000);
                                try {
                                    try {
                                        progressHandle.start();
                                        bl22 = (Boolean)callable.call();
                                    }
                                    catch (Exception exception) {
                                        LOGGER.log(Level.INFO, "Copy Support Fail: ", exception);
                                        string = NbBundle.getMessage(CopySupport.class, (String)"LBL_Copy_Support_Fail");
                                        object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, 0));
                                        if (!object.equals(0)) {
                                            ProxyOperationFactory.this.localFactoryError = true;
                                            LOGGER.log(Level.INFO, "Copy Support Disabled By User", exception);
                                        }
                                        Object var8_5 = null;
                                        progressHandle.finish();
                                        break block13;
                                    }
                                    Object var8_4 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var8_6 = null;
                                    progressHandle.finish();
                                    throw throwable;
                                }
                                progressHandle.finish();
                            }
                        }
                        if (!ProxyOperationFactory.this.remoteFactoryError && callable2 != null) {
                            progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_RemoteSynchronization"));
                            progressHandle.setInitialDelay(1000);
                            try {
                                try {
                                    progressHandle.start();
                                    bl2 = (Boolean)callable2.call();
                                }
                                catch (Exception exception) {
                                    LOGGER.log(Level.INFO, "Remote On Save Fail: ", exception);
                                    string = NbBundle.getMessage(CopySupport.class, (String)"LBL_Remote_On_Save_Fail");
                                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, 0));
                                    if (object.equals(0)) {
                                        ProxyOperationFactory.this.remoteFactoryError = true;
                                        LOGGER.log(Level.INFO, "Remote On Save  Disabled By User", exception);
                                    }
                                    Object var10_13 = null;
                                    progressHandle.finish();
                                    break block14;
                                }
                                Object var10_12 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_14 = null;
                                progressHandle.finish();
                                throw throwable;
                            }
                            progressHandle.finish();
                        }
                    }
                    if (bl2 && bl22) {
                        bl = true;
                        return bl;
                    }
                    bl = false;
                    return bl;
                }
            } : null;
        }
    }
}

