/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.FileOperationFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteOperationFactory
extends FileOperationFactory {
    private RemoteClient remoteClient;
    private final PhpProject project;

    RemoteOperationFactory(PhpProject phpProject) {
        this.project = phpProject;
    }

    private boolean isEnabled() {
        boolean bl = RemoteOperationFactory.isRemoteConfigSelected(this.project) ? RemoteOperationFactory.isUploadOnSave(this.project) : false;
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        return bl ? RemoteOperationFactory.isValidRemoteConfig(this.project) && fileObject != null : false;
    }

    @Override
    Callable<Boolean> createCopyHandler(final FileObject fileObject) {
        return this.isEnabled() ? new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                boolean bl;
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient(RemoteOperationFactory.this.project);
                Set<TransferFile> set = Collections.emptySet();
                FileObject fileObject3 = ProjectPropertiesSupport.getSourcesDirectory(RemoteOperationFactory.this.project);
                FileObject fileObject2 = remoteClient != null ? fileObject3 : null;
                boolean bl2 = bl = fileObject2 != null ? FileOperationFactory.isSourceFileValid(fileObject2, fileObject) : false;
                if (bl) {
                    set = remoteClient.prepareUpload(fileObject2, fileObject);
                }
                if (remoteClient != null) {
                    block5: {
                        Boolean bl3;
                        try {
                            if (set.size() <= 0) break block5;
                            TransferInfo transferInfo = remoteClient.upload(fileObject2, set);
                            bl3 = transferInfo.hasAnyTransfered();
                            Object var9_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            remoteClient.disconnect();
                            throw throwable;
                        }
                        remoteClient.disconnect();
                        return bl3;
                    }
                    Object var9_9 = null;
                    remoteClient.disconnect();
                    {
                    }
                }
                return false;
            }
        } : null;
    }

    @Override
    Callable<Boolean> createDeleteHandler(final FileObject fileObject) {
        return this.isEnabled() ? new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                boolean bl;
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient(RemoteOperationFactory.this.project);
                Set<TransferFile> set = Collections.emptySet();
                FileObject fileObject3 = ProjectPropertiesSupport.getSourcesDirectory(RemoteOperationFactory.this.project);
                FileObject fileObject2 = remoteClient != null ? fileObject3 : null;
                boolean bl2 = bl = fileObject2 != null ? FileOperationFactory.isSourceFileValid(fileObject2, fileObject) : false;
                if (bl) {
                    set = remoteClient.prepareDelete(fileObject2, fileObject);
                }
                if (remoteClient != null) {
                    block5: {
                        Boolean bl3;
                        try {
                            if (set.size() <= 0) break block5;
                            TransferInfo transferInfo = remoteClient.delete(set);
                            bl3 = !transferInfo.hasAnyFailed();
                            Object var9_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            remoteClient.disconnect();
                            throw throwable;
                        }
                        remoteClient.disconnect();
                        return bl3;
                    }
                    Object var9_9 = null;
                    remoteClient.disconnect();
                    {
                    }
                }
                return false;
            }
        } : null;
    }

    @Override
    Callable<Boolean> createInitHandler(FileObject fileObject) {
        return null;
    }

    @Override
    Callable<Boolean> createRenameHandler(final FileObject fileObject, final String string) {
        return this.isEnabled() ? new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Object object;
                boolean bl;
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient(RemoteOperationFactory.this.project);
                TransferFile transferFile = null;
                TransferFile transferFile2 = null;
                FileObject fileObject3 = ProjectPropertiesSupport.getSourcesDirectory(RemoteOperationFactory.this.project);
                FileObject fileObject2 = remoteClient != null ? fileObject3 : null;
                boolean bl2 = bl = fileObject2 != null ? FileOperationFactory.isSourceFileValid(fileObject2, fileObject) : false;
                if (bl) {
                    object = FileUtil.toFile((FileObject)fileObject3).getAbsolutePath();
                    File file = FileUtil.toFile((FileObject)fileObject);
                    transferFile2 = TransferFile.fromFileObject(fileObject, (String)object);
                    transferFile = TransferFile.fromFile(new File(file.getParentFile(), string), (String)object);
                }
                if (remoteClient != null) {
                    block5: {
                        try {
                            if (transferFile == null || transferFile2 == null) break block5;
                            object = remoteClient.rename(transferFile, transferFile2);
                            Object var10_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            remoteClient.disconnect();
                            throw throwable;
                        }
                        remoteClient.disconnect();
                        return object;
                    }
                    Object var10_10 = null;
                    remoteClient.disconnect();
                    {
                    }
                }
                return false;
            }
        } : null;
    }

    protected static boolean isValidRemoteConfig(PhpProject phpProject) {
        return RemoteOperationFactory.getRemoteConfiguration(phpProject) != null;
    }

    protected static boolean isUploadOnSave(PhpProject phpProject) {
        PhpProjectProperties.UploadFiles uploadFiles = ProjectPropertiesSupport.getRemoteUpload(phpProject);
        return uploadFiles != null ? PhpProjectProperties.UploadFiles.ON_SAVE.equals((Object)uploadFiles) : false;
    }

    protected static boolean isRemoteConfigSelected(PhpProject phpProject) {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(phpProject);
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAsType);
    }

    protected synchronized RemoteClient getRemoteClient(PhpProject phpProject) {
        if (this.remoteClient == null) {
            this.remoteClient = new RemoteClient(RemoteOperationFactory.getRemoteConfiguration(phpProject), RemoteClient.AdvancedProperties.create(null, RemoteOperationFactory.getRemoteDirectory(phpProject), ProjectPropertiesSupport.areRemotePermissionsPreserved(phpProject), ProjectPropertiesSupport.isRemoteUploadDirectly(phpProject)));
        }
        return this.remoteClient;
    }

    @Override
    synchronized void invalidate() {
        this.remoteClient = null;
    }

    protected static RemoteConfiguration getRemoteConfiguration(PhpProject phpProject) {
        String string = RemoteOperationFactory.getRemoteConfigurationName(phpProject);
        assert (string != null && string.length() > 0) : "Remote configuration name must be selected";
        return RemoteConnections.get().remoteConfigurationForName(string);
    }

    protected static String getRemoteConfigurationName(PhpProject phpProject) {
        return ProjectPropertiesSupport.getRemoteConnection(phpProject);
    }

    protected static String getRemoteDirectory(PhpProject phpProject) {
        return ProjectPropertiesSupport.getRemoteDirectory(phpProject);
    }
}

