/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.RowData;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.newtable.TableSectionBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;

public class TableRowBox
extends BlockBox {
    private int _baseline;
    private boolean _haveBaseline = false;

    public boolean isAutoHeight() {
        return this.getStyle().isAutoHeight() || !this.getStyle().hasAbsoluteUnit(CSSName.HEIGHT);
    }

    private TableBox getTable() {
        return (TableBox)this.getParent().getParent();
    }

    private TableSectionBox getSection() {
        return (TableSectionBox)this.getParent();
    }

    protected void layoutChildren(LayoutContext c, int contentStart) {
        this.setState(2);
        this.ensureChildren(c);
        TableSectionBox section = this.getSection();
        if (section.isNeedCellWidthCalc()) {
            section.setCellWidths(c);
            section.setNeedCellWidthCalc(false);
        }
        if (this.getChildrenContentType() != 4) {
            int cCol = 0;
            Iterator i = this.getChildIterator();
            while (i.hasNext()) {
                TableCellBox cell = (TableCellBox)i.next();
                this.layoutCell(c, cell, 0);
                ++cCol;
            }
        }
        this.setState(3);
    }

    private void alignBaselineAlignedCells(LayoutContext c) {
        TableCellBox cell;
        int i;
        int[] baselines = new int[this.getChildCount()];
        int lowest = Integer.MIN_VALUE;
        boolean found = false;
        for (i = 0; i < this.getChildCount(); ++i) {
            int baseline;
            cell = (TableCellBox)this.getChild(i);
            if (cell.getVerticalAlign() != IdentValue.BASELINE) continue;
            baselines[i] = baseline = cell.calcBaseline(c);
            if (baseline > lowest) {
                lowest = baseline;
            }
            found = true;
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            int deltaY;
            cell = (TableCellBox)this.getChild(i);
            if (cell.getVerticalAlign() != IdentValue.BASELINE || (deltaY = lowest - baselines[i]) == 0) continue;
            if (c.isPrint() && cell.isPageBreaksChange(c, deltaY)) {
                this.relayoutCell(c, cell, deltaY);
                continue;
            }
            cell.moveContent(c, deltaY);
            cell.setHeight(cell.getHeight() + deltaY);
        }
        if (found) {
            this.setBaseline(lowest - this.getAbsY());
            this.setHaveBaseline(true);
        }
    }

    private boolean alignMiddleAndBottomAlignedCells(LayoutContext c) {
        boolean needRowHeightRecalc = false;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List row = ((RowData)this.getSection().getGrid().get(cRow)).getRow();
        for (int cCol = 0; cCol < row.size(); ++cCol) {
            int deltaY;
            IdentValue val;
            TableCellBox cell = (TableCellBox)row.get(cCol);
            if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell || (val = cell.getVerticalAlign()) != IdentValue.MIDDLE && val != IdentValue.BOTTOM || (deltaY = this.calcMiddleBottomDeltaY(cell, val)) <= 0) continue;
            if (c.isPrint() && cell.isPageBreaksChange(c, deltaY)) {
                int oldCellHeight = cell.getHeight();
                this.relayoutCell(c, cell, deltaY);
                if (oldCellHeight + deltaY == cell.getHeight()) continue;
                needRowHeightRecalc = true;
                continue;
            }
            cell.moveContent(c, deltaY);
            cell.setHeight(cell.getHeight() + deltaY);
        }
        return needRowHeightRecalc;
    }

    private int calcMiddleBottomDeltaY(TableCellBox cell, IdentValue verticalAlign) {
        int result = cell.getStyle().getRowSpan() == 1 ? this.getHeight() - cell.getChildrenHeight() : this.getAbsY() + this.getHeight() - (cell.getAbsY() + cell.getChildrenHeight());
        if (verticalAlign == IdentValue.MIDDLE) {
            return result / 2;
        }
        return result;
    }

    protected void calcLayoutHeight(LayoutContext c, BorderPropertySet border, RectPropertySet margin, RectPropertySet padding) {
        this.alignBaselineAlignedCells(c);
        this.calcRowHeight();
        boolean recalcRowHeight = this.alignMiddleAndBottomAlignedCells(c);
        if (recalcRowHeight) {
            this.calcRowHeight();
        }
        if (!this.isHaveBaseline()) {
            this.calcDefaultBaseline(c);
        }
        this.setCellHeights(c);
    }

    private void calcRowHeight() {
        int y1 = this.getAbsY();
        int y2 = this.getHeight() != 0 ? y1 + this.getHeight() : y1;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List row = ((RowData)this.getSection().getGrid().get(cRow)).getRow();
        for (int cCol = 0; cCol < row.size(); ++cCol) {
            int bottomCellEdge;
            TableCellBox cell = (TableCellBox)row.get(cCol);
            if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell || (bottomCellEdge = cell.getAbsY() + cell.getHeight()) <= y2) continue;
            y2 = bottomCellEdge;
        }
        this.setHeight(y2 - y1);
    }

    private void calcDefaultBaseline(LayoutContext c) {
        int lowestCellEdge = 0;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List row = ((RowData)this.getSection().getGrid().get(cRow)).getRow();
        for (int cCol = 0; cCol < row.size(); ++cCol) {
            TableCellBox cell = (TableCellBox)row.get(cCol);
            if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell) continue;
            Rectangle contentArea = cell.getContentAreaEdge(cell.getAbsX(), cell.getAbsY(), c);
            int bottomCellEdge = contentArea.y + contentArea.height;
            if (bottomCellEdge <= lowestCellEdge) continue;
            lowestCellEdge = bottomCellEdge;
        }
        if (lowestCellEdge > 0) {
            this.setBaseline(lowestCellEdge - this.getAbsY());
        }
        this.setHaveBaseline(true);
    }

    private void setCellHeights(LayoutContext c) {
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List row = ((RowData)this.getSection().getGrid().get(cRow)).getRow();
        for (int cCol = 0; cCol < row.size(); ++cCol) {
            TableCellBox cell = (TableCellBox)row.get(cCol);
            if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell) continue;
            if (cell.getStyle().getRowSpan() == 1) {
                cell.setHeight(this.getHeight());
                continue;
            }
            cell.setHeight(this.getAbsY() + this.getHeight() - cell.getAbsY());
        }
    }

    private void relayoutCell(LayoutContext c, TableCellBox cell, int contentStart) {
        int width = cell.getWidth();
        cell.reset(c);
        cell.setLayoutWidth(c, width);
        this.layoutCell(c, cell, contentStart);
    }

    private void layoutCell(LayoutContext c, TableCellBox cell, int contentStart) {
        cell.initContainingLayer(c);
        cell.calcCanvasLocation();
        cell.layout(c, contentStart);
    }

    public void initStaticPos(LayoutContext c, BlockBox parent, int childOffset) {
        this.setX(0);
        TableBox table = this.getTable();
        this.setY(parent.getHeight() + table.getStyle().getBorderVSpacing(c));
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    protected boolean isSkipWhenCollapsingMargins() {
        return true;
    }

    public void paintBorder(RenderingContext c) {
    }

    public void paintBackground(RenderingContext c) {
    }

    public void reset(LayoutContext c) {
        super.reset(c);
        this.setHaveBaseline(false);
        this.getSection().setNeedCellWidthCalc(true);
    }

    public boolean isHaveBaseline() {
        return this._haveBaseline;
    }

    public void setHaveBaseline(boolean haveBaseline) {
        this._haveBaseline = haveBaseline;
    }

    protected String getExtraBoxDescription() {
        if (this.isHaveBaseline()) {
            return "(baseline=" + this.getBaseline() + ") ";
        }
        return "";
    }
}

