/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import org.xhtmlrenderer.layout.FunctionData;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.Uu;

public class InlineText {
    private InlineLayoutBox _parent;
    private int _x;
    private String _masterText;
    private int _start;
    private int _end;
    private int _width;
    private FunctionData _functionData;
    private boolean _containedLF = false;

    public void trimTrailingSpace(LayoutContext c) {
        if (!this.isEmpty() && this._masterText.charAt(this._end - 1) == ' ') {
            --this._end;
            this.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), this.getParent().getStyle().getFSFont(c), this.getSubstring()));
        }
    }

    public boolean isEmpty() {
        return this._start == this._end && !this._containedLF;
    }

    public String getSubstring() {
        if (this.getMasterText() != null) {
            if (this._start == -1 || this._end == -1) {
                throw new RuntimeException("negative index in InlineBox");
            }
            if (this._end < this._start) {
                throw new RuntimeException("end is less than setStartStyle");
            }
            return this.getMasterText().substring(this._start, this._end);
        }
        throw new RuntimeException("No master text set!");
    }

    public void setSubstring(int start, int end) {
        if (end < start) {
            Uu.p("setting substring to: " + start + " " + end);
            throw new RuntimeException("set substring length too long: " + this);
        }
        if (end < 0 || start < 0) {
            throw new RuntimeException("Trying to set negative index to inline box");
        }
        this._start = start;
        this._end = end;
        if (this._end > 0 && this._masterText.charAt(this._end - 1) == '\n') {
            this._containedLF = true;
            --this._end;
        }
    }

    public String getMasterText() {
        return this._masterText;
    }

    public void setMasterText(String masterText) {
        this._masterText = masterText;
    }

    public int getX() {
        return this._x;
    }

    public void setX(int x) {
        this._x = x;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void paint(RenderingContext c) {
        c.getOutputDevice().drawText(c, this);
    }

    public InlineLayoutBox getParent() {
        return this._parent;
    }

    public void setParent(InlineLayoutBox parent) {
        this._parent = parent;
    }

    public boolean isDynamicFunction() {
        return this._functionData != null;
    }

    public FunctionData getFunctionData() {
        return this._functionData;
    }

    public void setFunctionData(FunctionData functionData) {
        this._functionData = functionData;
    }

    public void updateDynamicValue(RenderingContext c) {
        String value = this._functionData.getContentFunction().calculate(c, this._functionData.getFunction(), this);
        this._start = 0;
        this._end = value.length();
        this._masterText = value;
        this._width = c.getTextRenderer().getWidth(c.getFontContext(), this.getParent().getStyle().getFSFont(c), value);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("InlineText: ");
        if (this._containedLF || this.isDynamicFunction()) {
            result.append("(");
            if (this._containedLF) {
                result.append('L');
            }
            if (this.isDynamicFunction()) {
                result.append('F');
            }
            result.append(") ");
        }
        result.append('(');
        result.append(this.getSubstring());
        result.append(')');
        return result.toString();
    }
}

