/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcesCurrentModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = Collections.emptyList();
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private String projectRoot;
    private PropertyChangeListener mainProjectListener;
    private DebuggerManagerListener debuggerListener;
    private SourcePathProviderImpl currentSourcePathProvider;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SourcesCurrentModel.this.newSourceFileChooser == null) {
                SourcesCurrentModel.this.newSourceFileChooser = new JFileChooser();
                SourcesCurrentModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesCurrentModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            return false;
                        }
                    }
                });
            }
            if ((n = SourcesCurrentModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file = SourcesCurrentModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!file.isDirectory() && !FileUtil.isArchiveFile((URL)file.toURI().toURL())) {
                        return;
                    }
                    String string = file.getCanonicalPath();
                    SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
                    synchronized (sourcesCurrentModel) {
                        SourcesCurrentModel.this.additionalSourceRoots.add(string);
                    }
                    SourcesCurrentModel.this.saveAdditionalSourceRoots();
                    SourcesCurrentModel.this.fireTreeChanged();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                for (int i = 0; i < n; ++i) {
                    String string = (String)objectArray[i];
                    SourcesCurrentModel.this.additionalSourceRoots.remove(string);
                    SourcesCurrentModel.this.disabledSourceRoots.remove(string);
                }
                SourcesCurrentModel.this.saveAdditionalSourceRoots();
                SourcesCurrentModel.this.saveDisabledSourceRoots();
            }
            SourcesCurrentModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesCurrentModel() {
        this.bindWithSourcePathProvider();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
    }

    private void bindWithSourcePathProvider() {
        this.debuggerListener = new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("currentSession".equals(string)) {
                    Object object;
                    Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                    SourcePathProviderImpl sourcePathProviderImpl = null;
                    if (session != null) {
                        object = session.lookup(null, SourcePathProvider.class);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            SourcePathProvider sourcePathProvider = (SourcePathProvider)iterator.next();
                            if (!(sourcePathProvider instanceof SourcePathProviderImpl)) continue;
                            sourcePathProviderImpl = (SourcePathProviderImpl)sourcePathProvider;
                            SourcesCurrentModel.this.setSources(sourcePathProviderImpl);
                            break;
                        }
                    }
                    object = this;
                    synchronized (object) {
                        SourcesCurrentModel.this.currentSourcePathProvider = sourcePathProviderImpl;
                    }
                    SourcesCurrentModel.this.fireTreeChanged();
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.debuggerListener, (Object)DebuggerManager.getDebuggerManager()));
    }

    private synchronized void setSources(SourcePathProviderImpl sourcePathProviderImpl) {
        this.currentSourcePathProvider = sourcePathProviderImpl;
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Object[] objectArray = this;
            synchronized (this) {
                String[] stringArray;
                List<Object> list;
                if (this.currentSourcePathProvider != null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.currentSourcePathProvider.getSourceRoots();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (this.mainProjectListener == null) {
                    this.mainProjectListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            SourcesCurrentModel.this.fireTreeChanged();
                        }
                    };
                    MainProjectManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.mainProjectListener, (Object)MainProjectManager.getDefault()));
                }
                objectArray = MainProjectManager.getDefault().getMainProject();
                String string = null;
                if (objectArray != null) {
                    list = SourcesCurrentModel.getProjectSources((Project)objectArray);
                    stringArray = new String[list.size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = SourcePathProviderImpl.getRoot(list.get(i));
                    }
                    try {
                        string = objectArray.getProjectDirectory().getURL().toExternalForm();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                } else {
                    stringArray = new String[]{};
                }
                list = null;
                Object[] objectArray2 = this;
                synchronized (this) {
                    if (string != null) {
                        list = this.loadAdditionalSourceRoots(string);
                    }
                    list = list == null ? new ArrayList<FileObject>() : new ArrayList<FileObject>(list);
                    this.additionalSourceRoots = list;
                    this.disabledSourceRoots = this.loadDisabledSourceRoots(string);
                    this.disabledSourceRoots = this.disabledSourceRoots == null ? new HashSet<String>() : new HashSet<String>(this.disabledSourceRoots);
                    this.projectRoot = string;
                    // ** MonitorExit[var8_11] (shouldn't be in output)
                    objectArray2 = new Object[stringArray.length + list.size()];
                    System.arraycopy(stringArray, 0, objectArray2, 0, stringArray.length);
                    System.arraycopy(list.toArray(), 0, objectArray2, stringArray.length, list.size());
                    n2 = Math.min(objectArray2.length, n2);
                    n = Math.min(objectArray2.length, n);
                    Object[] objectArray3 = new Object[n2 - n];
                    System.arraycopy(objectArray2, n, objectArray3, 0, n2 - n);
                    return objectArray3;
                }
            }
        }
        throw new UnknownTypeException(object);
    }

    private List<String> loadAdditionalSourceRoots(String string) {
        if (string == null) {
            return null;
        }
        return (List)this.sourcesProperties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(string);
    }

    private Set<String> loadDisabledSourceRoots(String string) {
        if (string == null) {
            return null;
        }
        return (Set)this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(string);
    }

    private static List<FileObject> getProjectSources(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/source");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet2);
        }
        for (SourceGroup sourceGroup : sourceGroupArray) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/execute");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet, hashSet2);
        }
        for (SourceGroup sourceGroup : sourceGroupArray) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/boot");
            if (classPath == null) continue;
            SourcesCurrentModel.addSourceRoots(classPath, arrayList, hashSet, hashSet2);
        }
        return arrayList;
    }

    private static void addSourceRoots(ClassPath classPath, List<FileObject> list, Set<FileObject> set, Set<FileObject> set2) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = classPath.getRoots()) {
            if (set.contains(fileObject)) continue;
            set.add(fileObject);
            try {
                FileObject[] fileObjectArray2;
                for (FileObject fileObject2 : fileObjectArray2 = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots()) {
                    if (set2.contains(fileObject2)) continue;
                    list.add(fileObject2);
                    set2.add(fileObject2);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
    }

    private static void addSourceRoots(ClassPath classPath, List<FileObject> list, Set<FileObject> set) {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = classPath.getRoots()) {
            if (set.contains(fileObject) || fileObject.isVirtual()) continue;
            list.add(fileObject);
            set.add(fileObject);
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (this.additionalSourceRoots.contains(object)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            return !this.disabledSourceRoots.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            if (bl) {
                this.disabledSourceRoots.remove(string);
            } else {
                this.disabledSourceRoots.add(string);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private synchronized void saveDisabledSourceRoots() {
        Map map = this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", new HashMap());
        map.put(this.projectRoot, this.disabledSourceRoots);
        this.sourcesProperties.getProperties("source_roots").setMap("project_disabled", map);
    }

    private synchronized void saveAdditionalSourceRoots() {
        Map map = this.sourcesProperties.getProperties("additional_source_roots").getMap("project", new HashMap());
        map.put(this.projectRoot, this.additionalSourceRoots);
        this.sourcesProperties.getProperties("additional_source_roots").setMap("project", map);
    }

    public boolean isCheckable(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(NodeModel nodeModel, Object object, Boolean bl) throws UnknownTypeException {
        if (object instanceof String) {
            this.setEnabled((String)object, bl);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getDisplayName(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }
}

