/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditJarPanel
extends JPanel {
    private EditJarSupport.Item item;
    private AntProjectHelper helper;
    private JButton btnJavadoc;
    private JButton btnSource;
    private JLabel lblJar;
    private JLabel lblJavadoc;
    private JLabel lblSource;
    private JTextField txtJar;
    private JTextField txtJavadoc;
    private JTextField txtSource;

    private EditJarPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_EditJarPanel"));
    }

    EditJarPanel(EditJarSupport.Item item, AntProjectHelper antProjectHelper) {
        this();
        this.item = item;
        this.helper = antProjectHelper;
        this.txtJar.setText(EditJarPanel.stripOffVariableMarkup(item.getJarFile()));
        if (item.getSourceFile() != null) {
            this.txtSource.setText(EditJarPanel.stripOffJARContent(EditJarPanel.stripOffVariableMarkup(item.getSourceFile())));
        }
        if (item.getJavadocFile() != null) {
            this.txtJavadoc.setText(EditJarPanel.stripOffJARContent(EditJarPanel.stripOffVariableMarkup(item.getJavadocFile())));
        }
    }

    private static String stripOffVariableMarkup(String string) {
        if (!string.startsWith("${var.")) {
            return string;
        }
        int n = string.replace('\\', '/').indexOf(47);
        if (n == -1) {
            n = string.length();
        }
        return string.substring(6, n - 1) + string.substring(n);
    }

    private static String stripOffJARContent(String string) {
        int n = string.indexOf("!/");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static Set<String> getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : PropertyUtils.getGlobalProperties().keySet()) {
            if (!string.startsWith("var.")) continue;
            hashSet.add(string.substring(4));
        }
        return hashSet;
    }

    private static String addVariableMarkup(String string) {
        int n = string.replace('\\', '/').indexOf(47);
        if (n == -1) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        if (!EditJarPanel.getVariableNames().contains(string2)) {
            return string;
        }
        return "${var." + string2 + "}" + string.substring(n);
    }

    private static String convertPath(AntProjectHelper antProjectHelper, String string, boolean bl) {
        FileObject fileObject;
        String string2 = EditJarPanel.addVariableMarkup(string);
        String string3 = antProjectHelper.getStandardPropertyEvaluator().evaluate(string2);
        if (string3 == null) {
            return string2;
        }
        FileObject fileObject2 = antProjectHelper.resolveFileObject(string3);
        if (fileObject2 == null) {
            return string2;
        }
        boolean bl2 = false;
        if (FileUtil.isArchiveFile((FileObject)fileObject2)) {
            fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject2);
            bl2 = true;
        }
        if ((fileObject = bl ? JavadocAndSourceRootDetection.findJavadocRoot(fileObject2) : JavadocAndSourceRootDetection.findSourceRoot(fileObject2)) != null && !fileObject2.equals(fileObject)) {
            if (bl2) {
                string2 = string2 + "!/";
            }
            string2 = string2 + (string2.replace('\\', '/').endsWith("/") ? "" : File.separator);
            String string4 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            assert (string4 != null) : "fo=" + fileObject2 + " root=" + fileObject;
            if (string4.length() > 0) {
                string4 = string4 + "/";
                if (!bl2) {
                    string4 = string4.replace('/', File.separatorChar);
                }
                string2 = string2 + string4;
            }
        }
        return string2;
    }

    EditJarSupport.Item assignValues() {
        if (this.txtSource.getText() != null && this.txtSource.getText().trim().length() > 0) {
            this.item.setSourceFile(EditJarPanel.convertPath(this.helper, this.txtSource.getText().trim(), false));
        } else {
            this.item.setSourceFile(null);
        }
        if (this.txtJavadoc.getText() != null && this.txtJavadoc.getText().trim().length() > 0) {
            this.item.setJavadocFile(EditJarPanel.convertPath(this.helper, this.txtJavadoc.getText().trim(), true));
        } else {
            this.item.setJavadocFile(null);
        }
        return this.item;
    }

    private void initComponents() {
        this.lblJar = new JLabel();
        this.txtJar = new JTextField();
        this.lblJavadoc = new JLabel();
        this.txtJavadoc = new JTextField();
        this.btnJavadoc = new JButton();
        this.lblSource = new JLabel();
        this.txtSource = new JTextField();
        this.btnSource = new JButton();
        this.lblJar.setLabelFor(this.txtJar);
        Mnemonics.setLocalizedText((JLabel)this.lblJar, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJar.text"));
        this.txtJar.setEditable(false);
        this.lblJavadoc.setLabelFor(this.txtJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJavadoc.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnJavadoc.text"));
        this.btnJavadoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJarPanel.this.btnJavadocActionPerformed(actionEvent);
            }
        });
        this.lblSource.setLabelFor(this.txtSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblSource.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnSource.text"));
        this.btnSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJarPanel.this.btnSourceActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblJar).add((Component)this.lblJavadoc).add((Component)this.lblSource)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtSource, -1, 330, Short.MAX_VALUE).add((Component)this.txtJavadoc, -1, 330, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnSource).add((Component)this.btnJavadoc))).add((Component)this.txtJar, -1, 435, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJar).add((Component)this.txtJar, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJavadoc).add((Component)this.btnJavadoc).add((Component)this.txtJavadoc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSource).add((Component)this.btnSource).add((Component)this.txtSource, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.txtJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.lblJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.txtJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.btnJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnJavadoc"));
        this.lblSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.txtSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.btnSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnSource"));
    }

    private void btnJavadocActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
        fileChooser.enableVariableBasedSelection(true);
        fileChooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(NbBundle.getMessage(EditJarPanel.class, (String)"LBL_Edit_Jar_Panel_browse"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("Javadoc Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File file = this.helper.resolveFile(this.helper.getStandardPropertyEvaluator().evaluate(this.item.getJarFile()));
        fileChooser.setCurrentDirectory(file);
        int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            this.txtJavadoc.setText(fileChooser.getSelectedPathVariables() != null ? EditJarPanel.stripOffVariableMarkup(fileChooser.getSelectedPathVariables()[0]) : stringArray[0]);
        }
    }

    private void btnSourceActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
        fileChooser.enableVariableBasedSelection(true);
        fileChooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(NbBundle.getMessage(EditJarPanel.class, (String)"LBL_Edit_Jar_Panel_browse"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("Source Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File file = this.helper.resolveFile(this.helper.getStandardPropertyEvaluator().evaluate(this.item.getJarFile()));
        fileChooser.setCurrentDirectory(file);
        int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            this.txtSource.setText(fileChooser.getSelectedPathVariables() != null ? EditJarPanel.stripOffVariableMarkup(fileChooser.getSelectedPathVariables()[0]) : stringArray[0]);
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

