/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.codegen;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.codegen.GenerateCodePanel;
import org.netbeans.modules.editor.codegen.PopupUtil;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.editor.codegen.CodeGeneratorContextProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class NbGenerateCodeAction
extends BaseAction {
    public static final String generateCode = "generate-code";

    public NbGenerateCodeAction() {
        this.putValue("trimmed-text", NbBundle.getBundle(NbGenerateCodeAction.class).getString("generate-code-trimmed"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        Task task = new Task(NbGenerateCodeAction.getFullMimePath(jTextComponent.getDocument(), jTextComponent.getCaretPosition()));
        task.run(Lookups.singleton((Object)jTextComponent));
        if (task.codeGenerators.size() > 0) {
            int n = -1;
            Point point = null;
            try {
                Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                n = rectangle.height;
                point = new Point(rectangle.x, rectangle.y + rectangle.height);
                SwingUtilities.convertPointToScreen(point, jTextComponent);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (point == null) {
                point = new Point(-1, -1);
            }
            PopupUtil.showPopup(new GenerateCodePanel(jTextComponent, task.codeGenerators), null, point.x, point.y, true, n);
        } else {
            jTextComponent.getToolkit().beep();
        }
    }

    static String[] test(Document document, int n) {
        Task task = new Task(NbGenerateCodeAction.getFullMimePath(document, n));
        task.run(Lookups.fixed((Object[])new Object[0]));
        String[] stringArray = new String[task.codeGenerators.size()];
        int n2 = 0;
        for (CodeGenerator codeGenerator : task.codeGenerators) {
            stringArray[n2++] = codeGenerator.getDisplayName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MimePath getFullMimePath(Document document, int n) {
        String string = null;
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.readLock();
            try {
                List list = TokenHierarchy.get((Document)document).embeddedTokenSequences(n, true);
                if (list.size() > 1) {
                    string = ((TokenSequence)list.get(list.size() - 1)).languagePath().mimePath();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
        if (string == null) {
            string = NbEditorUtilities.getMimeType(document);
        }
        if (string != null) {
            return MimePath.parse((String)string);
        }
        return null;
    }

    public static final class GlobalAction
    extends MainMenuAction {
        public GlobalAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(GlobalAction.class).getString("generate-code-main-menu-source-item");
        }

        protected String getActionName() {
            return NbGenerateCodeAction.generateCode;
        }
    }

    private static class Task
    implements CodeGeneratorContextProvider.Task {
        private MimePath mimePath;
        private Iterator<? extends CodeGeneratorContextProvider> contextProviders;
        private List<CodeGenerator> codeGenerators = new ArrayList<CodeGenerator>();

        private Task(MimePath mimePath) {
            this.mimePath = mimePath;
            this.contextProviders = MimeLookup.getLookup((MimePath)mimePath).lookupAll(CodeGeneratorContextProvider.class).iterator();
        }

        public void run(Lookup lookup) {
            if (this.contextProviders.hasNext()) {
                this.contextProviders.next().runTaskWithinContext(lookup, (CodeGeneratorContextProvider.Task)this);
            } else {
                for (CodeGenerator.Factory factory : MimeLookup.getLookup((MimePath)this.mimePath).lookupAll(CodeGenerator.Factory.class)) {
                    this.codeGenerators.addAll(factory.create(lookup));
                }
            }
        }
    }
}

