/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.netbeans.editor.BaseKit;
import org.openide.util.NbBundle;

public final class StatusLineComponent
extends JLabel {
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final String MAX_LINE_COLUMN_STRING = "99999:999";
    private static final String INSERT_LOCALE = "status-bar-insert";
    private static final String OVERWRITE_LOCALE = "status-bar-overwrite";
    private static final Logger LOG = Logger.getLogger(StatusLineComponent.class.getName());
    private Dimension minDimension;

    StatusLineComponent(Type type) {
        switch (type) {
            case LINE_COLUMN: {
                this.initMinDimension(MAX_LINE_COLUMN_STRING);
                break;
            }
            case TYPING_MODE: {
                ResourceBundle resourceBundle = NbBundle.getBundle(BaseKit.class);
                String string = resourceBundle.getString(INSERT_LOCALE);
                String string2 = resourceBundle.getString(OVERWRITE_LOCALE);
                this.initMinDimension(string, string2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setHorizontalAlignment(0);
    }

    public Dimension getPreferredSize() {
        return this.minDimension;
    }

    private void initMinDimension(String ... stringArray) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        for (String string : stringArray) {
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : NULL_INSETS;
        int n2 = fontMetrics.getHeight() + insets.top + insets.bottom;
        this.minDimension = new Dimension(n += insets.left + insets.right, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        LINE_COLUMN,
        TYPING_MODE;

    }
}

