/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageEntry;
import org.openide.util.NbBundle;

public class MessageSecurityEntryPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private final ResourceBundle webserviceBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
    private final ResourceBundle commonBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private final TextMapping[] sourceTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("sender", this.webserviceBundle.getString("AUTH_SOURCE_SENDER")), new TextMapping("content", this.webserviceBundle.getString("AUTH_SOURCE_CONTENT"))};
    private final TextMapping[] recipientTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("before-content", this.webserviceBundle.getString("AUTH_RECIPIENT_BEFORE_CONTENT")), new TextMapping("after-content", this.webserviceBundle.getString("AUTH_RECIPIENT_AFTER_CONTENT"))};
    private static final int METHOD_FIELD = 0;
    private static final int REQ_SOURCE_FIELD = 1;
    private static final int REQ_RECIPIENT_FIELD = 2;
    private static final int RESP_SOURCE_FIELD = 3;
    private static final int RESP_RECIPIENT_FIELD = 4;
    private static final int NUM_FIELDS = 5;
    private DefaultComboBoxModel authReqSourceModel;
    private DefaultComboBoxModel authReqRecipientModel;
    private DefaultComboBoxModel authRespSourceModel;
    private DefaultComboBoxModel authRespRecipientModel;
    private boolean methodAsOperation;
    private String methodName;
    private String reqSource;
    private String reqRecipient;
    private String respSource;
    private String respRecipient;
    private boolean initializingFields;
    private JComboBox jCbxReqAuthRecip;
    private JComboBox jCbxReqAuthSource;
    private JComboBox jCbxRespAuthRecip;
    private JComboBox jCbxRespAuthSource;
    private JLabel jLblMethodName;
    private JLabel jLblMethodNameReqFlag;
    private JLabel jLblReqAuthRecip;
    private JLabel jLblReqAuthSource;
    private JLabel jLblRespAuthRecip;
    private JLabel jLblRespAuthSource;
    private JTextField jTxtMethodName;

    public MessageSecurityEntryPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblMethodNameReqFlag = new JLabel();
        this.jLblMethodName = new JLabel();
        this.jTxtMethodName = new JTextField();
        this.jLblReqAuthSource = new JLabel();
        this.jCbxReqAuthSource = new JComboBox();
        this.jLblReqAuthRecip = new JLabel();
        this.jCbxReqAuthRecip = new JComboBox();
        this.jLblRespAuthSource = new JLabel();
        this.jCbxRespAuthSource = new JComboBox();
        this.jLblRespAuthRecip = new JLabel();
        this.jCbxRespAuthRecip = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLblMethodNameReqFlag.setText(this.commonBundle.getString("LBL_RequiredMark"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblMethodNameReqFlag, gridBagConstraints);
        this.jLblMethodNameReqFlag.getAccessibleContext().setAccessibleName(this.commonBundle.getString("ACSN_RequiredMark"));
        this.jLblMethodNameReqFlag.getAccessibleContext().setAccessibleDescription(this.commonBundle.getString("ACSD_RequiredMark"));
        this.jLblMethodName.setDisplayedMnemonic(this.webserviceBundle.getString("MNE_MethodName").charAt(0));
        this.jLblMethodName.setText(this.webserviceBundle.getString("LBL_MethodName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblMethodName, gridBagConstraints);
        this.jTxtMethodName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MessageSecurityEntryPanel.this.jTxtMethodNameKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtMethodName, gridBagConstraints);
        this.jLblReqAuthSource.setDisplayedMnemonic(this.webserviceBundle.getString("MNE_ReqAuthSource").charAt(0));
        this.jLblReqAuthSource.setText(this.webserviceBundle.getString("LBL_ReqAuthSource_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblReqAuthSource, gridBagConstraints);
        this.jCbxReqAuthSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageSecurityEntryPanel.this.jCbxReqAuthSourceActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxReqAuthSource, gridBagConstraints);
        this.jLblReqAuthRecip.setDisplayedMnemonic(this.webserviceBundle.getString("MNE_ReqAuthRecipient").charAt(0));
        this.jLblReqAuthRecip.setText(this.webserviceBundle.getString("LBL_ReqAuthRecipient_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblReqAuthRecip, gridBagConstraints);
        this.jCbxReqAuthRecip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageSecurityEntryPanel.this.jCbxReqAuthRecipActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxReqAuthRecip, gridBagConstraints);
        this.jLblRespAuthSource.setDisplayedMnemonic(this.webserviceBundle.getString("MNE_RespAuthSource").charAt(0));
        this.jLblRespAuthSource.setText(this.webserviceBundle.getString("LBL_RespAuthSource_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblRespAuthSource, gridBagConstraints);
        this.jCbxRespAuthSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageSecurityEntryPanel.this.jCbxRespAuthSourceActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxRespAuthSource, gridBagConstraints);
        this.jLblRespAuthRecip.setDisplayedMnemonic(this.webserviceBundle.getString("MNE_RespAuthRecipient").charAt(0));
        this.jLblRespAuthRecip.setText(this.webserviceBundle.getString("LBL_RespAuthRecipient_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add((Component)this.jLblRespAuthRecip, gridBagConstraints);
        this.jCbxRespAuthRecip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageSecurityEntryPanel.this.jCbxRespAuthRecipActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.jCbxRespAuthRecip, gridBagConstraints);
    }

    private void jTxtMethodNameKeyReleased(KeyEvent keyEvent) {
        if (!this.initializingFields) {
            String string = this.methodName;
            this.methodName = this.jTxtMethodName.getText().trim();
            if (!this.methodName.equals(string)) {
                this.firePropertyChange("UserDataChanged", null, null);
            }
        }
    }

    private void jCbxRespAuthRecipActionPerformed(ActionEvent actionEvent) {
        if (!this.initializingFields) {
            TextMapping textMapping = (TextMapping)this.authRespRecipientModel.getSelectedItem();
            this.respRecipient = this.normalizeBlank(textMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxRespAuthSourceActionPerformed(ActionEvent actionEvent) {
        if (!this.initializingFields) {
            TextMapping textMapping = (TextMapping)this.authRespSourceModel.getSelectedItem();
            this.respSource = this.normalizeBlank(textMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxReqAuthRecipActionPerformed(ActionEvent actionEvent) {
        if (!this.initializingFields) {
            TextMapping textMapping = (TextMapping)this.authReqRecipientModel.getSelectedItem();
            this.reqRecipient = this.normalizeBlank(textMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxReqAuthSourceActionPerformed(ActionEvent actionEvent) {
        if (!this.initializingFields) {
            TextMapping textMapping = (TextMapping)this.authReqSourceModel.getSelectedItem();
            this.reqSource = this.normalizeBlank(textMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    protected void initUserComponents() {
        int n;
        this.authReqSourceModel = new DefaultComboBoxModel();
        this.authRespSourceModel = new DefaultComboBoxModel();
        for (n = 0; n < this.sourceTypes.length; ++n) {
            this.authReqSourceModel.addElement(this.sourceTypes[n]);
            this.authRespSourceModel.addElement(this.sourceTypes[n]);
        }
        this.jCbxReqAuthSource.setModel(this.authReqSourceModel);
        this.jCbxRespAuthSource.setModel(this.authRespSourceModel);
        this.authReqRecipientModel = new DefaultComboBoxModel();
        this.authRespRecipientModel = new DefaultComboBoxModel();
        for (n = 0; n < this.recipientTypes.length; ++n) {
            this.authReqRecipientModel.addElement(this.recipientTypes[n]);
            this.authRespRecipientModel.addElement(this.recipientTypes[n]);
        }
        this.jCbxReqAuthRecip.setModel(this.authReqRecipientModel);
        this.jCbxRespAuthRecip.setModel(this.authRespRecipientModel);
    }

    private String normalizeBlank(String string) {
        return !string.equals("") ? string : null;
    }

    private TextMapping getAuthMapping(String string, TextMapping[] textMappingArray) {
        TextMapping textMapping = null;
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < textMappingArray.length; ++i) {
            if (textMappingArray[i].getXMLString().compareTo(string) != 0) continue;
            textMapping = textMappingArray[i];
            break;
        }
        return textMapping;
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> arrayList;
        block5: {
            block6: {
                block4: {
                    arrayList = new ArrayList<String>();
                    if (Utils.notEmpty(this.methodName)) break block4;
                    String string = this.webserviceBundle.getString("ERR_MethodNameRequired");
                    arrayList.add(MessageFormat.format(string, this.methodAsOperation ? 1 : 0));
                    break block5;
                }
                if ("*".equals(this.methodName)) break block5;
                if (!this.methodAsOperation) break block6;
                if (Utils.isJavaIdentifier(this.methodName)) break block5;
                arrayList.add(NbBundle.getMessage(MessageSecurityEntryPanel.class, (String)"ERR_OperationNameInvalid", (Object)this.methodName));
                break block5;
            }
            String[] stringArray = MessageEntry.methodSplitter.split(this.methodName);
            if (stringArray.length > 0) {
                if (!Utils.isJavaIdentifier(stringArray[0])) {
                    arrayList.add(NbBundle.getMessage(MessageSecurityEntryPanel.class, (String)"ERR_JavaMethodInvalid", (Object)stringArray[0]));
                } else {
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (Utils.isJavaClass(stringArray[i])) continue;
                        arrayList.add(NbBundle.getMessage(MessageSecurityEntryPanel.class, (String)"ERR_MethodParamInvalid", (Object)stringArray[i]));
                        break;
                    }
                }
            }
        }
        return arrayList;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[]{this.methodName, this.reqSource, this.reqRecipient, this.respSource, this.respRecipient};
        return objectArray;
    }

    public void init(ASDDVersion aSDDVersion, int n, List list, Object object) {
        if (object instanceof Boolean) {
            this.methodAsOperation = (Boolean)object;
        }
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
    }

    public void setValues(Object[] objectArray) {
        if (objectArray != null && objectArray.length == 5) {
            this.methodName = (String)objectArray[0];
            this.reqSource = (String)objectArray[1];
            this.reqRecipient = (String)objectArray[2];
            this.respSource = (String)objectArray[3];
            this.respRecipient = (String)objectArray[4];
        } else {
            if (objectArray != null) assert (objectArray.length == 5);
            this.methodName = "*";
            this.reqSource = null;
            this.reqRecipient = null;
            this.respSource = null;
            this.respRecipient = null;
        }
        this.setComponentValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setComponentValues() {
        try {
            this.initializingFields = true;
            this.jTxtMethodName.setText(this.methodName);
            this.jCbxReqAuthSource.setSelectedItem(this.getAuthMapping(this.reqSource, this.sourceTypes));
            this.jCbxReqAuthRecip.setSelectedItem(this.getAuthMapping(this.reqRecipient, this.recipientTypes));
            this.jCbxRespAuthSource.setSelectedItem(this.getAuthMapping(this.respSource, this.sourceTypes));
            this.jCbxRespAuthRecip.setSelectedItem(this.getAuthMapping(this.respRecipient, this.recipientTypes));
        }
        finally {
            this.initializingFields = false;
        }
    }

    public boolean requiredFieldsFilled() {
        return Utils.notEmpty(this.methodName);
    }
}

