/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Warner;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Symbol
implements Element {
    public int kind;
    public long flags_field;
    public List<Attribute.Compound> attributes_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;

    public long flags() {
        return this.flags_field;
    }

    public List<Attribute.Compound> getAnnotationMirrors() {
        assert (this.attributes_field != null);
        return this.attributes_field;
    }

    public Attribute.Compound attribute(Symbol anno) {
        for (Attribute.Compound a : this.getAnnotationMirrors()) {
            if (a.type.tsym != anno) continue;
            return a;
        }
        return null;
    }

    public Symbol(int kind, long flags, Name name, Type type, Symbol owner) {
        this.kind = kind;
        this.flags_field = flags;
        this.type = type;
        this.owner = owner;
        this.completer = null;
        this.erasure_field = null;
        this.attributes_field = List.nil();
        this.name = name;
    }

    public Symbol clone(Symbol newOwner) {
        throw new AssertionError();
    }

    public <R, P> R accept(Visitor<R, P> v, P p) {
        return v.visitSymbol(this, p);
    }

    public String toString() {
        return this.name.toString();
    }

    public Symbol location() {
        if (this.owner.name == null || this.owner.name.isEmpty() && this.owner.kind == 1) {
            return null;
        }
        return this.owner;
    }

    public Symbol location(Type site, Types types) {
        Type ownertype;
        if (this.owner.name == null || this.owner.name.isEmpty()) {
            return this.location();
        }
        if (this.owner.type.tag == 10 && (ownertype = types.asOuterSuper(site, this.owner)) != null) {
            return ownertype.tsym;
        }
        return this.owner;
    }

    public Type erasure(Types types) {
        if (this.erasure_field == null) {
            this.erasure_field = types.erasure(this.type);
        }
        return this.erasure_field;
    }

    public Type externalType(Types types) {
        Type t = this.erasure(types);
        if (this.name == this.name.table.names.init && this.owner.hasOuterInstance()) {
            Type outerThisType = types.erasure(this.owner.type.getEnclosingType());
            return new Type.MethodType(t.getParameterTypes().prepend(outerThisType), t.getReturnType(), t.getThrownTypes(), t.tsym);
        }
        return t;
    }

    public boolean isStatic() {
        return (this.flags() & 8L) != 0L || (this.owner.flags() & 0x200L) != 0L && this.kind != 16;
    }

    public boolean isInterface() {
        return (this.flags() & 0x200L) != 0L;
    }

    public boolean isLocal() {
        return (this.owner.kind & 0x14) != 0 || this.owner.kind == 2 && this.owner.isLocal();
    }

    public boolean isConstructor() {
        return this.name == this.name.table.names.init;
    }

    public Name getQualifiedName() {
        return this.name;
    }

    public Name flatName() {
        return this.getQualifiedName();
    }

    public Scope members() {
        return null;
    }

    public boolean isInner() {
        return this.type.getEnclosingType().tag == 10;
    }

    public boolean hasOuterInstance() {
        return this.type.getEnclosingType().tag == 10 && (this.flags() & 0x400200L) == 0L;
    }

    public ClassSymbol enclClass() {
        Symbol c = this;
        while (c != null && ((c.kind & 2) == 0 || c.type.tag != 10 && c.type.tag != 19)) {
            c = c.owner;
        }
        return (ClassSymbol)c;
    }

    public ClassSymbol outermostClass() {
        Symbol sym = this;
        Symbol prev = null;
        while (sym.kind != 1) {
            prev = sym;
            sym = sym.owner;
        }
        return (ClassSymbol)prev;
    }

    public PackageSymbol packge() {
        Symbol sym = this;
        while (sym.kind != 1) {
            sym = sym.owner;
        }
        return (PackageSymbol)sym;
    }

    public boolean isSubClass(Symbol base, Types types) {
        throw new AssertionError((Object)("isSubClass " + this));
    }

    public boolean isMemberOf(TypeSymbol clazz, Types types) {
        return this.owner == clazz || clazz.isSubClass(this.owner, types) && this.isInheritedIn(clazz, types) && !this.hiddenIn((ClassSymbol)clazz, types);
    }

    public boolean isEnclosedBy(ClassSymbol clazz) {
        Symbol sym = this;
        while (sym.kind != 1) {
            if (sym == clazz) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private boolean hiddenIn(ClassSymbol clazz, Types types) {
        if (this.kind == 16 && (this.flags() & 8L) == 0L) {
            return false;
        }
        while (this.owner != clazz) {
            Scope.Entry e = clazz.members().lookup(this.name);
            while (e.scope != null) {
                if (e.sym == this) {
                    return false;
                }
                if (e.sym.kind == this.kind && (this.kind != 16 || (e.sym.flags() & 8L) != 0L && types.isSubSignature(e.sym.type, this.type))) {
                    return true;
                }
                e = e.next();
            }
            Type superType = types.supertype(clazz.type);
            if (superType.tag != 10) {
                return false;
            }
            clazz = (ClassSymbol)superType.tsym;
        }
        return false;
    }

    public boolean isInheritedIn(Symbol clazz, Types types) {
        switch ((int)(this.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return this.owner == clazz;
            }
            case 4: {
                return (clazz.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        PackageSymbol thisPackage = this.packge();
        Symbol sup = clazz;
        while (sup != null && sup != this.owner) {
            while (sup.type.tag == 14) {
                sup = sup.type.getUpperBound().tsym;
            }
            if (sup.type.isErroneous()) {
                return true;
            }
            if ((sup.flags() & 0x1000000L) == 0L && sup.packge() != thisPackage) {
                return false;
            }
            sup = types.supertype((Type)sup.type).tsym;
        }
        return (clazz.flags() & 0x200L) == 0L;
    }

    public Symbol asMemberOf(Type site, Types types) {
        throw new AssertionError();
    }

    public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
        return false;
    }

    public void complete() throws CompletionFailure {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
    }

    public boolean exists() {
        return true;
    }

    @Override
    public Type asType() {
        return this.type;
    }

    @Override
    public Symbol getEnclosingElement() {
        return this.owner;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Flags.asModifierSet(this.flags());
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    @Override
    @Deprecated
    public <A extends Annotation> A getAnnotation(Class<A> annoType) {
        return JavacElements.getAnnotation(this, annoType);
    }

    public java.util.List<Symbol> getEnclosedElements() {
        return List.nil();
    }

    public List<TypeSymbol> getTypeParameters() {
        ListBuffer l = ListBuffer.lb();
        for (Type t : this.type.getTypeArguments()) {
            l.append(t.tsym);
        }
        return l.toList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<R, P> {
        public R visitClassSymbol(ClassSymbol var1, P var2);

        public R visitMethodSymbol(MethodSymbol var1, P var2);

        public R visitPackageSymbol(PackageSymbol var1, P var2);

        public R visitOperatorSymbol(OperatorSymbol var1, P var2);

        public R visitVarSymbol(VarSymbol var1, P var2);

        public R visitTypeSymbol(TypeSymbol var1, P var2);

        public R visitSymbol(Symbol var1, P var2);
    }

    public static class CompletionFailure
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public Symbol sym;
        public JCDiagnostic diag;
        @Deprecated
        public String errmsg;

        public CompletionFailure(Symbol sym, String errmsg) {
            this.sym = sym;
            this.errmsg = errmsg;
        }

        public CompletionFailure(Symbol sym, JCDiagnostic diag) {
            this.sym = sym;
            this.diag = diag;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diag;
        }

        public String getMessage() {
            if (this.diag != null) {
                return this.diag.getMessage(null);
            }
            return this.errmsg;
        }

        public Object getDetailValue() {
            return this.diag != null ? this.diag : this.errmsg;
        }

        public CompletionFailure initCause(Throwable cause) {
            super.initCause(cause);
            return this;
        }
    }

    public static interface Completer {
        public void complete(Symbol var1) throws CompletionFailure;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;

        public OperatorSymbol(Name name, Type type, int opcode, Symbol owner) {
            super(9L, name, type, owner);
            this.opcode = opcode;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitOperatorSymbol(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodSymbol
    extends Symbol
    implements ExecutableElement {
        public Code code = null;
        public List<VarSymbol> params = null;
        public List<Name> savedParameterNames;
        public Attribute defaultValue = null;
        public final MethodSymbol originalMethod;

        public MethodSymbol(long flags, Name name, Type type, Symbol owner) {
            this(flags, name, type, owner, null);
        }

        private MethodSymbol(long flags, Name name, Type type, Symbol owner, MethodSymbol originalMethod) {
            super(16, flags, name, type, owner);
            assert (owner.type.tag != 14) : owner + "." + name;
            this.originalMethod = originalMethod;
        }

        @Override
        public MethodSymbol clone(Symbol newOwner) {
            MethodSymbol m = new MethodSymbol(this.flags_field, this.name, this.type, newOwner, this.originalMethod != null ? this.originalMethod : this);
            m.code = this.code;
            return m;
        }

        @Override
        public String toString() {
            String s;
            if ((this.flags() & 0x100000L) != 0L) {
                return this.owner.name.toString();
            }
            String string = s = this.name == this.name.table.names.init ? this.owner.name.toString() : this.name.toString();
            if (this.type != null) {
                if (this.type.tag == 16) {
                    s = "<" + ((Type.ForAll)this.type).getTypeArguments() + ">" + s;
                }
                s = s + "(" + this.type.argtypes((this.flags() & 0x400000000L) != 0L) + ")";
            }
            return s;
        }

        public Symbol implemented(TypeSymbol c, Types types) {
            Symbol impl = null;
            List<Type> is = types.interfaces(c.type);
            while (impl == null && is.nonEmpty()) {
                TypeSymbol i = ((Type)is.head).tsym;
                Scope.Entry e = i.members().lookup(this.name);
                while (impl == null && e.scope != null) {
                    if (this.overrides(e.sym, (TypeSymbol)this.owner, types, true) && types.isSameType(this.type.getReturnType(), types.memberType(this.owner.type, e.sym).getReturnType())) {
                        impl = e.sym;
                    }
                    if (impl == null) {
                        impl = this.implemented(i, types);
                    }
                    e = e.next();
                }
                is = is.tail;
            }
            return impl;
        }

        public boolean binaryOverrides(Symbol _other, TypeSymbol origin, Types types) {
            if (this.isConstructor() || _other.kind != 16) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSameType(this.erasure(types), other.erasure(types))) {
                return true;
            }
            return (this.flags() & 0x400L) == 0L && other.isOverridableIn(origin) && this.isMemberOf(origin, types) && types.isSameType(this.erasure(types), other.erasure(types));
        }

        public MethodSymbol binaryImplementation(ClassSymbol origin, Types types) {
            TypeSymbol c = origin;
            while (c != null && c.type.tag != 19) {
                Scope.Entry e = ((Symbol)c).members().lookup(this.name);
                while (e.scope != null) {
                    if (e.sym.kind == 16 && ((MethodSymbol)e.sym).binaryOverrides(this, origin, types)) {
                        return (MethodSymbol)e.sym;
                    }
                    e = e.next();
                }
                c = types.supertype((Type)c.type).tsym;
            }
            return null;
        }

        @Override
        public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
            Type ot;
            Type mt;
            if (this.isConstructor() || _other.kind != 16) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSubSignature(mt = types.memberType(this.owner.type, this), ot = types.memberType(this.owner.type, other))) {
                if (!checkResult) {
                    return true;
                }
                if (types.returnTypeSubstitutable(mt, ot)) {
                    return true;
                }
            }
            if ((this.flags() & 0x400L) != 0L || (other.flags() & 0x400L) == 0L || !other.isOverridableIn(origin) || !this.isMemberOf(origin, types)) {
                return false;
            }
            mt = types.memberType(origin.type, this);
            return types.isSubSignature(mt, ot = types.memberType(origin.type, other)) && (!checkResult || types.resultSubtype(mt, ot, Warner.noWarnings));
        }

        private boolean isOverridableIn(TypeSymbol origin) {
            switch ((int)(this.flags_field & 7L)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 4: {
                    return (origin.flags() & 0x200L) == 0L;
                }
                case 0: {
                    return this.packge() == origin.packge() && (origin.flags() & 0x200L) == 0L;
                }
            }
            return false;
        }

        public MethodSymbol implementation(TypeSymbol origin, Types types, boolean checkResult) {
            Type t = origin.type;
            while (t.tag == 10 || t.tag == 14) {
                while (t.tag == 14) {
                    t = t.getUpperBound();
                }
                TypeSymbol c = t.tsym;
                Scope.Entry e = c.members().lookup(this.name);
                while (e.scope != null) {
                    MethodSymbol m;
                    if (e.sym.kind == 16 && (m = (MethodSymbol)e.sym).overrides(this, origin, types, checkResult) && (m.flags() & 0x1000L) == 0L) {
                        return m;
                    }
                    e = e.next();
                }
                t = types.supertype(t);
            }
            if (types.isDerivedRaw(origin.type)) {
                return this.implementation(types.supertype((Type)origin.type).tsym, types, checkResult);
            }
            return null;
        }

        public List<VarSymbol> params() {
            this.owner.complete();
            if (this.params == null) {
                List<Name> names = this.savedParameterNames;
                this.savedParameterNames = null;
                ListBuffer<VarSymbol> buf = new ListBuffer<VarSymbol>();
                if (names == null) {
                    names = List.nil();
                    int i = 0;
                    for (Type t : this.type.getParameterTypes()) {
                        names = names.prepend(this.name.table.fromString("arg" + i++));
                    }
                    names = names.reverse();
                    for (Type t : this.type.getParameterTypes()) {
                        buf.append(new ParamSymbol(0x200000000L, (Name)names.head, t, this));
                        names = names.tail;
                    }
                } else {
                    int i = 0;
                    for (Type t : this.type.getParameterTypes()) {
                        if (names.nonEmpty()) {
                            buf.append(new VarSymbol(0x200000000L, names.head != null ? (Name)names.head : this.name.table.fromString("arg" + i), t, this));
                            names = names.tail;
                        } else {
                            buf.append(new VarSymbol(0x200000000L, this.name.table.fromString("arg" + i), t, this));
                        }
                        ++i;
                    }
                }
                this.params = buf.toList();
            }
            return this.params;
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new MethodSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            if (this.name == this.name.table.names.init) {
                return ElementKind.CONSTRUCTOR;
            }
            if (this.name == this.name.table.names.clinit) {
                return ElementKind.STATIC_INIT;
            }
            if ((this.flags_field & 0x100000L) != 0L) {
                return (this.flags_field & 8L) != 0L ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
            }
            return ElementKind.METHOD;
        }

        @Override
        public Attribute getDefaultValue() {
            return this.defaultValue;
        }

        public List<VarSymbol> getParameters() {
            return this.params();
        }

        @Override
        public boolean isVarArgs() {
            return (this.flags() & 0x400000000L) != 0L;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitMethodSymbol(this, p);
        }

        @Override
        public Type getReturnType() {
            return ((Type)this.asType()).getReturnType();
        }

        public List<Type> getThrownTypes() {
            return ((Type)this.asType()).getThrownTypes();
        }
    }

    public static class ParamSymbol
    extends VarSymbol {
        private boolean initialized = false;

        public ParamSymbol(long flags, Name name, Type type, Symbol owner) {
            super(flags, name, type, owner);
        }

        public Name getSimpleName() {
            if (!this.initialized) {
                ClassSymbol enclClass = this.enclClass();
                new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitVariable(VariableElement e, Void p) {
                        if (e instanceof ParamSymbol) {
                            ((ParamSymbol)e).initialized = true;
                        }
                        return (Void)super.visitVariable(e, p);
                    }

                    @Override
                    public Void visitType(TypeElement te, Void p) {
                        if (te instanceof ClassSymbol) {
                            List<Symbol> list = List.nil();
                            Scope.Entry e = ((ClassSymbol)te).members().elems;
                            while (e != null) {
                                try {
                                    if (e.sym != null && e.sym.owner == te) {
                                        list = list.prepend(e.sym);
                                    }
                                }
                                catch (CompletionFailure cf) {
                                    // empty catch block
                                }
                                e = e.sibling;
                            }
                            return (Void)this.scan(list, p);
                        }
                        return (Void)super.visitType(te, p);
                    }
                }.scan(enclClass);
                if (!this.name.table.loader.loadTreeFor(enclClass, true)) {
                    this.name.table.loader.loadParamNames(enclClass);
                }
            }
            return super.getSimpleName();
        }

        public void setName(Name name) {
            if (this.name != name) {
                super.setName(this.name.table.fromString(name.toString()));
            }
        }

        public String toString() {
            return this.getSimpleName().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VarSymbol
    extends Symbol
    implements VariableElement {
        public int pos = -1;
        public int adr = -1;
        public final VarSymbol originalVar;
        private Object data;

        public VarSymbol(long flags, Name name, Type type, Symbol owner) {
            this(flags, name, type, owner, null);
        }

        private VarSymbol(long flags, Name name, Type type, Symbol owner, VarSymbol originalVar) {
            super(4, flags, name, type, owner);
            this.originalVar = originalVar;
        }

        @Override
        public VarSymbol clone(Symbol newOwner) {
            VarSymbol v = new VarSymbol(this.flags_field, this.name, this.type, newOwner, this.originalVar != null ? this.originalVar : this);
            v.pos = this.pos;
            v.adr = this.adr;
            v.data = this.data;
            return v;
        }

        @Override
        public String toString() {
            return this.name.toString();
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new VarSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            long flags = this.flags();
            if ((flags & 0x200000000L) != 0L) {
                if (this.isExceptionParameter()) {
                    return ElementKind.EXCEPTION_PARAMETER;
                }
                return ElementKind.PARAMETER;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM_CONSTANT;
            }
            if (this.owner.kind == 2 || this.owner.kind == 31) {
                return ElementKind.FIELD;
            }
            return ElementKind.LOCAL_VARIABLE;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitVariable(this, p);
        }

        @Override
        public Object getConstantValue() {
            return Constants.decode(this.getConstValue(), this.type);
        }

        public void setLazyConstValue(final Env<AttrContext> env, final Log log, final Attr attr, final JCTree.JCExpression initializer) {
            this.setData(new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() {
                    JavaFileObject source;
                    block3: {
                        Object object;
                        source = log.useSource(env.toplevel.sourcefile);
                        try {
                            Type itype = attr.attribExpr(initializer, env, VarSymbol.this.type);
                            if (itype.constValue() == null) break block3;
                            object = attr.coerce(itype, VarSymbol.this.type).constValue();
                            Object var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            log.useSource(source);
                            throw throwable;
                        }
                        log.useSource(source);
                        return object;
                    }
                    Object var3_4 = null;
                    Object var5_6 = null;
                    log.useSource(source);
                    return var3_4;
                }
            });
        }

        public boolean isExceptionParameter() {
            return this.data == ElementKind.EXCEPTION_PARAMETER;
        }

        public Object getConstValue() {
            if (this.data == ElementKind.EXCEPTION_PARAMETER) {
                return null;
            }
            if (this.data instanceof Callable) {
                Callable eval = (Callable)this.data;
                this.data = null;
                try {
                    this.data = eval.call();
                }
                catch (Attr.BreakAttr bk) {
                    throw bk;
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return this.data;
        }

        public void setData(Object data) {
            assert (!(data instanceof Env)) : this;
            this.data = data;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitVarSymbol(this, p);
        }

        public void setName(Name name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSymbol
    extends TypeSymbol
    implements TypeElement {
        public Scope members_field = null;
        public Name fullname;
        public Name flatname;
        public JavaFileObject sourcefile;
        public JavaFileObject classfile;
        public Pool pool;

        public ClassSymbol(long flags, Name name, Type type, Symbol owner) {
            super(flags, name, type, owner);
            this.fullname = ClassSymbol.formFullName(name, owner);
            this.flatname = ClassSymbol.formFlatName(name, owner);
            this.sourcefile = null;
            this.classfile = null;
            this.pool = null;
        }

        public ClassSymbol(long flags, Name name, Symbol owner) {
            this(flags, name, new Type.ClassType(Type.noType, null, null), owner);
            this.type.tsym = this;
        }

        @Override
        public String toString() {
            return this.className();
        }

        @Override
        public long flags() {
            try {
                if (this.completer != null) {
                    this.complete();
                }
            }
            catch (CompletionFailure completionFailure) {
                // empty catch block
            }
            return this.flags_field;
        }

        @Override
        public Scope members() {
            try {
                if (this.completer != null) {
                    this.complete();
                }
            }
            catch (CompletionFailure completionFailure) {
                // empty catch block
            }
            return this.members_field;
        }

        @Override
        public List<Attribute.Compound> getAnnotationMirrors() {
            if (this.completer != null) {
                this.complete();
            }
            assert (this.attributes_field != null);
            return this.attributes_field;
        }

        @Override
        public Type erasure(Types types) {
            if (this.erasure_field == null) {
                this.erasure_field = new Type.ClassType(types.erasure(this.type.getEnclosingType()), List.<Type>nil(), this);
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.isEmpty()) {
                return Log.getLocalizedString("anonymous.class", this.flatname);
            }
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public Name flatName() {
            return this.flatname;
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            if (this == base) {
                return true;
            }
            if ((base.flags() & 0x200L) != 0L) {
                Type t = this.type;
                while (t.tag == 10) {
                    List<Type> is = types.interfaces(t);
                    while (is.nonEmpty()) {
                        if (((Type)is.head).tsym.isSubClass(base, types)) {
                            return true;
                        }
                        is = is.tail;
                    }
                    t = types.supertype(t);
                }
            } else {
                Type t = this.type;
                while (t.tag == 10) {
                    if (t.tsym == base) {
                        return true;
                    }
                    t = types.supertype(t);
                }
            }
            return false;
        }

        @Override
        public void complete() throws CompletionFailure {
            try {
                super.complete();
            }
            catch (CompletionFailure ex) {
                this.flags_field |= 9L;
                this.type = new Type.ErrorType(this, Type.noType);
                throw ex;
            }
        }

        public List<Type> getInterfaces() {
            try {
                this.complete();
            }
            catch (CompletionFailure cf) {
                // empty catch block
            }
            if (this.type instanceof Type.ClassType) {
                Type.ClassType t = (Type.ClassType)this.type;
                if (t.interfaces_field == null) {
                    t.interfaces_field = List.nil();
                }
                return t.interfaces_field;
            }
            return List.nil();
        }

        @Override
        public Type getSuperclass() {
            try {
                this.complete();
            }
            catch (CompletionFailure cf) {
                // empty catch block
            }
            if (this.type instanceof Type.ClassType) {
                Type.ClassType t = (Type.ClassType)this.type;
                if (t.supertype_field == null) {
                    t.supertype_field = Type.noType;
                }
                return t.isInterface() ? Type.noType : t.supertype_field;
            }
            return Type.noType;
        }

        @Override
        public ElementKind getKind() {
            long flags = this.flags();
            if ((flags & 0x2000L) != 0L) {
                return ElementKind.ANNOTATION_TYPE;
            }
            if ((flags & 0x200L) != 0L) {
                return ElementKind.INTERFACE;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM;
            }
            return ElementKind.CLASS;
        }

        @Override
        public NestingKind getNestingKind() {
            try {
                this.complete();
            }
            catch (CompletionFailure completionFailure) {
                // empty catch block
            }
            if (this.owner.kind == 1) {
                return NestingKind.TOP_LEVEL;
            }
            if (this.name.isEmpty()) {
                return NestingKind.ANONYMOUS;
            }
            if (this.owner.kind == 16) {
                return NestingKind.LOCAL;
            }
            return NestingKind.MEMBER;
        }

        @Override
        @Deprecated
        public <A extends Annotation> A getAnnotation(Class<A> annoType) {
            return JavacElements.getAnnotation(this, annoType);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitClassSymbol(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageSymbol
    extends TypeSymbol
    implements PackageElement {
        public Scope members_field;
        public Name fullname;
        public ClassSymbol package_info;

        public PackageSymbol(Name name, Type type, Symbol owner) {
            super(0L, name, type, owner);
            this.kind = 1;
            this.members_field = null;
            this.fullname = PackageSymbol.formFullName(name, owner);
        }

        public PackageSymbol(Name name, Symbol owner) {
            this(name, null, owner);
            this.type = new Type.PackageType(this);
        }

        @Override
        public String toString() {
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner != null;
        }

        @Override
        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        @Override
        public long flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        @Override
        public List<Attribute.Compound> getAnnotationMirrors() {
            if (this.completer != null) {
                this.complete();
            }
            assert (this.attributes_field != null);
            return this.attributes_field;
        }

        @Override
        public boolean exists() {
            return (this.flags_field & 0x800000L) != 0L;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Symbol getEnclosingElement() {
            return null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitPackageSymbol(this, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSymbol
    extends Symbol
    implements TypeParameterElement {
        public TypeSymbol(long flags, Name name, Type type, Symbol owner) {
            super(2, flags, name, type, owner);
        }

        public static Name formFullName(Name name, Symbol owner) {
            if (owner == null) {
                return name;
            }
            if (owner.kind != 31 && ((owner.kind & 0x14) != 0 || owner.kind == 2 && owner.type.tag == 14)) {
                return name;
            }
            Name prefix = owner.getQualifiedName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append('.', name);
        }

        public static Name formFlatName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x14) != 0 || owner.kind == 2 && owner.type.tag == 14) {
                return name;
            }
            char sep = owner.kind == 2 ? (char)'$' : '.';
            Name prefix = owner.flatName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append(sep, name);
        }

        public final boolean precedes(TypeSymbol that, Types types) {
            if (this == that) {
                return false;
            }
            if (this.type.tag == that.type.tag) {
                if (this.type.tag == 10) {
                    return types.rank(that.type) < types.rank(this.type) || types.rank(that.type) == types.rank(this.type) && that.getQualifiedName().compareTo(this.getQualifiedName()) < 0;
                }
                if (this.type.tag == 14) {
                    return types.isSubtype(this.type, that.type);
                }
            }
            return this.type.tag == 14;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.TYPE_PARAMETER;
        }

        @Override
        public java.util.List<Symbol> getEnclosedElements() {
            List<Symbol> list = List.nil();
            Scope.Entry e = this.members().elems;
            while (e != null) {
                try {
                    if (e.sym != null && (e.sym.flags() & 0x1000L) == 0L && e.sym.owner == this) {
                        list = list.prepend(e.sym);
                    }
                }
                catch (CompletionFailure completionFailure) {
                    // empty catch block
                }
                e = e.sibling;
            }
            return list;
        }

        @Override
        public Symbol getGenericElement() {
            return this.owner;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            assert (this.type.tag == 14);
            return v.visitTypeParameter(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitTypeSymbol(this, p);
        }

        public List<Type> getBounds() {
            Type.TypeVar t = (Type.TypeVar)this.type;
            Type bound = t.getUpperBound();
            if (bound == null) {
                return List.nil();
            }
            if (!bound.isCompound()) {
                return List.of(bound);
            }
            Type.ClassType ct = (Type.ClassType)bound;
            if (!ct.tsym.erasure_field.isInterface()) {
                return ct.interfaces_field.prepend(ct.supertype_field);
            }
            return ct.interfaces_field;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DelegatedSymbol
    extends Symbol {
        protected Symbol other;

        public DelegatedSymbol(Symbol other) {
            super(other.kind, other.flags_field, other.name, other.type, other.owner);
            this.other = other;
        }

        @Override
        public String toString() {
            return this.other.toString();
        }

        @Override
        public Symbol location() {
            return this.other.location();
        }

        @Override
        public Symbol location(Type site, Types types) {
            return this.other.location(site, types);
        }

        @Override
        public Type erasure(Types types) {
            return this.other.erasure(types);
        }

        @Override
        public Type externalType(Types types) {
            return this.other.externalType(types);
        }

        @Override
        public boolean isLocal() {
            return this.other.isLocal();
        }

        @Override
        public boolean isConstructor() {
            return this.other.isConstructor();
        }

        @Override
        public Name getQualifiedName() {
            return this.other.getQualifiedName();
        }

        @Override
        public Name flatName() {
            return this.other.flatName();
        }

        @Override
        public Scope members() {
            return this.other.members();
        }

        @Override
        public boolean isInner() {
            return this.other.isInner();
        }

        @Override
        public boolean hasOuterInstance() {
            return this.other.hasOuterInstance();
        }

        @Override
        public ClassSymbol enclClass() {
            return this.other.enclClass();
        }

        @Override
        public ClassSymbol outermostClass() {
            return this.other.outermostClass();
        }

        @Override
        public PackageSymbol packge() {
            return this.other.packge();
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            return this.other.isSubClass(base, types);
        }

        @Override
        public boolean isMemberOf(TypeSymbol clazz, Types types) {
            return this.other.isMemberOf(clazz, types);
        }

        @Override
        public boolean isEnclosedBy(ClassSymbol clazz) {
            return this.other.isEnclosedBy(clazz);
        }

        @Override
        public boolean isInheritedIn(Symbol clazz, Types types) {
            return this.other.isInheritedIn(clazz, types);
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return this.other.asMemberOf(site, types);
        }

        @Override
        public void complete() throws CompletionFailure {
            this.other.complete();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return this.other.accept(v, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitSymbol(this.other, p);
        }
    }
}

