/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;

public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName name) {
            super(name, null, null);
        }

        HiddenOption(OptionName name, String argsNameKey) {
            super(name, argsNameKey, null);
        }

        void help(PrintWriter out) {
        }

        void xhelp(PrintWriter out) {
        }

        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XOption
    extends Option {
        XOption(OptionName name, String argsNameKey, String descrKey) {
            super(name, argsNameKey, descrKey);
        }

        XOption(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        XOption(OptionName name, String descrKey, ChoiceKind kind, String ... choices) {
            super(name, descrKey, kind, choices);
        }

        XOption(OptionName name, String descrKey, ChoiceKind kind, Collection<String> choices) {
            super(name, descrKey, kind, choices);
        }

        @Override
        void help(PrintWriter out) {
        }

        @Override
        void xhelp(PrintWriter out) {
            super.help(out);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;
        ChoiceKind choiceKind;
        Collection<String> choices;

        Option(OptionName name, String argsNameKey, String descrKey) {
            this.name = name;
            this.argsNameKey = argsNameKey;
            this.descrKey = descrKey;
            char lastChar = name.optionName.charAt(name.optionName.length() - 1);
            this.hasSuffix = lastChar == ':' || lastChar == '=';
        }

        Option(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        Option(OptionName name, String descrKey, ChoiceKind choiceKind, String ... choices) {
            this(name, descrKey, choiceKind, Arrays.asList(choices));
        }

        Option(OptionName name, String descrKey, ChoiceKind choiceKind, Collection<String> choices) {
            this(name, null, descrKey);
            if (choiceKind == null || choices == null) {
                throw new NullPointerException();
            }
            this.choiceKind = choiceKind;
            this.choices = choices;
        }

        public String toString() {
            return this.name.optionName;
        }

        @Override
        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        @Override
        public boolean matches(String option) {
            if (!this.hasSuffix) {
                return option.equals(this.name.optionName);
            }
            if (!option.startsWith(this.name.optionName)) {
                return false;
            }
            if (this.choices != null) {
                String arg = option.substring(this.name.optionName.length());
                if (this.choiceKind == ChoiceKind.ONEOF) {
                    return this.choices.contains(arg);
                }
                for (String a : arg.split(",+")) {
                    if (this.choices.contains(a)) continue;
                    return false;
                }
            }
            return true;
        }

        void help(PrintWriter out) {
            String s = "  " + this.helpSynopsis();
            out.print(s);
            for (int j = Math.min(s.length(), 28); j < 29; ++j) {
                out.print(" ");
            }
            Log.printLines(out, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.name);
            if (this.argsNameKey == null) {
                if (this.choices != null) {
                    String sep = "{";
                    for (String c : this.choices) {
                        sb.append(sep);
                        sb.append(c);
                        sep = ",";
                    }
                    sb.append("}");
                }
            } else {
                if (!this.hasSuffix) {
                    sb.append(" ");
                }
                sb.append(Main.getLocalizedString(this.argsNameKey, new Object[0]));
            }
            return sb.toString();
        }

        void xhelp(PrintWriter out) {
        }

        @Override
        public boolean process(Options options, String option, String arg) {
            if (options != null) {
                if (this.choices != null) {
                    if (this.choiceKind == ChoiceKind.ONEOF) {
                        for (String c : this.choices) {
                            options.remove(option + c);
                        }
                        String opt = option + arg;
                        options.put(opt, opt);
                        String nm = option.substring(0, option.length() - 1);
                        options.put(nm, arg);
                    } else {
                        for (String a : arg.split(",+")) {
                            String opt = option + a;
                            options.put(opt, opt);
                        }
                    }
                }
                options.put(option, arg);
            }
            return false;
        }

        @Override
        public boolean process(Options options, String option) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, option.substring(this.name.optionName.length()));
            }
            return this.process(options, option, option);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        @Override
        public OptionName getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }
}

