/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class Scanner
implements Lexer {
    private static boolean scannerDebug = false;
    private Token token;
    private boolean allowHexFloats;
    private int pos;
    private int endPos;
    private int prevEndPos;
    private int errPos = -1;
    private Name name;
    private int radix;
    protected boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private int eofPos;
    private int seek;
    private char replacedCharacter;
    private char ch;
    private int unicodeConversionBp = -1;
    private final Log log;
    private final Names names;
    private final Keywords keywords;
    private static final boolean hexFloatsWork = Scanner.hexFloatsWork();
    static final boolean surrogatesSupported = Scanner.surrogatesSupported();

    private Scanner(Factory fac) {
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.allowHexFloats = fac.source.allowHexFloats();
    }

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected Scanner(Factory fac, CharBuffer buffer) {
        this(fac, JavacFileManager.toArray(buffer), buffer.limit());
    }

    protected Scanner(Factory fac, char[] input, int inputLength) {
        this(fac);
        this.eofPos = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && Character.isWhitespace(input[input.length - 1])) {
                this.replacedCharacter = input[--inputLength];
            } else {
                char[] newInput = new char[inputLength + 1];
                System.arraycopy(input, 0, newInput, 0, input.length);
                input = newInput;
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    private void lexError(int pos, String key, Object ... args) {
        this.log.error(pos, key, args);
        this.token = Token.ERROR;
        this.errPos = pos;
    }

    private void lexError(String key, Object ... args) {
        this.lexError(this.pos, key, args);
    }

    private int digit(int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.lexError(this.pos + 1, "illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        d = this.digit(16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(this.bp, "illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        this.ch = this.buf[++this.bp];
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int oct = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            oct = oct * 8 + this.digit(8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.ch && this.ch <= '7') {
                                oct = oct * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(this.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                if (!this.allowHexFloats) {
                    this.lexError("unsupported.fp.lit", new Object[0]);
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError("unsupported.cross.fp.lit", new Object[0]);
                }
            } else {
                this.lexError("malformed.fp.lit", new Object[0]);
            }
        } else {
            this.lexError("malformed.fp.lit", new Object[0]);
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanFraction() {
        while (this.digit(10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int sp1 = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed.fp.lit", new Object[0]);
            this.sp = sp1;
        }
    }

    private void scanFractionAndSuffix() {
        this.radix = 10;
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(boolean seendigit) {
        this.radix = 16;
        assert (this.ch == '.');
        this.putChar(this.ch);
        this.scanChar();
        while (this.digit(16) >= 0) {
            seendigit = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (!seendigit) {
            this.lexError("invalid.hex.number", new Object[0]);
        } else {
            this.scanHexExponentAndSuffix();
        }
    }

    private void scanNumber(int radix) {
        this.radix = radix;
        int digitRadix = radix <= 10 ? 10 : 16;
        boolean seendigit = false;
        while (this.digit(digitRadix) >= 0) {
            seendigit = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (radix == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(seendigit);
        } else if (seendigit && radix == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (radix <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (radix <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = Token.LONGLITERAL;
        } else {
            this.token = Token.INTLITERAL;
        }
    }

    private void scanIdent() {
        block4: while (true) {
            boolean isJavaIdentifierPart;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block4;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block4;
                    this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                    this.token = this.keywords.key(this.name);
                    return;
                }
            }
            if (this.ch < '\u0080') {
                isJavaIdentifierPart = false;
            } else {
                char high = this.scanSurrogates();
                if (high != '\u0000') {
                    if (this.sp == this.sbuf.length) {
                        this.putChar(high);
                    } else {
                        this.sbuf[this.sp++] = high;
                    }
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(Character.toCodePoint(high, this.ch));
                } else {
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(this.ch);
                }
            }
            if (!isJavaIdentifierPart) break;
        }
        this.name = this.names.fromChars(this.sbuf, 0, this.sp);
        this.token = this.keywords.key(this.name);
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    private char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char high = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return high;
            }
            this.ch = high;
        }
        return '\u0000';
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name newname = this.names.fromChars(this.sbuf, 0, this.sp);
            if (this.keywords.key(newname) == Token.IDENTIFIER) {
                --this.sp;
                break;
            }
            this.name = newname;
            this.token = this.keywords.key(newname);
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocComment() {
        boolean deprecatedPrefix = false;
        block5: while (this.bp < this.buflen) {
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            while (this.bp < this.buflen && this.ch == '*') {
                this.scanCommentChar();
                if (this.ch != '/') continue;
                return;
            }
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            deprecatedPrefix = false;
            if (this.bp < this.buflen && this.ch == '@' && !this.deprecatedFlag) {
                this.scanCommentChar();
                if (this.bp < this.buflen && this.ch == 'd') {
                    this.scanCommentChar();
                    if (this.bp < this.buflen && this.ch == 'e') {
                        this.scanCommentChar();
                        if (this.bp < this.buflen && this.ch == 'p') {
                            this.scanCommentChar();
                            if (this.bp < this.buflen && this.ch == 'r') {
                                this.scanCommentChar();
                                if (this.bp < this.buflen && this.ch == 'e') {
                                    this.scanCommentChar();
                                    if (this.bp < this.buflen && this.ch == 'c') {
                                        this.scanCommentChar();
                                        if (this.bp < this.buflen && this.ch == 'a') {
                                            this.scanCommentChar();
                                            if (this.bp < this.buflen && this.ch == 't') {
                                                this.scanCommentChar();
                                                if (this.bp < this.buflen && this.ch == 'e') {
                                                    this.scanCommentChar();
                                                    if (this.bp < this.buflen && this.ch == 'd') {
                                                        deprecatedPrefix = true;
                                                        this.scanCommentChar();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (deprecatedPrefix && this.bp < this.buflen) {
                if (Character.isWhitespace(this.ch)) {
                    this.deprecatedFlag = true;
                } else if (this.ch == '*') {
                    this.scanCommentChar();
                    if (this.ch == '/') {
                        this.deprecatedFlag = true;
                        return;
                    }
                }
            }
            block9: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        this.scanCommentChar();
                        if (this.ch != '/') continue block9;
                        return;
                    }
                    case '\r': {
                        this.scanCommentChar();
                        if (this.ch != '\n') continue block5;
                    }
                    case '\n': {
                        this.scanCommentChar();
                        continue block5;
                    }
                }
                this.scanCommentChar();
            }
        }
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nextToken() {
        block74: {
            block73: {
                block72: {
                    block71: {
                        block70: {
                            block69: {
                                block68: {
                                    block67: {
                                        block66: {
                                            block65: {
                                                block64: {
                                                    block63: {
                                                        block62: {
                                                            block61: {
                                                                block60: {
                                                                    if (this.token == Token.EOF) {
                                                                        return;
                                                                    }
                                                                    try {
                                                                        this.prevEndPos = this.endPos;
                                                                        this.sp = 0;
                                                                        block22: while (true) {
                                                                            this.pos = this.bp;
                                                                            switch (this.ch) {
                                                                                case '\t': 
                                                                                case '\f': 
                                                                                case ' ': {
                                                                                    do {
                                                                                        this.scanChar();
                                                                                    } while (this.ch == ' ' || this.ch == '\t' || this.ch == '\f');
                                                                                    this.endPos = this.bp;
                                                                                    this.processWhiteSpace();
                                                                                    continue block22;
                                                                                }
                                                                                case '\n': {
                                                                                    this.scanChar();
                                                                                    this.endPos = this.bp;
                                                                                    this.processLineTerminator();
                                                                                    continue block22;
                                                                                }
                                                                                case '\r': {
                                                                                    this.scanChar();
                                                                                    if (this.ch == '\n') {
                                                                                        this.scanChar();
                                                                                    }
                                                                                    this.endPos = this.bp;
                                                                                    this.processLineTerminator();
                                                                                    continue block22;
                                                                                }
                                                                                case '$': 
                                                                                case 'A': 
                                                                                case 'B': 
                                                                                case 'C': 
                                                                                case 'D': 
                                                                                case 'E': 
                                                                                case 'F': 
                                                                                case 'G': 
                                                                                case 'H': 
                                                                                case 'I': 
                                                                                case 'J': 
                                                                                case 'K': 
                                                                                case 'L': 
                                                                                case 'M': 
                                                                                case 'N': 
                                                                                case 'O': 
                                                                                case 'P': 
                                                                                case 'Q': 
                                                                                case 'R': 
                                                                                case 'S': 
                                                                                case 'T': 
                                                                                case 'U': 
                                                                                case 'V': 
                                                                                case 'W': 
                                                                                case 'X': 
                                                                                case 'Y': 
                                                                                case 'Z': 
                                                                                case '_': 
                                                                                case 'a': 
                                                                                case 'b': 
                                                                                case 'c': 
                                                                                case 'd': 
                                                                                case 'e': 
                                                                                case 'f': 
                                                                                case 'g': 
                                                                                case 'h': 
                                                                                case 'i': 
                                                                                case 'j': 
                                                                                case 'k': 
                                                                                case 'l': 
                                                                                case 'm': 
                                                                                case 'n': 
                                                                                case 'o': 
                                                                                case 'p': 
                                                                                case 'q': 
                                                                                case 'r': 
                                                                                case 's': 
                                                                                case 't': 
                                                                                case 'u': 
                                                                                case 'v': 
                                                                                case 'w': 
                                                                                case 'x': 
                                                                                case 'y': 
                                                                                case 'z': {
                                                                                    this.scanIdent();
                                                                                    Object var4_3 = null;
                                                                                    this.endPos = this.bp;
                                                                                    if (!scannerDebug) return;
                                                                                    System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                                                    return;
                                                                                }
                                                                                case '0': {
                                                                                    this.scanChar();
                                                                                    if (this.ch == 'x' || this.ch == 'X') {
                                                                                        this.scanChar();
                                                                                        if (this.ch == '.') {
                                                                                            this.scanHexFractionAndSuffix(false);
                                                                                            break block60;
                                                                                        }
                                                                                        if (this.digit(16) < 0) {
                                                                                            this.lexError("invalid.hex.number", new Object[0]);
                                                                                            break block60;
                                                                                        } else {
                                                                                            this.scanNumber(16);
                                                                                        }
                                                                                        break block60;
                                                                                    }
                                                                                    this.putChar('0');
                                                                                    this.scanNumber(8);
                                                                                    break block60;
                                                                                }
                                                                                case '1': 
                                                                                case '2': 
                                                                                case '3': 
                                                                                case '4': 
                                                                                case '5': 
                                                                                case '6': 
                                                                                case '7': 
                                                                                case '8': 
                                                                                case '9': {
                                                                                    this.scanNumber(10);
                                                                                    break block61;
                                                                                }
                                                                                case '.': {
                                                                                    this.scanChar();
                                                                                    if ('0' <= this.ch && this.ch <= '9') {
                                                                                        this.putChar('.');
                                                                                        this.scanFractionAndSuffix();
                                                                                        break block62;
                                                                                    }
                                                                                    if (this.ch == '.') {
                                                                                        this.putChar('.');
                                                                                        this.putChar('.');
                                                                                        this.scanChar();
                                                                                        if (this.ch == '.') {
                                                                                            this.scanChar();
                                                                                            this.putChar('.');
                                                                                            this.token = Token.ELLIPSIS;
                                                                                            break block62;
                                                                                        } else {
                                                                                            this.lexError("malformed.fp.lit", new Object[0]);
                                                                                        }
                                                                                        break block62;
                                                                                    }
                                                                                    this.token = Token.DOT;
                                                                                    break block62;
                                                                                }
                                                                                case ',': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.COMMA;
                                                                                    break block63;
                                                                                }
                                                                                case ';': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.SEMI;
                                                                                    break block64;
                                                                                }
                                                                                case '(': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.LPAREN;
                                                                                    break block65;
                                                                                }
                                                                                case ')': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.RPAREN;
                                                                                    break block66;
                                                                                }
                                                                                case '[': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.LBRACKET;
                                                                                    break block67;
                                                                                }
                                                                                case ']': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.RBRACKET;
                                                                                    break block68;
                                                                                }
                                                                                case '{': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.LBRACE;
                                                                                    break block69;
                                                                                }
                                                                                case '}': {
                                                                                    this.scanChar();
                                                                                    this.token = Token.RBRACE;
                                                                                    break block70;
                                                                                }
                                                                                case '/': {
                                                                                    this.scanChar();
                                                                                    if (this.ch == '/') {
                                                                                        do {
                                                                                            this.scanCommentChar();
                                                                                        } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                                                                                        if (this.bp >= this.buflen) continue block22;
                                                                                        this.endPos = this.bp;
                                                                                        this.processComment(CommentStyle.LINE);
                                                                                        continue block22;
                                                                                    }
                                                                                    if (this.ch == '*') {
                                                                                        CommentStyle style;
                                                                                        this.scanChar();
                                                                                        if (this.ch == '*') {
                                                                                            style = CommentStyle.JAVADOC;
                                                                                            this.scanDocComment();
                                                                                        } else {
                                                                                            style = CommentStyle.BLOCK;
                                                                                            while (this.bp < this.buflen) {
                                                                                                if (this.ch == '*') {
                                                                                                    this.scanChar();
                                                                                                    if (this.ch != '/') continue;
                                                                                                    break;
                                                                                                }
                                                                                                this.scanCommentChar();
                                                                                            }
                                                                                        }
                                                                                        if (this.ch == '/') {
                                                                                            this.scanChar();
                                                                                            this.endPos = this.bp;
                                                                                            this.processComment(style);
                                                                                            continue block22;
                                                                                        }
                                                                                        this.lexError("unclosed.comment", new Object[0]);
                                                                                        Object var4_15 = null;
                                                                                        this.endPos = this.bp;
                                                                                        if (!scannerDebug) return;
                                                                                        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                                                        return;
                                                                                    }
                                                                                    if (this.ch == '=') {
                                                                                        this.name = this.names.slashequals;
                                                                                        this.token = Token.SLASHEQ;
                                                                                        this.scanChar();
                                                                                        break block71;
                                                                                    } else {
                                                                                        this.name = this.names.slash;
                                                                                        this.token = Token.SLASH;
                                                                                    }
                                                                                    break block71;
                                                                                }
                                                                                case '\'': {
                                                                                    this.scanChar();
                                                                                    if (this.ch == '\'') {
                                                                                        this.lexError("empty.char.lit", new Object[0]);
                                                                                        break block72;
                                                                                    }
                                                                                    if (this.ch == '\r' || this.ch == '\n') {
                                                                                        this.lexError(this.pos, "illegal.line.end.in.char.lit", new Object[0]);
                                                                                    }
                                                                                    this.scanLitChar();
                                                                                    if (this.ch == '\'') {
                                                                                        this.scanChar();
                                                                                        this.token = Token.CHARLITERAL;
                                                                                        break block72;
                                                                                    } else {
                                                                                        this.lexError(this.pos, "unclosed.char.lit", new Object[0]);
                                                                                    }
                                                                                    break block72;
                                                                                }
                                                                                case '\"': {
                                                                                    this.scanChar();
                                                                                    while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                                                                                        this.scanLitChar();
                                                                                    }
                                                                                    if (this.ch == '\"') {
                                                                                        this.token = Token.STRINGLITERAL;
                                                                                        this.scanChar();
                                                                                        break block73;
                                                                                    } else {
                                                                                        this.lexError(this.pos, "unclosed.str.lit", new Object[0]);
                                                                                    }
                                                                                    break block73;
                                                                                }
                                                                                default: {
                                                                                    boolean isJavaIdentifierStart;
                                                                                    if (this.isSpecial(this.ch)) {
                                                                                        this.scanOperator();
                                                                                        break block22;
                                                                                    }
                                                                                    if (this.ch < '\u0080') {
                                                                                        isJavaIdentifierStart = false;
                                                                                    } else {
                                                                                        char high = this.scanSurrogates();
                                                                                        if (high != '\u0000') {
                                                                                            if (this.sp == this.sbuf.length) {
                                                                                                this.putChar(high);
                                                                                            } else {
                                                                                                this.sbuf[this.sp++] = high;
                                                                                            }
                                                                                            isJavaIdentifierStart = Character.isJavaIdentifierStart(Character.toCodePoint(high, this.ch));
                                                                                        } else {
                                                                                            isJavaIdentifierStart = Character.isJavaIdentifierStart(this.ch);
                                                                                        }
                                                                                    }
                                                                                    if (isJavaIdentifierStart) {
                                                                                        this.scanIdent();
                                                                                        break block22;
                                                                                    }
                                                                                    if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                                                                                        this.token = Token.EOF;
                                                                                        this.pos = this.bp = this.eofPos;
                                                                                        break block22;
                                                                                    }
                                                                                    this.lexError("illegal.char", String.valueOf((int)this.ch));
                                                                                    this.scanChar();
                                                                                    break block22;
                                                                                }
                                                                            }
                                                                            break;
                                                                        }
                                                                        break block74;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var4_20 = null;
                                                                        this.endPos = this.bp;
                                                                        if (!scannerDebug) throw throwable;
                                                                        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                Object var4_4 = null;
                                                                this.endPos = this.bp;
                                                                if (!scannerDebug) return;
                                                                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                                return;
                                                            }
                                                            Object var4_5 = null;
                                                            this.endPos = this.bp;
                                                            if (!scannerDebug) return;
                                                            System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                            return;
                                                        }
                                                        Object var4_6 = null;
                                                        this.endPos = this.bp;
                                                        if (!scannerDebug) return;
                                                        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                        return;
                                                    }
                                                    Object var4_7 = null;
                                                    this.endPos = this.bp;
                                                    if (!scannerDebug) return;
                                                    System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                    return;
                                                }
                                                Object var4_8 = null;
                                                this.endPos = this.bp;
                                                if (!scannerDebug) return;
                                                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                                return;
                                            }
                                            Object var4_9 = null;
                                            this.endPos = this.bp;
                                            if (!scannerDebug) return;
                                            System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                            return;
                                        }
                                        Object var4_10 = null;
                                        this.endPos = this.bp;
                                        if (!scannerDebug) return;
                                        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                        return;
                                    }
                                    Object var4_11 = null;
                                    this.endPos = this.bp;
                                    if (!scannerDebug) return;
                                    System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                    return;
                                }
                                Object var4_12 = null;
                                this.endPos = this.bp;
                                if (!scannerDebug) return;
                                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                                return;
                            }
                            Object var4_13 = null;
                            this.endPos = this.bp;
                            if (!scannerDebug) return;
                            System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                            return;
                        }
                        Object var4_14 = null;
                        this.endPos = this.bp;
                        if (!scannerDebug) return;
                        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                        return;
                    }
                    Object var4_16 = null;
                    this.endPos = this.bp;
                    if (!scannerDebug) return;
                    System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                    return;
                }
                Object var4_17 = null;
                this.endPos = this.bp;
                if (!scannerDebug) return;
                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
                return;
            }
            Object var4_18 = null;
            this.endPos = this.bp;
            if (!scannerDebug) return;
            System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
            return;
        }
        Object var4_19 = null;
        this.endPos = this.bp;
        if (!scannerDebug) return;
        System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
    }

    public Token token() {
        return this.token;
    }

    public void token(Token token) {
        this.token = token;
    }

    public int pos() {
        return this.seek + this.pos;
    }

    public int endPos() {
        return this.seek + this.endPos;
    }

    public int prevEndPos() {
        return this.seek + this.prevEndPos;
    }

    public int errPos() {
        return this.seek + this.errPos;
    }

    public void errPos(int pos) {
        this.errPos = pos - this.seek;
    }

    public Name name() {
        return this.name;
    }

    public int radix() {
        return this.radix;
    }

    public boolean deprecatedFlag() {
        return this.deprecatedFlag;
    }

    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    public String docComment() {
        return null;
    }

    public char[] getRawCharacters() {
        char[] chars = new char[this.buflen];
        System.arraycopy(this.buf, 0, chars, 0, this.buflen);
        return chars;
    }

    protected char[] getVeryRawCharacters() {
        if (this.buf.length == this.buflen) {
            char[] chars = new char[this.buflen];
            System.arraycopy(this.buf, 0, chars, 0, this.buflen);
            return chars;
        }
        char[] chars = new char[this.buflen + 1];
        System.arraycopy(this.buf, 0, chars, 0, this.buflen);
        chars[this.buflen] = this.replacedCharacter;
        return chars;
    }

    public char[] getRawCharacters(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        char[] chars = new char[length];
        System.arraycopy(this.buf, beginIndex - this.seek, chars, 0, length);
        return chars;
    }

    protected void processComment(CommentStyle style) {
        if (scannerDebug) {
            System.out.println("processComment(" + this.pos + "," + this.endPos + "," + (Object)((Object)style) + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processWhiteSpace() {
        if (scannerDebug) {
            System.out.println("processWhitespace(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processLineTerminator() {
        if (scannerDebug) {
            System.out.println("processTerminator(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.buf, this.buflen, this.replacedCharacter, false);
    }

    public void seek(int seek) {
        assert (seek >= 0);
        this.seek = seek;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommentStyle {
        LINE,
        BLOCK,
        JAVADOC;

    }

    public static class Factory {
        public static final Context.Key<Factory> scannerFactoryKey = new Context.Key();
        final Log log;
        final Names names;
        final Source source;
        final Keywords keywords;

        public static Factory instance(Context context) {
            Factory instance = context.get(scannerFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(scannerFactoryKey, this);
            this.log = Log.instance(context);
            this.names = Names.instance(context);
            this.source = Source.instance(context);
            this.keywords = Keywords.instance(context);
        }

        public Scanner newScanner(CharSequence input) {
            if (input instanceof CharBuffer) {
                return new Scanner(this, (CharBuffer)input);
            }
            char[] array = ((Object)input).toString().toCharArray();
            return this.newScanner(array, array.length);
        }

        public Scanner newScanner(char[] input, int inputLength) {
            return new Scanner(this, input, inputLength);
        }
    }
}

