/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.editor.model.CssModel;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewable;
import org.netbeans.modules.editor.NbEditorDocument;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CssEditorSupport {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CssRuleContent selected = null;
    private Document document = null;
    private List<CssPreviewable.Listener> previewableListeners = new ArrayList<CssPreviewable.Listener>();
    private static final Logger LOGGER = Logger.getLogger("css.visual");
    private static final CssEditorSupport INSTANCE = new CssEditorSupport();
    private static final boolean DEBUG = Boolean.getBoolean("issue_129209_debug");
    private PropertyChangeListener CSS_STYLE_DATA_LISTENER = new PropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            NbEditorDocument nbEditorDocument;
            if (CssEditorSupport.this.selected != null && !CssEditorSupport.this.aggregated_events) {
                CssEditorSupport.this.d("css style data listener - detachinf from rule content.");
                CssEditorSupport.this.selected.removePropertyChangeListener(CssEditorSupport.this.CSS_STYLE_DATA_LISTENER);
            }
            if ((nbEditorDocument = (NbEditorDocument)CssEditorSupport.this.document) != null) {
                nbEditorDocument.runAtomic(new Runnable(){

                    public void run() {
                        block10: {
                            CssRuleItem cssRuleItem = (CssRuleItem)propertyChangeEvent.getOldValue();
                            CssRuleItem cssRuleItem2 = (CssRuleItem)propertyChangeEvent.getNewValue();
                            if (CssEditorSupport.this.selected == null) {
                                throw new IllegalStateException("CssRuleContent event fired, but selected rule is null!");
                            }
                            CssRule cssRule = CssEditorSupport.this.selected.rule();
                            try {
                                if (cssRuleItem != null && cssRuleItem2 == null) {
                                    int n = cssRuleItem.key().offset();
                                    int n2 = cssRuleItem.value().offset() + cssRuleItem.value().name().length();
                                    n2 = cssRuleItem.semicolonOffset() != -1 ? cssRuleItem.semicolonOffset() + 1 : n2;
                                    nbEditorDocument.remove(n, n2 - n);
                                    if (Utilities.isRowWhite((BaseDocument)nbEditorDocument, (int)n)) {
                                        int n3 = Utilities.getRowStart((BaseDocument)nbEditorDocument, (int)n);
                                        int n4 = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)n);
                                        int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)nbEditorDocument, (int)(n4 + 1));
                                        nbEditorDocument.remove(n3, n5 - n3);
                                    }
                                    break block10;
                                }
                                if (cssRuleItem == null && cssRuleItem2 != null) {
                                    Object object;
                                    List list = cssRule.items();
                                    int n = nbEditorDocument.getFormatter().getShiftWidth();
                                    int n6 = cssRule.getRuleCloseBracketOffset();
                                    boolean bl = false;
                                    if (!list.isEmpty()) {
                                        object = (CssRuleItem)list.get(list.size() - 1);
                                        if (object.semicolonOffset() == -1) {
                                            nbEditorDocument.insertString(object.value().offset() + object.value().name().trim().length(), ";", null);
                                            ++n6;
                                        }
                                        bl = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)object.key().offset());
                                    } else {
                                        bl = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleOpenBracketOffset());
                                    }
                                    object = (bl ? LINE_SEPARATOR : "") + CssEditorSupport.this.makeIndentString(n) + cssRuleItem2.key().name() + ": " + cssRuleItem2.value().name() + ";" + LINE_SEPARATOR;
                                    nbEditorDocument.insertString(n6, (String)object, null);
                                    break block10;
                                }
                                if (cssRuleItem != null && cssRuleItem2 != null) {
                                    nbEditorDocument.remove(cssRuleItem.key().offset(), cssRuleItem.key().name().length());
                                    nbEditorDocument.insertString(cssRuleItem.key().offset(), cssRuleItem2.key().name(), null);
                                    int n = cssRuleItem2.key().name().length() - cssRuleItem.key().name().length();
                                    nbEditorDocument.remove(cssRuleItem.value().offset() + n, cssRuleItem.value().name().length());
                                    nbEditorDocument.insertString(cssRuleItem.value().offset() + n, cssRuleItem2.value().name(), null);
                                    break block10;
                                }
                                throw new IllegalArgumentException("Invalid PropertyChangeEvent - both old and new values are null!");
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    };
    private boolean aggregated_events = false;

    public static synchronized CssEditorSupport getDefault() {
        return INSTANCE;
    }

    private String makeIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    void parsed(final CssParserResult cssParserResult, final int n) {
        this.d("model updated");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CssEditorSupport.this.d("model updated from AWT");
                CssEditorSupport.this.updateSelectedRule(cssParserResult, n);
            }
        });
    }

    void parsedWithError(CssParserResult cssParserResult) {
        this.d("model invalid");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CssEditorSupport.this.selected != null) {
                    CssEditorSupport.this.selected.removePropertyChangeListener(CssEditorSupport.this.CSS_STYLE_DATA_LISTENER);
                    CssEditorSupport.this.d("removed css style data listener from " + CssEditorSupport.this.selected);
                    CssEditorSupport.this.selected = null;
                }
                StyleBuilderTopComponent.findInstance().setPanelMode(3);
                CssEditorSupport.this.firePreviewableDeactivated();
            }
        });
    }

    private synchronized void updateSelectedRule(CssParserResult cssParserResult, int n) {
        LOGGER.log(Level.FINE, "updateSelectedRule(" + n + ")");
        CssModel cssModel = CssModel.create((CssParserResult)cssParserResult);
        CssRule cssRule = cssModel.ruleForOffset(n);
        LOGGER.log(Level.FINE, cssRule == null ? "NO rule" : "found a rule");
        this.d("selected rule:" + cssRule);
        if (cssRule == null) {
            if (this.selected != null) {
                this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("no selected rule, removing css style data listener");
                this.selected = null;
            }
            StyleBuilderTopComponent.findInstance().setPanelMode(4);
            this.firePreviewableDeactivated();
        } else {
            if (this.selected != null) {
                if (cssRule.equals(this.selected.rule())) {
                    this.d("already selected rule selected, exiting");
                    return;
                }
                this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("removed css style data listener from previous rule: " + this.selected);
            }
            this.selected = CssRuleContent.create(cssRule);
            this.document = cssParserResult.getSnapshot().getSource().getDocument(false);
            CssRuleContext cssRuleContext = new CssRuleContext(this.selected, cssModel, this.document, FileUtil.toFile((FileObject)cssParserResult.getSnapshot().getSource().getFileObject()));
            StyleBuilderTopComponent styleBuilderTopComponent = StyleBuilderTopComponent.findInstance();
            styleBuilderTopComponent.setContent(cssRuleContext);
            styleBuilderTopComponent.setPanelMode(2);
            this.d("stylebuilder UI updated");
            this.selected.addPropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
            this.d("added property change listener to the new rule: " + this.selected);
            this.firePreviewableActivated(cssRuleContext);
        }
        this.d("updateselected rule exit");
    }

    public void addListener(CssPreviewable.Listener listener) {
        this.previewableListeners.add(listener);
    }

    public void removeListener(CssPreviewable.Listener listener) {
        this.previewableListeners.remove(listener);
    }

    private void firePreviewableActivated(CssRuleContext cssRuleContext) {
        CssPreviewTopComponent.findInstance().activate(cssRuleContext);
    }

    private void firePreviewableDeactivated() {
        CssPreviewTopComponent.findInstance().deactivate();
    }

    private void d(String string) {
        if (DEBUG) {
            LOGGER.log(Level.INFO, string);
        }
    }

    public void firstAggregatedEventWillFire() {
        this.aggregated_events = true;
        this.d("firstAggregatedEventWillFire");
    }

    public void lastAggregatedEventFired() {
        this.aggregated_events = false;
        if (this.selected != null) {
            this.d("lastAggregatedEventFired: css style data listener - detaching from rule content.");
            this.selected.removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
        }
    }
}

