/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.BorderModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class BorderWidthField
extends JPanel {
    PropertyWithUnitData borderWidthData = new PropertyWithUnitData();
    BorderModel borderModel = new BorderModel();
    private JComboBox borderWidthCombo;
    private JComboBox borderWidthUnitCombo;

    public BorderWidthField() {
        this.initComponents();
        this.borderWidthCombo.setModel(this.borderModel.getWidthList());
        this.borderWidthUnitCombo.setModel(this.borderModel.getWidthUnitList());
        final JTextField jTextField = (JTextField)this.borderWidthCombo.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BorderWidthField.this.borderWidthUnitCombo.setEnabled(Utils.isInteger(jTextField.getText()));
                    }
                });
            }
        });
    }

    public void setWidthString(String string) {
        if (string != null && !string.equals("")) {
            if (Utils.isInteger(string)) {
                this.setWidthValue(string);
            } else {
                String string2 = this.getUnit(string);
                this.setWidthUnit(string2);
                this.setWidthValue(string.replaceAll(string2, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getWidthString() {
        return this.borderWidthData.toString();
    }

    private String getUnit(String string) {
        DefaultComboBoxModel defaultComboBoxModel = this.borderModel.getWidthUnitList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string.trim().endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public void setWidthValue(String string) {
        if (string == null || string.equals("")) {
            this.borderWidthCombo.setSelectedIndex(0);
        } else {
            this.borderWidthCombo.setSelectedItem(string);
            this.borderWidthData.setValue(string);
        }
    }

    public void setWidthUnit(String string) {
        if (string == null || string.equals("")) {
            this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
        } else {
            if (this.borderModel.getWidthUnitList().getIndexOf(string) != -1) {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf(string));
            } else {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
            }
            this.borderWidthData.setUnit(string);
        }
    }

    private void initComponents() {
        this.borderWidthCombo = new JComboBox();
        this.borderWidthUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderWidthCombo.setEditable(true);
        this.borderWidthCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BorderWidthField.this.borderWidthComboItemStateChanged(itemEvent);
            }
        });
        this.borderWidthCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BorderWidthField.this.borderWidthComboActionPerformed(actionEvent);
            }
        });
        this.borderWidthCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BorderWidthField.this.borderWidthComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderWidthCombo, "Center");
        this.borderWidthCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_FIELD_ACCESS_NAME"));
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_FIELD_ACCESS_DESC"));
        this.borderWidthUnitCombo.setEnabled(false);
        this.borderWidthUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BorderWidthField.this.borderWidthUnitComboItemStateChanged(itemEvent);
            }
        });
        this.borderWidthUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BorderWidthField.this.borderWidthUnitComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderWidthUnitCombo, "East");
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderWidthUnitComboFocusLost(FocusEvent focusEvent) {
        this.setBorderWidth();
    }

    private void borderWidthUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBorderWidth();
        }
    }

    public void setAccessibleName(String string, String string2) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleName(string);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleName(string2);
    }

    public void setAccessibleDescription(String string, String string2) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription(string);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleDescription(string2);
    }

    private void borderWidthComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBorderWidth();
            this.borderWidthUnitCombo.setEnabled(Utils.isInteger(this.borderWidthCombo.getSelectedItem().toString()));
        }
    }

    private void borderWidthComboFocusLost(FocusEvent focusEvent) {
        this.setBorderWidth();
    }

    private void borderWidthComboActionPerformed(ActionEvent actionEvent) {
        this.setBorderWidth();
    }

    private void setBorderWidth() {
        String string = this.borderWidthData.toString();
        this.borderWidthData.setUnit(this.borderWidthUnitCombo.getSelectedItem().toString());
        this.borderWidthData.setValue(this.borderWidthCombo.getSelectedItem().toString());
        this.firePropertyChange("border-width", string, this.borderWidthData.toString());
    }
}

