/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.FontModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.TextDecorationData;
import org.netbeans.modules.css.visual.model.Utils;
import org.netbeans.modules.css.visual.ui.ColorSelectionField;
import org.netbeans.modules.css.visual.ui.FontFamilyEditorDialog;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class FontStyleEditor
extends StyleEditor {
    ColorSelectionField colorField = new ColorSelectionField();
    TextDecorationData textDecorationData = new TextDecorationData();
    FontModel fontModel = new FontModel();
    DefaultListModel fontFamilies = this.fontModel.getFontFamilySetList();
    DefaultListModel fontSizes;
    DefaultComboBoxModel fontSizeUnits;
    DefaultComboBoxModel fontStyles;
    DefaultComboBoxModel fontWeights;
    DefaultComboBoxModel fontVariants;
    String temporaryFontSet = null;
    private String currentFontFamily = null;
    private String currentFontSize = null;
    private String currentFontStyle = null;
    private String currentFontWeight = null;
    private String currentFontVariant = null;
    private String currentFontColor = null;
    private String currentFontDecoration = null;
    private JLabel colorLabel;
    private JPanel colorSelectionPanel;
    private JPanel decorationPanel;
    private JTextField fontChosenField;
    private JList fontFaceList;
    private JScrollPane fontFaceScroll;
    private JButton fontFamilyButton;
    private JPanel fontFamilyPanel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JPanel fontSizePanel;
    private JScrollPane fontSizeScroll;
    private JComboBox fontSizeUnitCombo;
    private JComboBox fontStyleComboBox;
    private JComboBox fontVariantComboBox;
    private JComboBox fontWeightComboBox;
    private JPanel mainPanel;
    private JCheckBox noDecorationCheckbox;
    private JCheckBox overlineCheckbox;
    private JCheckBox strikethroughCheckbox;
    private JLabel styleLabel;
    private JPanel styleMainPanel;
    private JCheckBox underlineCheckbox;
    private JLabel variantLabel;
    private JLabel weightLabel;

    public FontStyleEditor() {
        this.setName("fontStyleEditor");
        this.setDisplayName(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FontStyleEditor.this.setFontColor();
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.fontModel = new FontModel();
        this.fontFamilies = this.fontModel.getFontFamilySetList();
        this.fontFaceList.setModel(this.fontFamilies);
        this.fontSizes = this.fontModel.getFontSizeList();
        this.fontSizeList.setModel(this.fontSizes);
        this.fontSizeUnits = this.fontModel.getFontSizeUnitList();
        this.fontSizeUnitCombo.setModel(this.fontSizeUnits);
        this.fontSizeUnitCombo.setSelectedItem("px");
        this.fontStyles = this.fontModel.getFontStyleList();
        this.fontStyleComboBox.setModel(this.fontStyles);
        this.fontWeights = this.fontModel.getFontWeightList();
        this.fontWeightComboBox.setModel(this.fontWeights);
        this.fontVariants = this.fontModel.getFontVariantList();
        this.fontVariantComboBox.setModel(this.fontVariants);
        FontMetrics fontMetrics = this.fontSizeField.getFontMetrics(this.fontSizeField.getFont());
        int n = fontMetrics.stringWidth((String)this.fontSizes.get(0)) + 10;
        int n2 = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
        this.fontSizeField.setPreferredSize(new Dimension(n, n2));
    }

    protected void setCssPropertyValues(CssRuleContent cssRuleContent) {
        boolean bl;
        String string;
        Object object;
        CharSequence charSequence;
        this.removeCssPropertyChangeListener();
        String string2 = cssRuleContent.getProperty("font-family");
        if (string2 != null) {
            charSequence = new StringBuffer();
            object = new StringTokenizer(string2.trim(), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                if (new StringTokenizer(string.trim()).countTokens() == 1) {
                    string = string.replaceAll("'", "");
                }
                ((StringBuffer)charSequence).append(string);
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                ((StringBuffer)charSequence).append(",");
            }
            if (!this.fontFamilies.contains(((StringBuffer)charSequence).toString())) {
                if (this.temporaryFontSet != null) {
                    this.fontFamilies.removeElement(this.temporaryFontSet);
                }
                this.fontFamilies.add(1, ((StringBuffer)charSequence).toString());
                this.temporaryFontSet = ((StringBuffer)charSequence).toString();
            }
            this.fontFaceList.setSelectedIndex(this.fontFamilies.indexOf(((StringBuffer)charSequence).toString()));
        } else {
            this.fontFaceList.setSelectedIndex(0);
        }
        charSequence = cssRuleContent.getProperty("font-size");
        if (charSequence != null) {
            if (this.fontSizes.contains(charSequence)) {
                this.fontSizeList.setSelectedIndex(this.fontSizes.indexOf(charSequence));
            } else {
                object = this.fontModel.getFontSize((String)charSequence);
                if (((FontModel.FontSize)object).getValue() != null) {
                    if (this.fontSizes.contains(((FontModel.FontSize)object).getValue())) {
                        this.fontSizeList.setSelectedIndex(this.fontSizes.indexOf(((FontModel.FontSize)object).getValue()));
                    } else {
                        this.fontSizeField.setText(((FontModel.FontSize)object).getValue());
                    }
                } else {
                    this.fontSizeList.setSelectedIndex(0);
                }
                if (this.fontSizeUnits.getIndexOf(((FontModel.FontSize)object).getUnit()) != -1) {
                    this.fontSizeUnitCombo.setSelectedIndex(this.fontSizeUnits.getIndexOf(((FontModel.FontSize)object).getUnit()));
                }
            }
        } else {
            this.fontSizeList.setSelectedIndex(0);
        }
        object = cssRuleContent.getProperty("font-style");
        if (object != null) {
            if (this.fontStyles.getIndexOf(object) != -1) {
                this.fontStyleComboBox.setSelectedIndex(this.fontStyles.getIndexOf(object));
            } else {
                this.fontStyleComboBox.setSelectedIndex(0);
            }
        } else {
            this.fontStyleComboBox.setSelectedIndex(0);
        }
        string = cssRuleContent.getProperty("font-weight");
        if (string != null) {
            if (this.fontWeights.getIndexOf(string) != -1) {
                this.fontWeightComboBox.setSelectedIndex(this.fontWeights.getIndexOf(string));
            } else {
                this.fontWeightComboBox.setSelectedIndex(0);
            }
        } else {
            this.fontWeightComboBox.setSelectedIndex(0);
        }
        String string3 = cssRuleContent.getProperty("font-variant");
        if (string3 != null) {
            if (this.fontVariants.getIndexOf(string3) != -1) {
                this.fontVariantComboBox.setSelectedIndex(this.fontVariants.getIndexOf(string3));
            } else {
                this.fontVariantComboBox.setSelectedIndex(0);
            }
        } else {
            this.fontVariantComboBox.setSelectedIndex(0);
        }
        String string4 = cssRuleContent.getProperty("text-decoration");
        boolean bl2 = bl = string4 != null;
        if (bl) {
            this.textDecorationData.setDecoration(string4);
            this.currentFontDecoration = this.textDecorationData.toString();
        }
        boolean bl3 = bl && this.textDecorationData.noDecorationEnabled();
        this.noDecorationCheckbox.setSelected(bl3);
        this.underlineCheckbox.setSelected(bl && !bl3 && this.textDecorationData.underlineEnabled());
        this.overlineCheckbox.setSelected(bl && !bl3 && this.textDecorationData.overlineEnabled());
        this.strikethroughCheckbox.setSelected(bl && !bl3 && this.textDecorationData.lineThroughEnabled());
        String string5 = cssRuleContent.getProperty("color");
        if (string5 != null) {
            this.colorField.setColorString(string5);
        } else {
            this.colorField.setColorString(Utils.NOT_SET);
        }
        this.setCssPropertyChangeListener(cssRuleContent);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.fontFamilyPanel = new JPanel();
        this.fontFaceScroll = new JScrollPane();
        this.fontFaceList = new JList();
        this.fontChosenField = new JTextField();
        this.fontFamilyButton = new JButton();
        this.fontSizePanel = new JPanel();
        this.fontSizeField = new JTextField();
        this.fontSizeUnitCombo = new JComboBox();
        this.fontSizeScroll = new JScrollPane();
        this.fontSizeList = new JList();
        this.styleMainPanel = new JPanel();
        this.decorationPanel = new JPanel();
        this.underlineCheckbox = new JCheckBox();
        this.strikethroughCheckbox = new JCheckBox();
        this.overlineCheckbox = new JCheckBox();
        this.noDecorationCheckbox = new JCheckBox();
        this.styleLabel = new JLabel();
        this.fontStyleComboBox = new JComboBox();
        this.weightLabel = new JLabel();
        this.fontWeightComboBox = new JComboBox();
        this.variantLabel = new JLabel();
        this.fontVariantComboBox = new JComboBox();
        this.colorLabel = new JLabel();
        this.colorSelectionPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.fontFamilyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fontFamilyPanel.setLayout(new GridBagLayout());
        this.fontFaceList.setSelectionMode(0);
        this.fontFaceList.setVisibleRowCount(5);
        this.fontFaceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontStyleEditor.this.fontFaceListValueChanged(listSelectionEvent);
            }
        });
        this.fontFaceScroll.setViewportView(this.fontFaceList);
        this.fontFaceList.getAccessibleContext().setAccessibleName(null);
        this.fontFaceList.getAccessibleContext().setAccessibleDescription(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.fontFamilyPanel.add((Component)this.fontFaceScroll, gridBagConstraints);
        this.fontChosenField.setEditable(false);
        this.fontChosenField.setMargin(new Insets(1, 2, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontChosenField, gridBagConstraints);
        this.fontChosenField.getAccessibleContext().setAccessibleName(null);
        this.fontChosenField.getAccessibleContext().setAccessibleDescription(null);
        this.fontFamilyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_EDIT").charAt(0));
        this.fontFamilyButton.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"EDIT"));
        this.fontFamilyButton.setMargin(new Insets(4, 4, 4, 4));
        this.fontFamilyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontFamilyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontFamilyButton, gridBagConstraints);
        this.fontFamilyButton.getAccessibleContext().setAccessibleDescription(null);
        this.mainPanel.add((Component)this.fontFamilyPanel, "Center");
        this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fontSizePanel.setLayout(new GridBagLayout());
        this.fontSizeField.setHorizontalAlignment(2);
        this.fontSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontSizeFieldActionPerformed(actionEvent);
            }
        });
        this.fontSizeField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontSizeFieldFocusLost(focusEvent);
            }
        });
        this.fontSizeField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                FontStyleEditor.this.fontSizeFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeField, gridBagConstraints);
        this.fontSizeField.getAccessibleContext().setAccessibleName(null);
        this.fontSizeField.getAccessibleContext().setAccessibleDescription(null);
        this.fontSizeUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontSizeUnitComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeUnitCombo, gridBagConstraints);
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleName(null);
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleDescription(null);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(5);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontStyleEditor.this.fontSizeListValueChanged(listSelectionEvent);
            }
        });
        this.fontSizeScroll.setViewportView(this.fontSizeList);
        this.fontSizeList.getAccessibleContext().setAccessibleName(null);
        this.fontSizeList.getAccessibleContext().setAccessibleDescription(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.fontSizePanel.add((Component)this.fontSizeScroll, gridBagConstraints);
        this.mainPanel.add((Component)this.fontSizePanel, "East");
        this.styleMainPanel.setLayout(new BorderLayout(20, 0));
        this.decorationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.underlineCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_UNDERLINE").charAt(0));
        this.underlineCheckbox.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_UNDERLINE"));
        this.underlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.underlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.underlineCheckboxItemStateChanged(itemEvent);
            }
        });
        this.strikethroughCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_STRIKETHROUGH").charAt(0));
        this.strikethroughCheckbox.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_STRIKETHROUGH"));
        this.strikethroughCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.strikethroughCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.strikethroughCheckboxItemStateChanged(itemEvent);
            }
        });
        this.overlineCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_OVERLINE").charAt(0));
        this.overlineCheckbox.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_OVERLINE"));
        this.overlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.overlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.overlineCheckboxItemStateChanged(itemEvent);
            }
        });
        this.noDecorationCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_NO_DECORATION_1").charAt(0));
        this.noDecorationCheckbox.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"NO_DECORATION_1"));
        this.noDecorationCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.noDecorationCheckboxItemStateChanged(itemEvent);
            }
        });
        this.styleLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_STYLE").charAt(0));
        this.styleLabel.setLabelFor(this.fontStyleComboBox);
        this.styleLabel.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_STYLE"));
        this.fontStyleComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontStyleComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontStyleComboBoxItemStateChanged(itemEvent);
            }
        });
        this.fontStyleComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontStyleComboBoxFocusLost(focusEvent);
            }
        });
        this.weightLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_WEIGHT").charAt(0));
        this.weightLabel.setLabelFor(this.fontWeightComboBox);
        this.weightLabel.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_WEIGHT"));
        this.fontWeightComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontWeightComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontWeightComboBoxItemStateChanged(itemEvent);
            }
        });
        this.fontWeightComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontWeightComboBoxFocusLost(focusEvent);
            }
        });
        this.variantLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_VARIANT").charAt(0));
        this.variantLabel.setLabelFor(this.fontVariantComboBox);
        this.variantLabel.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_VARIANT"));
        this.fontVariantComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontVariantComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontVariantComboBoxItemStateChanged(itemEvent);
            }
        });
        this.fontVariantComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontVariantComboBoxFocusLost(focusEvent);
            }
        });
        this.colorLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_FONT_COLOR").charAt(0));
        this.colorLabel.setLabelFor(this.colorSelectionPanel);
        this.colorLabel.setText(NbBundle.getMessage(FontStyleEditor.class, (String)"FONT_COLOR"));
        this.colorSelectionPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this.decorationPanel);
        this.decorationPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.styleLabel, -2, 47, -2).add((Component)this.fontStyleComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fontWeightComboBox, -2, -1, -2).add((Component)this.weightLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.variantLabel).add((Component)this.fontVariantComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.colorSelectionPanel, -2, 137, -2).add((Component)this.colorLabel))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.underlineCheckbox).addPreferredGap(0).add((Component)this.overlineCheckbox).addPreferredGap(0).add((Component)this.strikethroughCheckbox).addPreferredGap(0).add((Component)this.noDecorationCheckbox))).addContainerGap(57, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.styleLabel).add((Component)this.weightLabel).add((Component)this.variantLabel).add((Component)this.colorLabel)).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fontWeightComboBox, -2, -1, -2).add((Component)this.fontVariantComboBox, -2, -1, -2).add((Component)this.fontStyleComboBox, -2, -1, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.colorSelectionPanel, -2, 23, -2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.underlineCheckbox).add((Component)this.overlineCheckbox).add((Component)this.noDecorationCheckbox).add((Component)this.strikethroughCheckbox))));
        this.underlineCheckbox.getAccessibleContext().setAccessibleDescription(null);
        this.strikethroughCheckbox.getAccessibleContext().setAccessibleDescription(null);
        this.overlineCheckbox.getAccessibleContext().setAccessibleDescription(null);
        this.noDecorationCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontStyleEditor.class, (String)"FontNoDecorationAccessibleDescription"));
        this.fontStyleComboBox.getAccessibleContext().setAccessibleName(null);
        this.fontStyleComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.fontWeightComboBox.getAccessibleContext().setAccessibleName(null);
        this.fontWeightComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.variantLabel.getAccessibleContext().setAccessibleDescription(null);
        this.fontVariantComboBox.getAccessibleContext().setAccessibleName(null);
        this.fontVariantComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.styleMainPanel.add((Component)this.decorationPanel, "Center");
        this.mainPanel.add((Component)this.styleMainPanel, "South");
        this.add((Component)this.mainPanel, "North");
    }

    private void noDecorationCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.textDecorationData.enableNoDecoration(itemEvent.getStateChange() == 1);
        if (itemEvent.getStateChange() == 1) {
            this.strikethroughCheckbox.setSelected(false);
            this.overlineCheckbox.setSelected(false);
            this.underlineCheckbox.setSelected(false);
            this.strikethroughCheckbox.setEnabled(false);
            this.overlineCheckbox.setEnabled(false);
            this.underlineCheckbox.setEnabled(false);
        } else {
            this.strikethroughCheckbox.setEnabled(true);
            this.overlineCheckbox.setEnabled(true);
            this.underlineCheckbox.setEnabled(true);
        }
        this.setTextDecoration();
    }

    private void strikethroughCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (this.textDecorationData.enableLineThrough(itemEvent.getStateChange() == 1)) {
            this.setTextDecoration();
        }
    }

    private void overlineCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (this.textDecorationData.enableOverline(itemEvent.getStateChange() == 1)) {
            this.setTextDecoration();
        }
    }

    private void underlineCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (this.textDecorationData.enableUnderline(itemEvent.getStateChange() == 1)) {
            this.setTextDecoration();
        }
    }

    private void fontVariantComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontVariant();
        }
    }

    private void fontVariantComboBoxFocusLost(FocusEvent focusEvent) {
        this.setFontVariant();
    }

    private void fontWeightComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontWeight();
        }
    }

    private void fontWeightComboBoxFocusLost(FocusEvent focusEvent) {
        this.setFontWeight();
    }

    private void fontStyleComboBoxFocusLost(FocusEvent focusEvent) {
        this.setFontStyle();
    }

    private void fontStyleComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontStyle();
        }
    }

    private void fontSizeUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontSize();
        }
    }

    private void fontSizeFieldActionPerformed(ActionEvent actionEvent) {
        this.setFontSize();
    }

    private void fontSizeFieldFocusLost(FocusEvent focusEvent) {
        this.setFontSize();
    }

    private void fontSizeFieldKeyTyped(KeyEvent keyEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.enableFontSizeUnitCombo(Utils.isFloat(FontStyleEditor.this.fontSizeField.getText()));
            }
        });
    }

    private void fontSizeListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        String string = (String)this.fontSizeList.getSelectedValue();
        this.fontSizeField.setText(string);
        this.enableFontSizeUnitCombo(Utils.isFloat(string));
        this.setFontSize();
    }

    private void enableFontSizeUnitCombo(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.fontSizeUnitCombo.setEnabled(bl);
            }
        });
    }

    private void fontFaceListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.fontFaceList.getSelectedValue() != null) {
            this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
            this.setFontFamily();
        }
    }

    private void fontFamilyButtonActionPerformed(ActionEvent actionEvent) {
        FontFamilyEditorDialog fontFamilyEditorDialog = new FontFamilyEditorDialog(this.fontFamilies, this.fontFaceList.getSelectedIndex());
        fontFamilyEditorDialog.showDialog();
        this.fontFaceList.setSelectedIndex(fontFamilyEditorDialog.getSelectedIndex());
        this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
        this.setFontFamily();
    }

    private void setFontFamily() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontChosenField.getText());
        String string = propertyData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("font-family", this.currentFontFamily, string);
        this.currentFontFamily = string;
    }

    private void setFontSize() {
        PropertyWithUnitData propertyWithUnitData = new PropertyWithUnitData();
        propertyWithUnitData.setUnit(this.fontSizeUnitCombo.getSelectedItem().toString());
        propertyWithUnitData.setValue(this.fontSizeField.getText());
        String string = propertyWithUnitData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("font-size", this.currentFontSize, string);
        this.currentFontSize = string;
    }

    private void setFontStyle() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontStyleComboBox.getSelectedItem().toString());
        String string = propertyData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("font-style", this.currentFontStyle, string);
        this.currentFontStyle = string;
    }

    private void setFontWeight() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontWeightComboBox.getSelectedItem().toString());
        String string = propertyData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("font-weight", this.currentFontWeight, string);
        this.currentFontWeight = string;
    }

    private void setFontVariant() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontVariantComboBox.getSelectedItem().toString());
        String string = propertyData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("font-variant", this.currentFontVariant, string);
        this.currentFontVariant = string;
    }

    private void setFontColor() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.colorField.getColorString());
        String string = propertyData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("color", this.currentFontColor, string);
        this.currentFontColor = string;
    }

    private void setTextDecoration() {
        String string = this.textDecorationData.toString();
        this.cssPropertyChangeSupport().firePropertyChange("text-decoration", this.currentFontDecoration, string);
        this.currentFontDecoration = string;
    }
}

