/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransformUtil {
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String DEFAULT_OUTPUT_EXT = "html";
    private static TransformerFactory transformerFactory;
    private static SAXParserFactory saxParserFactory;

    public static boolean isXSLTransformation(DataObject dataObject) {
        return dataObject.getPrimaryFile().getMIMEType().equals("application/xslt+xml");
    }

    public static String getURLName(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
        URL uRL = null;
        File file = FileUtil.toFile((FileObject)fileObject);
        uRL = file != null ? file.toURL() : fileObject.getURL();
        return uRL.toExternalForm();
    }

    public static URL createURL(URL uRL, String string) throws MalformedURLException, FileStateInvalidException {
        URL uRL2 = new URL(uRL, string);
        return uRL2;
    }

    public static Source createSource(URL uRL, String string) throws IOException, MalformedURLException, FileStateInvalidException, ParserConfigurationException, SAXException {
        URL uRL2 = TransformUtil.createURL(uRL, string);
        InputStream inputStream = uRL2.openStream();
        inputStream.close();
        XMLReader xMLReader = TransformUtil.newXMLReader();
        xMLReader.setEntityResolver(TransformUtil.getEntityResolver());
        SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(uRL2.toExternalForm()));
        return sAXSource;
    }

    public static URIResolver getURIResolver() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        URIResolver uRIResolver = userCatalog == null ? null : userCatalog.getURIResolver();
        return uRIResolver;
    }

    public static EntityResolver getEntityResolver() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        EntityResolver entityResolver = userCatalog == null ? null : userCatalog.getEntityResolver();
        return entityResolver;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(TransformUtil.getURIResolver());
        }
        return transformerFactory;
    }

    private static SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(SAX_FEATURES_NAMESPACES, true);
        }
        return saxParserFactory;
    }

    public static Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Transformer transformer = TransformUtil.getTransformerFactory().newTransformer(source);
        return transformer;
    }

    public static XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser sAXParser = TransformUtil.getSAXParserFactory().newSAXParser();
        return sAXParser.getXMLReader();
    }

    public static Source getAssociatedStylesheet(URL uRL) {
        Source source = null;
        try {
            XMLReader xMLReader = TransformUtil.newXMLReader();
            xMLReader.setEntityResolver(TransformUtil.getEntityResolver());
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(uRL.toExternalForm()));
            source = TransformUtil.getTransformerFactory().getAssociatedStylesheet(sAXSource, null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }

    public static String guessOutputExt(Source source) {
        String string = DEFAULT_OUTPUT_EXT;
        try {
            Transformer transformer = TransformUtil.newTransformer(source);
            String string2 = transformer.getOutputProperty("method");
            if ("text".equals(string2)) {
                string = "txt";
            } else if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void transform(Source source, TransformableCookie transformableCookie, Source source2, Result result, CookieObserver cookieObserver) throws TransformerException {
        if (transformableCookie != null) {
            transformableCookie.transform(source2, result, cookieObserver);
        } else {
            try {
                Transformer transformer = TransformUtil.newTransformer(source2);
                if (cookieObserver != null) {
                    Object object;
                    ProtectionDomain protectionDomain = transformer.getClass().getProtectionDomain();
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    if (codeSource == null) {
                        cookieObserver.receive(new CookieMessage(NbBundle.getMessage(TransformUtil.class, (String)"BK000", (Object)transformer.getClass().getName())));
                    } else {
                        object = codeSource.getLocation();
                        cookieObserver.receive(new CookieMessage(NbBundle.getMessage(TransformUtil.class, (String)"BK001", (Object)object, (Object)transformer.getClass().getName())));
                    }
                    object = new Proxy(cookieObserver);
                    transformer.setErrorListener((ErrorListener)object);
                }
                transformer.transform(source, result);
            }
            catch (Exception exception) {
                TransformerException transformerException = null;
                DefaultXMLProcessorDetail defaultXMLProcessorDetail = null;
                if (exception instanceof TransformerException) {
                    transformerException = (TransformerException)exception;
                    if (cookieObserver != null && exception instanceof TransformerConfigurationException) {
                        defaultXMLProcessorDetail = new DefaultXMLProcessorDetail(transformerException);
                    }
                } else if (exception instanceof SAXParseException) {
                    transformerException = new TransformerException(exception);
                    if (cookieObserver != null) {
                        defaultXMLProcessorDetail = new DefaultXMLProcessorDetail((SAXParseException)exception);
                    }
                } else {
                    transformerException = new TransformerException(exception);
                    if (cookieObserver != null) {
                        defaultXMLProcessorDetail = new DefaultXMLProcessorDetail(transformerException);
                    }
                }
                if (cookieObserver != null && defaultXMLProcessorDetail != null) {
                    CookieMessage cookieMessage = new CookieMessage(TransformUtil.unwrapException(exception).getLocalizedMessage(), 3, (Object)defaultXMLProcessorDetail);
                    cookieObserver.receive(cookieMessage);
                }
                throw transformerException;
            }
        }
    }

    public static Throwable unwrapException(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable instanceof TransformerException) {
            throwable2 = ((TransformerException)throwable).getException();
        } else if (throwable instanceof SAXException) {
            throwable2 = ((SAXException)throwable).getException();
        } else {
            return throwable;
        }
        if (throwable2 == null) {
            return throwable;
        }
        return TransformUtil.unwrapException(throwable2);
    }

    private static class Proxy
    implements ErrorListener {
        private final CookieObserver peer;

        public Proxy(CookieObserver cookieObserver) {
            if (cookieObserver == null) {
                throw new NullPointerException();
            }
            this.peer = cookieObserver;
        }

        public void error(TransformerException transformerException) throws TransformerException {
            this.report(2, transformerException);
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.report(3, transformerException);
            throw transformerException;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            this.report(1, transformerException);
        }

        private void report(int n, TransformerException transformerException) throws TransformerException {
            Throwable throwable = TransformUtil.unwrapException(transformerException);
            CookieMessage cookieMessage = new CookieMessage(throwable.getLocalizedMessage(), n, (Object)new DefaultXMLProcessorDetail(transformerException));
            this.peer.receive(cookieMessage);
        }
    }
}

