/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavaSourceSupportAccessor;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModificationResult {
    private Collection<Source> sources;
    private boolean committed;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();
    Map<?, int[]> tag2Span = new IdentityHashMap();

    ModificationResult(JavaSource javaSource) {
        this.sources = javaSource != null ? JavaSourceAccessor.getINSTANCE().getSources(javaSource) : null;
    }

    private ModificationResult(Collection<Source> collection) {
        this.sources = collection;
    }

    @NonNull
    public static ModificationResult runModificationTask(@NonNull Collection<Source> collection, final @NonNull UserTask userTask) throws ParseException {
        final ModificationResult modificationResult = new ModificationResult(collection);
        final JavacParser[] javacParserArray = new JavacParser[1];
        ParserManager.parse(collection, (UserTask)new UserTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator resultIterator2 = resultIterator = "text/x-java".equals(resultIterator.getSnapshot().getMimeType()) ? resultIterator : this.findEmbeddedJava(resultIterator);
                if (resultIterator != null) {
                    Parser.Result result = resultIterator.getParserResult();
                    CompilationController compilationController = CompilationController.get(result);
                    assert (compilationController != null);
                    WorkingCopy workingCopy = new WorkingCopy(compilationController.impl);
                    assert (WorkingCopy.instance == null);
                    WorkingCopy.instance = new WeakReference<WorkingCopy>(workingCopy);
                    try {
                        userTask.run(resultIterator);
                    }
                    finally {
                        WorkingCopy.instance = null;
                    }
                    JavacTaskImpl javacTaskImpl = workingCopy.impl.getJavacTask();
                    Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
                    javacParserArray[0] = workingCopy.impl.getParser();
                    List<Difference> list = workingCopy.getChanges(modificationResult.tag2Span);
                    if (list != null && list.size() > 0) {
                        modificationResult.diffs.put(workingCopy.getFileObject(), list);
                    }
                }
            }

            private ResultIterator findEmbeddedJava(ResultIterator resultIterator) throws ParseException {
                LinkedList<Embedding> linkedList = new LinkedList<Embedding>();
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    if ("text/x-java".equals(embedding.getMimeType())) {
                        return resultIterator.getResultIterator(embedding);
                    }
                    linkedList.add(embedding);
                }
                for (Embedding embedding : linkedList) {
                    ResultIterator resultIterator2 = this.findEmbeddedJava(resultIterator.getResultIterator(embedding));
                    if (resultIterator2 == null) continue;
                    return resultIterator2;
                }
                return null;
            }
        });
        if (javacParserArray[0] != null) {
            javacParserArray[0].invalidate();
        }
        return modificationResult;
    }

    @NonNull
    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(@NonNull FileObject fileObject) {
        return this.diffs.get(fileObject);
    }

    @NonNull
    public Set<File> getNewFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        for (List<Difference> list : this.diffs.values()) {
            for (Difference difference : list) {
                if (difference.getKind() != Difference.Kind.CREATE) continue;
                hashSet.add(new File(((CreateChange)difference).getFileObject().toUri()));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Calling commit on already committed Modificationesult.");
        }
        try {
            IndexingController.getDefault().enterProtectedMode();
            try {
                for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
                    this.commit(entry.getKey(), entry.getValue(), null);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                IndexingController.getDefault().exitProtectedMode(null);
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                if (this.sources != null) {
                    if (this.sources.size() == 1) {
                        Utilities.revalidate((Source)this.sources.iterator().next());
                    }
                    for (Source source : this.sources) {
                        hashSet.add(source.getFileObject());
                    }
                }
                for (FileObject fileObject : JavaSourceSupportAccessor.ACCESSOR.getVisibleEditorsFiles()) {
                    Source source;
                    if (hashSet.contains(fileObject) || (source = Source.create((FileObject)fileObject)) == null) continue;
                    Utilities.revalidate((Source)source);
                }
                throw throwable;
            }
            IndexingController.getDefault().exitProtectedMode(null);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            if (this.sources != null) {
                if (this.sources.size() == 1) {
                    Utilities.revalidate((Source)this.sources.iterator().next());
                }
                for (Source fileObject : this.sources) {
                    hashSet.add(fileObject.getFileObject());
                }
            }
            for (FileObject fileObject : JavaSourceSupportAccessor.ACCESSOR.getVisibleEditorsFiles()) {
                Source source;
                if (hashSet.contains(fileObject) || (source = Source.create((FileObject)fileObject)) == null) continue;
                Utilities.revalidate((Source)source);
            }
            Object var10_18 = null;
            this.committed = true;
            this.sources = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            this.committed = true;
            this.sources = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(FileObject fileObject, List<Difference> list, Writer writer) throws IOException {
        Writer writer2;
        Reader reader;
        ByteArrayOutputStream byteArrayOutputStream;
        block21: {
            Object object;
            EditorCookie editorCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie2 = editorCookie = dataObject != null ? (EditorCookie)dataObject.getCookie(EditorCookie.class) : null;
            if (editorCookie != null && writer == null && (object = editorCookie.getDocument()) != null) {
                IOException[] iOExceptionArray = new IOException[1];
                NbDocument.runAtomic((StyledDocument)object, (Runnable)new Runnable((StyledDocument)object, list, writer, iOExceptionArray){
                    final /* synthetic */ StyledDocument val$doc;
                    final /* synthetic */ List val$differences;
                    final /* synthetic */ Writer val$out;
                    final /* synthetic */ IOException[] val$exceptions;
                    {
                        this.val$doc = styledDocument;
                        this.val$differences = list;
                        this.val$out = writer;
                        this.val$exceptions = iOExceptionArray;
                    }

                    public void run() {
                        try {
                            ModificationResult.this.commit2(this.val$doc, this.val$differences, this.val$out);
                        }
                        catch (IOException iOException) {
                            this.val$exceptions[0] = iOException;
                        }
                    }
                });
                if (iOExceptionArray[0] != null) {
                    throw iOExceptionArray[0];
                }
                return;
            }
            object = null;
            byteArrayOutputStream = null;
            reader = null;
            writer2 = writer;
            try {
                int n;
                boolean bl;
                Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
                object = fileObject.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
                ((InputStream)object).close();
                object = null;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                int n2 = this.convertToLF(byArray);
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), charset);
                boolean bl2 = bl = writer != null;
                if (writer2 == null) {
                    writer2 = new OutputStreamWriter(fileObject.getOutputStream(), charset);
                }
                int n3 = 0;
                for (Difference difference : list) {
                    int n4;
                    if (difference.isExcluded()) continue;
                    if (Difference.Kind.CREATE == difference.getKind()) {
                        if (bl) continue;
                        this.createUnit(difference, null);
                        continue;
                    }
                    int n5 = difference.getStartPosition().getOffset();
                    int n6 = n5 - n3;
                    char[] cArray = new char[n6];
                    int n7 = 0;
                    while ((n4 = reader.read(cArray, 0, n6 - n7)) > 0 && n7 < n6) {
                        writer2.write(cArray, 0, n4);
                        n7 += n4;
                        n3 += n4;
                    }
                    switch (difference.getKind()) {
                        case INSERT: {
                            writer2.write(difference.getNewText());
                            break;
                        }
                        case REMOVE: {
                            int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                            reader.skip(n8);
                            n3 += n8;
                            break;
                        }
                        case CHANGE: {
                            int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                            reader.skip(n8);
                            n3 += n8;
                            writer2.write(difference.getNewText());
                        }
                    }
                }
                Object object2 = new char[1024];
                while ((n = reader.read((char[])object2)) > 0) {
                    writer2.write((char[])object2, 0, n);
                }
                Object var24_25 = null;
                if (object == null) break block21;
            }
            catch (Throwable throwable) {
                Object var24_26 = null;
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (writer2 != null) {
                    writer2.close();
                }
                throw throwable;
            }
            ((InputStream)object).close();
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        if (reader != null) {
            reader.close();
        }
        if (writer2 != null) {
            writer2.close();
        }
    }

    private void commit2(StyledDocument styledDocument, List<Difference> list, Writer writer) throws IOException {
        for (Difference difference : list) {
            if (difference.isExcluded()) continue;
            switch (difference.getKind()) {
                case INSERT: 
                case REMOVE: 
                case CHANGE: {
                    this.processDocument(styledDocument, difference);
                    break;
                }
                case CREATE: {
                    this.createUnit(difference, writer);
                }
            }
        }
    }

    private void processDocument(final StyledDocument styledDocument, final Difference difference) throws IOException {
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ModificationResult.this.processDocumentLocked(styledDocument, difference);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        if (difference.isCommitToGuards()) {
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        } else {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)styledDocument, (Runnable)runnable);
            }
            catch (BadLocationException badLocationException) {
                badLocationExceptionArray[0] = badLocationException;
            }
        }
        if (badLocationExceptionArray[0] != null) {
            IOException iOException = new IOException();
            iOException.initCause(badLocationExceptionArray[0]);
            throw iOException;
        }
    }

    private void processDocumentLocked(Document document, Difference difference) throws BadLocationException {
        switch (difference.getKind()) {
            case INSERT: {
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                break;
            }
            case REMOVE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                break;
            }
            case CHANGE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUnit(Difference difference, Writer writer) {
        CreateChange createChange = (CreateChange)difference;
        Writer writer2 = writer;
        if (writer2 == null) {
            createChange.getFileObject().openOutputStream();
            writer2 = createChange.getFileObject().openWriter();
        }
        writer2.append(createChange.getNewText());
        Object var7_5 = null;
        if (writer2 == null) return;
        try {
            writer2.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return;
        {
            catch (IOException iOException) {
                Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                Object var7_6 = null;
                if (writer2 == null) return;
                try {
                    writer2.close();
                    return;
                }
                catch (IOException iOException2) {
                    Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException2.getMessage(), iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer2 == null) throw throwable;
            try {
                writer2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            throw throwable;
        }
    }

    private int convertToLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray[n++] = byArray[i];
        }
        return n;
    }

    @NonNull
    public String getResultingSource(@NonNull FileObject fileObject) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!this.getModifiedFileObjects().contains(fileObject)) {
            throw new IllegalArgumentException("File: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " is not modified in this ModificationResult");
        }
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    @NullUnknown
    public int[] getSpan(@NonNull Object object) {
        return this.tag2Span.get(object);
    }

    static class CreateChange
    extends Difference {
        JavaFileObject fileObject;

        CreateChange(JavaFileObject javaFileObject, String string) {
            super(Difference.Kind.CREATE, null, null, null, string, "Create file " + javaFileObject.getName());
            this.fileObject = javaFileObject;
        }

        public JavaFileObject getFileObject() {
            return this.fileObject;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "Create File: " + this.fileObject.getName() + "; contents = \"\n" + this.newText + "\"";
        }
    }

    public static class Difference {
        Kind kind;
        final PositionRef startPos;
        final PositionRef endPos;
        String oldText;
        String newText;
        final String description;
        private boolean excluded;
        private boolean ignoreGuards = false;

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.description = string3;
            this.excluded = false;
        }

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2) {
            this(kind, positionRef, positionRef2, string, string2, null);
        }

        @NonNull
        public Kind getKind() {
            return this.kind;
        }

        @NonNull
        public PositionRef getStartPosition() {
            return this.startPos;
        }

        @NonNull
        public PositionRef getEndPosition() {
            return this.endPos;
        }

        @NonNull
        public String getOldText() {
            return this.oldText;
        }

        @NonNull
        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean bl) {
            this.excluded = bl;
        }

        public boolean isCommitToGuards() {
            return this.ignoreGuards;
        }

        public void setCommitToGuards(boolean bl) {
            this.ignoreGuards = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE,
            CREATE;

        }
    }
}

