/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtilities {
    private final CompilationInfo info;
    private final CommentHandlerService handler;

    TreeUtilities(CompilationInfo compilationInfo) {
        assert (compilationInfo != null);
        this.info = compilationInfo;
        this.handler = CommentHandlerService.instance(compilationInfo.impl.getJavacTask().getContext());
    }

    public boolean isClass(ClassTree classTree) {
        throw new UnsupportedOperationException();
    }

    public boolean isInterface(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x200L) != 0L;
    }

    public boolean isEnum(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isAnnotation(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x2000L) != 0L;
    }

    public boolean isSynthetic(TreePath treePath) throws NullPointerException {
        if (treePath == null) {
            throw new NullPointerException();
        }
        while (treePath != null) {
            if (this.isSynthetic(treePath.getCompilationUnit(), treePath.getLeaf())) {
                return true;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    private boolean isSynthetic(CompilationUnitTree compilationUnitTree, Tree tree) throws NullPointerException {
        IdentifierTree identifierTree;
        MethodInvocationTree methodInvocationTree;
        ExpressionStatementTree expressionStatementTree;
        JCTree jCTree = (JCTree)tree;
        if (jCTree.pos == -1) {
            return true;
        }
        if (tree.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L;
        }
        if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (expressionStatementTree = (ExpressionStatementTree)tree).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (methodInvocationTree = (MethodInvocationTree)expressionStatementTree.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((identifierTree = (IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString())) {
            SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
            return sourcePositions.getEndPosition(compilationUnitTree, tree) == -1L;
        }
        return false;
    }

    public List<Comment> getComments(Tree tree, boolean bl) {
        CommentSetImpl commentSetImpl = this.handler.getComments(tree);
        if (!commentSetImpl.areCommentsMapped()) {
            TreePath treePath;
            boolean bl2 = false;
            boolean bl3 = true;
            if (!$assertionsDisabled) {
                bl2 = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl2) {
                TreePath treePath2 = treePath = this.info.getCompilationUnit() == tree ? new TreePath(this.info.getCompilationUnit()) : TreePath.getPath(this.info.getCompilationUnit(), tree);
                if (treePath == null) {
                    Logger.getLogger(TreeUtilities.class.getName()).log(Level.WARNING, "Comment automap requested for Tree not from the root compilation info. Please, make sure to call GeneratorUtilities.importComments before Treeutilities.getComments. Tree: {0}", tree);
                    Logger.getLogger(TreeUtilities.class.getName()).log(Level.INFO, "Caller", new Exception());
                    bl3 = false;
                }
            }
            if (bl3) {
                try {
                    treePath = ((SourceFileObject)this.info.getCompilationUnit().getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    new TranslateIdentifier(this.info, true, false, (TokenSequence<JavaTokenId>)treePath).translate(tree);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        List<Comment> list = bl ? commentSetImpl.getPrecedingComments() : commentSetImpl.getTrailingComments();
        return Collections.unmodifiableList(list);
    }

    public TreePath pathFor(int n) {
        return this.pathFor(new TreePath(this.info.getCompilationUnit()), n);
    }

    public TreePath pathFor(TreePath treePath, int n) {
        return this.pathFor(treePath, n, this.info.getTrees().getSourcePositions());
    }

    public TreePath pathFor(TreePath treePath, int n, SourcePositions sourcePositions) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath treePath) {
                this.path = treePath;
            }
        }
        if (this.info == null || treePath == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PathFinder
            extends TreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int n, SourcePositions sourcePositions) {
                    this.pos = n;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void void_) {
                    if (tree != null && this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree) >= (long)this.pos) {
                        if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                            tree.accept(this, void_);
                            throw new Result(this.getCurrentPath());
                        }
                        super.scan(tree, void_);
                        throw new Result(new TreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }

                @Override
                public Void visitVariable(VariableTree variableTree, Void void_) {
                    int[] nArray = TreeUtilities.this.findNameSpan(variableTree);
                    if (nArray != null && nArray[0] <= this.pos && this.pos < nArray[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(variableTree, void_);
                }

                @Override
                public Void visitMethod(MethodTree methodTree, Void void_) {
                    int[] nArray = TreeUtilities.this.findNameSpan(methodTree);
                    if (nArray != null && nArray[0] <= this.pos && this.pos < nArray[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitMethod(methodTree, void_);
                }
            }
            new PathFinder(n, sourcePositions).scan(treePath, null);
        }
        catch (Result result) {
            treePath = result.path;
        }
        if (treePath.getLeaf() == treePath.getCompilationUnit()) {
            return treePath;
        }
        TokenSequence<JavaTokenId> tokenSequence = this.tokensFor(treePath.getLeaf(), sourcePositions);
        tokenSequence.moveEnd();
        if (tokenSequence.movePrevious() && tokenSequence.offset() < n) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case GTGTGT: 
                case GTGT: 
                case GT: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || treePath.getLeaf().getKind() == Tree.Kind.CLASS || treePath.getLeaf().getKind() == Tree.Kind.GREATER_THAN) break;
                }
                case RPAREN: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP || treePath.getLeaf().getKind() == Tree.Kind.FOR_LOOP || treePath.getLeaf().getKind() == Tree.Kind.IF || treePath.getLeaf().getKind() == Tree.Kind.WHILE_LOOP || treePath.getLeaf().getKind() == Tree.Kind.DO_WHILE_LOOP || treePath.getLeaf().getKind() == Tree.Kind.TYPE_CAST) break;
                }
                case SEMICOLON: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.FOR_LOOP && (long)tokenSequence.offset() <= sourcePositions.getStartPosition(treePath.getCompilationUnit(), ((ForLoopTree)treePath.getLeaf()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    treePath = treePath.getParentPath();
                    switch (treePath.getLeaf().getKind()) {
                        case CATCH: {
                            treePath = treePath.getParentPath();
                        }
                        case METHOD: 
                        case FOR_LOOP: 
                        case ENHANCED_FOR_LOOP: 
                        case IF: 
                        case SYNCHRONIZED: 
                        case WHILE_LOOP: 
                        case TRY: {
                            treePath = treePath.getParentPath();
                        }
                    }
                }
            }
        }
        return treePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMirror parseType(String string, TypeElement typeElement) {
        Enter enter = Enter.instance(this.info.impl.getJavacTask().getContext());
        TreeMaker treeMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int n = treeMaker.pos;
        try {
            if (enter.getClassEnv((Symbol.TypeSymbol)((Object)typeElement)) == null && this.info.getTrees().getTree(typeElement) == null) {
                TypeMirror typeMirror = null;
                return typeMirror;
            }
            Type type = this.info.impl.getJavacTask().parseType(string, typeElement);
            return type;
        }
        finally {
            treeMaker.pos = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementTree parseStatement(String string, SourcePositions[] sourcePositionsArray) {
        TreeMaker treeMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int n = treeMaker.pos;
        try {
            JCTree.JCStatement jCStatement = this.info.impl.getJavacTask().parseStatement(string, sourcePositionsArray);
            return jCStatement;
        }
        finally {
            treeMaker.pos = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionTree parseExpression(String string, SourcePositions[] sourcePositionsArray) {
        TreeMaker treeMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int n = treeMaker.pos;
        try {
            JCTree.JCExpression jCExpression = this.info.impl.getJavacTask().parseExpression(string, sourcePositionsArray);
            return jCExpression;
        }
        finally {
            treeMaker.pos = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionTree parseVariableInitializer(String string, SourcePositions[] sourcePositionsArray) {
        TreeMaker treeMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int n = treeMaker.pos;
        try {
            JCTree.JCExpression jCExpression = this.info.impl.getJavacTask().parseVariableInitializer(string, sourcePositionsArray);
            return jCExpression;
        }
        finally {
            treeMaker.pos = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockTree parseStaticBlock(String string, SourcePositions[] sourcePositionsArray) {
        TreeMaker treeMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int n = treeMaker.pos;
        try {
            JCTree.JCBlock jCBlock = this.info.impl.getJavacTask().parseStaticBlock(string, sourcePositionsArray);
            return jCBlock;
        }
        finally {
            treeMaker.pos = n;
        }
    }

    public Scope scopeFor(int n) {
        Object object;
        List<? extends StatementTree> list = null;
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        TreePath treePath = this.pathFor(n);
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        switch (treePath.getLeaf().getKind()) {
            case BLOCK: {
                list = ((BlockTree)treePath.getLeaf()).getStatements();
                break;
            }
            case FOR_LOOP: {
                list = ((ForLoopTree)treePath.getLeaf()).getInitializer();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                list = Collections.singletonList(((EnhancedForLoopTree)treePath.getLeaf()).getStatement());
                break;
            }
            case METHOD: {
                list = ((MethodTree)treePath.getLeaf()).getParameters();
            }
        }
        if (list != null) {
            object = null;
            for (StatementTree statementTree : list) {
                if (sourcePositions.getStartPosition(compilationUnitTree, statementTree) >= (long)n) continue;
                object = statementTree;
            }
            if (object != null) {
                treePath = new TreePath(treePath, (Tree)object);
            }
        }
        object = this.info.getTrees().getScope(treePath);
        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
            TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            tokenSequence.move(n);
            block11: while (tokenSequence.movePrevious()) {
                switch ((JavaTokenId)tokenSequence.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        continue block11;
                    }
                    case EXTENDS: 
                    case IMPLEMENTS: {
                        ((JavacScope)object).getEnv().baseClause = true;
                    }
                }
                return object;
            }
        }
        return object;
    }

    public TypeMirror attributeTree(Tree tree, Scope scope) {
        return this.info.impl.getJavacTask().attributeTree((JCTree)tree, ((JavacScope)scope).getEnv());
    }

    public Scope attributeTreeTo(Tree tree, Scope scope, Tree tree2) {
        return this.info.impl.getJavacTask().attributeTreeTo((JCTree)tree, ((JavacScope)scope).getEnv(), (JCTree)tree2);
    }

    public TypeMirror reattributeTree(Tree tree, Scope scope) {
        Env<AttrContext> env = ((JavacScope)scope).getEnv();
        this.copyInnerClassIndexes(env.tree, tree);
        return this.info.impl.getJavacTask().attributeTree((JCTree)tree, env);
    }

    public Scope reattributeTreeTo(Tree tree, Scope scope, Tree tree2) {
        Env<AttrContext> env = ((JavacScope)scope).getEnv();
        this.copyInnerClassIndexes(env.tree, tree);
        return this.info.impl.getJavacTask().attributeTreeTo((JCTree)tree, env, (JCTree)tree2);
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree) {
        return this.tokensFor(tree, this.info.getTrees().getSourcePositions());
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions) {
        int n = (int)sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
        int n2 = (int)sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        return this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(n, n2);
    }

    public boolean isAccessible(Scope scope, Element element, TypeMirror typeMirror) {
        if (scope instanceof JavacScope && element instanceof Symbol && typeMirror instanceof Type) {
            Resolve resolve = Resolve.instance(this.info.impl.getJavacTask().getContext());
            return resolve.isAccessible(((JavacScope)scope).getEnv(), (Type)typeMirror, (Symbol)element);
        }
        return false;
    }

    public boolean isStaticContext(Scope scope) {
        Resolve.instance(this.info.impl.getJavacTask().getContext());
        return Resolve.isStatic(((JavacScope)scope).getEnv());
    }

    public Set<TypeMirror> getUncaughtExceptions(TreePath treePath) {
        UnrelatedTypeMirrorSet unrelatedTypeMirrorSet = new UnrelatedTypeMirrorSet(this.info.getTypes());
        new UncaughtExceptionsVisitor(this.info).scan(treePath, unrelatedTypeMirrorSet);
        return unrelatedTypeMirrorSet;
    }

    public int[] findNameSpan(ClassTree classTree) {
        return this.findNameSpan(classTree.getSimpleName().toString(), classTree, JavaTokenId.CLASS, JavaTokenId.INTERFACE, JavaTokenId.ENUM, JavaTokenId.AT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    public int[] findNameSpan(MethodTree methodTree) {
        String string;
        if (this.isSynthetic(this.info.getCompilationUnit(), methodTree)) {
            return null;
        }
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
        if (jCMethodDecl.name == jCMethodDecl.name.table.names.init) {
            Element element;
            TreePath treePath = this.info.getTrees().getPath(this.info.getCompilationUnit(), jCMethodDecl);
            if (treePath == null) {
                return null;
            }
            Element element2 = this.info.getTrees().getElement(treePath);
            if (element2 == null || (element = element2.getEnclosingElement()) == null || !element.getKind().isClass()) {
                return null;
            }
            string = element.getSimpleName().toString();
        } else {
            string = methodTree.getName().toString();
        }
        return this.findNameSpan(string, methodTree, new JavaTokenId[0]);
    }

    public int[] findNameSpan(VariableTree variableTree) {
        return this.findNameSpan(variableTree.getName().toString(), variableTree, new JavaTokenId[0]);
    }

    public int[] findNameSpan(MemberSelectTree memberSelectTree) {
        return this.findNameSpan(memberSelectTree.getIdentifier().toString(), memberSelectTree, JavaTokenId.DOT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    private int[] findNameSpan(String string, Tree tree, JavaTokenId ... javaTokenIdArray) {
        boolean bl;
        if (!SourceVersion.isIdentifier(string)) {
            return null;
        }
        JCTree jCTree = (JCTree)tree;
        int n = jCTree.pos;
        if (n < 0) {
            return null;
        }
        EnumSet<JavaTokenId> enumSet = EnumSet.noneOf(JavaTokenId.class);
        enumSet.addAll(Arrays.asList(javaTokenIdArray));
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(n);
        while ((bl = tokenSequence.moveNext()) && enumSet.contains(tokenSequence.token().id())) {
        }
        if (bl && tokenSequence.token().id() == JavaTokenId.IDENTIFIER && string.contentEquals(tokenSequence.token().text())) {
            return new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
        }
        return null;
    }

    public StatementTree getBreakContinueTarget(TreePath treePath) throws IllegalArgumentException {
        if (this.info.getPhase().compareTo(JavaSource.Phase.RESOLVED) < 0) {
            throw new IllegalArgumentException("Not in correct Phase. Required: Phase.RESOLVED, got: Phase." + this.info.getPhase().toString());
        }
        Tree tree = treePath.getLeaf();
        switch (tree.getKind()) {
            case BREAK: {
                return (StatementTree)((Object)((JCTree.JCBreak)tree).target);
            }
            case CONTINUE: {
                StatementTree statementTree = (StatementTree)((Object)((JCTree.JCContinue)tree).target);
                if (statementTree == null) {
                    return null;
                }
                if (((JCTree.JCContinue)tree).label == null) {
                    return statementTree;
                }
                TreePath treePath2 = treePath;
                while (treePath2.getLeaf() != statementTree) {
                    treePath2 = treePath2.getParentPath();
                }
                Tree tree2 = treePath2.getParentPath().getLeaf();
                if (tree2.getKind() == Tree.Kind.LABELED_STATEMENT) {
                    return (StatementTree)tree2;
                }
                return statementTree;
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)tree.getKind()));
    }

    private void copyInnerClassIndexes(Tree tree, Tree tree2) {
        final int[] nArray = new int[]{-2};
        TreeScanner treeScanner = new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void void_) {
                if (nArray[0] < -1) {
                    super.scan(tree, void_);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree classTree, Void void_) {
                nArray[0] = ((JCTree.JCClassDecl)classTree).index;
                return (Void)super.visitClass(classTree, void_);
            }
        };
        treeScanner.scan(tree, null);
        treeScanner = new TreeScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void void_) {
                int n = nArray[0];
                nArray[0] = n + 1;
                ((JCTree.JCClassDecl)classTree).index = n;
                return (Void)super.visitClass(classTree, void_);
            }
        };
        treeScanner.scan(tree2, null);
        if (nArray[0] < -1) {
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnrelatedTypeMirrorSet
    extends AbstractSet<TypeMirror> {
        private Types types;
        private LinkedList<TypeMirror> list = new LinkedList();

        public UnrelatedTypeMirrorSet(Types types) {
            this.types = types;
        }

        @Override
        public boolean add(TypeMirror typeMirror) {
            ListIterator listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                TypeMirror typeMirror2 = (TypeMirror)listIterator.next();
                if (this.types.isSubtype(typeMirror, typeMirror2)) {
                    return false;
                }
                if (!this.types.isSubtype(typeMirror2, typeMirror)) continue;
                listIterator.remove();
            }
            return this.list.add(typeMirror);
        }

        @Override
        public Iterator<TypeMirror> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UncaughtExceptionsVisitor
    extends TreePathScanner<Void, Set<TypeMirror>> {
        private final CompilationInfo info;

        private UncaughtExceptionsVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Set<TypeMirror> set) {
            super.visitMethodInvocation(methodInvocationTree, set);
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && element.getKind() == ElementKind.METHOD) {
                set.addAll(((ExecutableElement)element).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Set<TypeMirror> set) {
            super.visitNewClass(newClassTree, set);
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
                set.addAll(((ExecutableElement)element).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree throwTree, Set<TypeMirror> set) {
            super.visitThrow(throwTree, set);
            TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), throwTree.getExpression()));
            if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                set.add(typeMirror);
            }
            return null;
        }

        @Override
        public Void visitTry(TryTree tryTree, Set<TypeMirror> set) {
            HashSet hashSet = new HashSet();
            this.scan(tryTree.getBlock(), hashSet);
            for (CatchTree catchTree : tryTree.getCatches()) {
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                if (typeMirror.getKind() == TypeKind.ERROR) continue;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)iterator.next(), typeMirror)) continue;
                    iterator.remove();
                }
            }
            set.addAll(hashSet);
            this.scan(tryTree.getCatches(), set);
            this.scan(tryTree.getFinallyBlock(), set);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Set<TypeMirror> set) {
            HashSet hashSet = new HashSet();
            this.scan(methodTree.getBody(), hashSet);
            for (ExpressionTree expressionTree : methodTree.getThrows()) {
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expressionTree));
                if (typeMirror.getKind() == TypeKind.ERROR) continue;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)iterator.next(), typeMirror)) continue;
                    iterator.remove();
                }
            }
            set.addAll(hashSet);
            return null;
        }
    }
}

