/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.text.BadLocationException;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileSourceRewriter
implements SourceRewriter {
    JavaFileObject sourcefile;
    PrintWriter out;
    File outFile;

    public FileSourceRewriter(JavaFileObject javaFileObject) throws IOException {
        this(javaFileObject, null);
    }

    public FileSourceRewriter(JavaFileObject javaFileObject, String string) throws IOException {
        this.sourcefile = javaFileObject;
        String string2 = javaFileObject.toString();
        File file = new File(string2);
        if (!file.exists()) {
            throw new FileNotFoundException(string2);
        }
        if (!file.canWrite()) {
            throw new IOException("cannot write to " + string2);
        }
        this.outFile = new File(javaFileObject.toUri().getPath() + ".tmp");
        OutputStreamWriter outputStreamWriter = string != null && string.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), string) : new FileWriter(this.outFile);
        this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
    }

    public void writeTo(String string) throws IOException, BadLocationException {
        this.out.print(string);
    }

    public void skipThrough(SourceReader sourceReader, int n) throws IOException, BadLocationException {
        sourceReader.seek(n);
    }

    public void copyTo(SourceReader sourceReader, int n) throws IOException {
        char[] cArray = sourceReader.getCharsTo(n);
        this.out.write(cArray);
    }

    public void copyRest(SourceReader sourceReader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = sourceReader.read(cArray)) > 0) {
            this.out.write(cArray, 0, n);
        }
    }

    public void close(boolean bl) throws IOException {
        this.out.close();
        this.out = null;
        if (bl) {
            String string = this.sourcefile.toUri().getPath();
            File file = new File(string);
            File file2 = new File(string + '~');
            if (file2.exists() && !file2.delete()) {
                throw new IOException("failed deleting backup file: " + file2);
            }
            if (!file.renameTo(file2)) {
                throw new IOException("failed renaming (" + string + ") to backup (" + file2 + ")");
            }
            file = new File(string);
            if (!this.outFile.renameTo(file)) {
                throw new IOException("failed renaming new output file (" + this.outFile + ") to path (" + string + ")");
            }
            this.outFile = file;
            FileObject fileObject = FileUtil.toFileObject((File)this.outFile);
            if (fileObject != null) {
                fileObject.refresh(true);
            }
        }
    }
}

