/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompileWorker {
    CompileWorker() {
    }

    abstract ParsingOutput compile(ParsingOutput var1, Context var2, JavaParsingContext var3, Iterable<? extends Indexable> var4);

    CompileTuple createTuple(Context context, JavaParsingContext javaParsingContext, Indexable indexable) {
        FileObject fileObject;
        File file = null;
        if (!context.checkForEditorModifications() && "file".equals(indexable.getURL().getProtocol()) && (file = FileUtil.toFile((FileObject)context.getRoot())) != null) {
            try {
                File file2 = new File(indexable.getURL().toURI().getPath());
                return new CompileTuple(FileObjects.fileFileObject(file2, file, null, javaParsingContext.encoding), indexable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (fileObject = URLMapper.findFileObject((URL)indexable.getURL())) != null ? new CompileTuple(SourceFileObject.create(fileObject, context.getRoot()), indexable) : null;
    }

    public void computeFQNs(Map<URI, List<String>> map, CompilationUnitTree compilationUnitTree, JavaFileObject javaFileObject) {
        String string = compilationUnitTree.getPackageName() != null ? compilationUnitTree.getPackageName().toString() + "." : "";
        for (Tree tree : compilationUnitTree.getTypeDecls()) {
            if (tree.getKind() != Tree.Kind.CLASS) continue;
            URI uRI = javaFileObject.toUri();
            List<String> list = map.get(uRI);
            if (list == null) {
                list = new LinkedList<String>();
                map.put(uRI, list);
            }
            list.add(string + ((ClassTree)tree).getSimpleName().toString());
        }
    }

    static class CompileTuple {
        public final JavaFileObject jfo;
        public final Indexable indexable;

        public CompileTuple(JavaFileObject javaFileObject, Indexable indexable) {
            this.jfo = javaFileObject;
            this.indexable = indexable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParsingOutput {
        final boolean success;
        final Map<URI, List<String>> file2FQNs;
        final Set<ElementHandle<TypeElement>> addedTypes;
        final Set<File> createdFiles;
        final Set<Indexable> finishedFiles;
        final Map<URL, Set<URL>> root2Rebuild;

        public ParsingOutput(boolean bl, Map<URI, List<String>> map, Set<ElementHandle<TypeElement>> set, Set<File> set2, Set<Indexable> set3, Map<URL, Set<URL>> map2) {
            this.success = bl;
            this.file2FQNs = map;
            this.addedTypes = set;
            this.createdFiles = set2;
            this.finishedFiles = set3;
            this.root2Rebuild = map2;
        }
    }
}

