/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.indexing.MultiPassCompileWorker;
import org.netbeans.modules.java.source.indexing.OnePassCompileWorker;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.tasklist.RebuildOraculum;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCustomIndexer
extends CustomIndexer {
    private static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    private static final CompileWorker[] WORKERS = new CompileWorker[]{new OnePassCompileWorker(), new MultiPassCompileWorker()};

    protected void index(final Iterable<? extends Indexable> iterable, final Context context) {
        JavaIndex.LOG.log(Level.FINE, context.isSupplementaryFilesIndexing() ? "index suplementary({0})" : "index({0})", iterable);
        try {
            final FileObject fileObject = context.getRoot();
            if (fileObject == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
            if (JavaIndex.ensureAttributeValue(context.getRootURI(), SOURCE_LEVEL_ROOT, string, true)) {
                JavaIndex.LOG.fine("forcing reindex due to source level change");
                IndexingManager.getDefault().refreshIndex(context.getRootURI(), null);
                return;
            }
            final ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            final ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            final ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            if (classPath == null || classPath2 == null || classPath3 == null) {
                JavaIndex.LOG.warning("Ignoring root with no ClassPath: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            if (!Arrays.asList(classPath.getRoots()).contains(fileObject)) {
                JavaIndex.LOG.warning("Source root: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " is not on its sourcepath");
                return;
            }
            ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    return TaskCache.getDefault().refreshTransaction(new Mutex.ExceptionAction<Void>(){

                        /*
                         * WARNING - void declaration
                         */
                        public Void run() throws Exception {
                            Object object22;
                            JavaParsingContext javaParsingContext = new JavaParsingContext(fileObject, classPath2, classPath3, classPath, context.checkForEditorModifications());
                            if (javaParsingContext.uq == null) {
                                return null;
                            }
                            List<URL> list = context.isSupplementaryFilesIndexing() ? null : TaskCache.getDefault().getAllFilesInError(context.getRootURI());
                            HashSet hashSet = new HashSet();
                            HashSet<File> hashSet2 = new HashSet<File>();
                            javaParsingContext.uq.setDirty(null);
                            for (Object object22 : iterable) {
                                JavaCustomIndexer.clear(context, javaParsingContext, object22.getRelativePath(), hashSet, hashSet2);
                            }
                            Object object3 = null;
                            for (CompileWorker set : WORKERS) {
                                object3 = set.compile((CompileWorker.ParsingOutput)object3, context, javaParsingContext, iterable);
                                if (((CompileWorker.ParsingOutput)object3).success) break;
                            }
                            assert (object3 != null && ((CompileWorker.ParsingOutput)object3).success);
                            object22 = new HashSet<ElementHandle<TypeElement>>(((CompileWorker.ParsingOutput)object3).addedTypes);
                            HashSet<ElementHandle<TypeElement>> hashSet3 = new HashSet<ElementHandle<TypeElement>>(hashSet);
                            HashSet<File> hashSet4 = new HashSet<File>(((CompileWorker.ParsingOutput)object3).createdFiles);
                            object22.removeAll(hashSet);
                            hashSet3.removeAll(((CompileWorker.ParsingOutput)object3).addedTypes);
                            hashSet4.removeAll(hashSet2);
                            ((CompileWorker.ParsingOutput)object3).addedTypes.retainAll(hashSet);
                            if (!context.isSupplementaryFilesIndexing()) {
                                for (Map.Entry<URL, Collection<URL>> entry : RebuildOraculum.findAllDependent(context.getRootURI(), null, javaParsingContext.cpInfo.getClassIndex(), hashSet3).entrySet()) {
                                    Set<URL> set = ((CompileWorker.ParsingOutput)object3).root2Rebuild.get(entry.getKey());
                                    if (set == null) {
                                        set = new HashSet<URL>();
                                        ((CompileWorker.ParsingOutput)object3).root2Rebuild.put(entry.getKey(), set);
                                    }
                                    set.addAll(entry.getValue());
                                }
                                if (!list.isEmpty() && !hashSet4.isEmpty()) {
                                    void var9_15;
                                    Set<URL> set = ((CompileWorker.ParsingOutput)object3).root2Rebuild.get(context.getRootURI());
                                    if (set == null) {
                                        HashSet hashSet5 = new HashSet();
                                        ((CompileWorker.ParsingOutput)object3).root2Rebuild.put(context.getRootURI(), hashSet5);
                                    }
                                    var9_15.addAll(list);
                                }
                            }
                            javaParsingContext.sa.store();
                            javaParsingContext.uq.typesEvent((Collection<? extends ElementHandle<TypeElement>>)object22, hashSet3, ((CompileWorker.ParsingOutput)object3).addedTypes);
                            BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), hashSet2, ((CompileWorker.ParsingOutput)object3).createdFiles);
                            for (Map.Entry<URL, Set<URL>> entry : ((CompileWorker.ParsingOutput)object3).root2Rebuild.entrySet()) {
                                context.addSupplementaryFiles(entry.getKey(), (Collection)entry.getValue());
                            }
                            return null;
                        }
                    });
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void clearFiles(final Context context, final Iterable<? extends Indexable> iterable) {
        try {
            if (context.getRoot() == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    return TaskCache.getDefault().refreshTransaction(new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JavaParsingContext javaParsingContext = new JavaParsingContext(context.getRoot());
                            if (javaParsingContext.uq == null) {
                                return null;
                            }
                            HashSet<ElementHandle<TypeElement>> hashSet = new HashSet<ElementHandle<TypeElement>>();
                            HashSet<File> hashSet2 = new HashSet<File>();
                            for (Object object : iterable) {
                                JavaCustomIndexer.clear(context, javaParsingContext, object.getRelativePath(), hashSet, hashSet2);
                                TaskCache.getDefault().dumpErrors(context.getRootURI(), object.getURL(), Collections.emptyList());
                            }
                            Map<URL, Collection<URL>> map = RebuildOraculum.findAllDependent(context.getRootURI(), null, javaParsingContext.cpInfo.getClassIndex(), hashSet);
                            javaParsingContext.sa.store();
                            BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), hashSet2, Collections.<File>emptySet());
                            javaParsingContext.uq.typesEvent(null, hashSet, null);
                            for (Map.Entry entry : map.entrySet()) {
                                context.addSupplementaryFiles((URL)entry.getKey(), (Collection)entry.getValue());
                            }
                            return null;
                        }
                    });
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void clear(Context context, JavaParsingContext javaParsingContext, String string, Set<ElementHandle<TypeElement>> set, Set<File> set2) throws IOException {
        Object object;
        Object object2;
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        File file = JavaIndex.getClassFolder(context);
        String string2 = FileObjects.stripExtension(string);
        File file2 = new File(file, string2 + '.' + "rs");
        boolean bl = true;
        if (file2.exists()) {
            bl = false;
            try {
                object2 = FileObjects.getBinaryName(file2, file);
                for (String string3 : JavaCustomIndexer.readRSFile(file2, file)) {
                    object = new File(file, FileObjects.convertPackage2Folder(string3) + '.' + "sig");
                    if (!((String)object2).equals(string3)) {
                        arrayList.add(Pair.of(string3, string));
                        set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string3));
                        set2.add((File)object);
                        ((File)object).delete();
                        continue;
                    }
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            file2.delete();
        }
        if (bl && (file2 = new File(file, string2 + '.' + "sig")).exists()) {
            object2 = file2.getName();
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
            final String[] stringArray = new String[]{(String)object2 + '.', (String)object2 + '$'};
            File file3 = file2.getParentFile();
            object = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.startsWith(stringArray[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File file4 : file3.listFiles((FilenameFilter)object)) {
                String string4 = FileObjects.getBinaryName(file4, file);
                arrayList.add(Pair.of(string4, null));
                set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string4));
                set2.add(file4);
                file4.delete();
            }
        }
        for (Pair pair : arrayList) {
            javaParsingContext.sa.delete(pair);
        }
    }

    private static void markDirtyFiles(Context context, Iterable<? extends Indexable> iterable) {
        ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().getUsagesQuery(context.getRootURI());
        if (classIndexImpl != null) {
            for (Indexable indexable : iterable) {
                classIndexImpl.setDirty(indexable.getURL());
            }
        }
    }

    public static void verifySourceLevel(URL uRL, String string) throws IOException {
        if (JavaIndex.ensureAttributeValue(uRL, SOURCE_LEVEL_ROOT, string, true)) {
            JavaIndex.LOG.fine("forcing reindex due to source level change");
            IndexingManager.getDefault().refreshIndex(uRL, null);
        }
    }

    public static Collection<? extends ElementHandle<TypeElement>> getRelatedTypes(File file, File file2) throws IOException {
        String string;
        LinkedList<ElementHandle> linkedList = new LinkedList<ElementHandle>();
        File file3 = JavaIndex.getClassFolder(file2);
        String string2 = FileObjects.stripExtension(FileObjects.getRelativePath(file2, file));
        File file4 = new File(file3, string2 + '.' + "rs");
        boolean bl = true;
        if (file4.exists()) {
            bl = false;
            try {
                string = FileObjects.getBinaryName(file4, file3);
                for (String object : JavaCustomIndexer.readRSFile(file4, file3)) {
                    if (!string.equals(object)) {
                        linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, object));
                        continue;
                    }
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (file4 = new File(file3, string2 + '.' + "sig")).exists()) {
            string = file4.getName();
            string = string.substring(0, string.lastIndexOf(46));
            final String[] stringArray = new String[]{string + '.', string + '$'};
            File file5 = file4.getParentFile();
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.startsWith(stringArray[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File file6 : file5.listFiles(filenameFilter)) {
                String string3 = FileObjects.getBinaryName(file6, file3);
                linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string3));
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readRSFile(File file, File file2) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new JavaCustomIndexer();
        }

        public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDeleted({0})", collection);
            JavaCustomIndexer.clearFiles(context, collection);
        }

        public void filesDirty(Collection<? extends Indexable> collection, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDirty({0})", collection);
            JavaCustomIndexer.markDirtyFiles(context, collection);
        }

        public String getIndexerName() {
            return "java";
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }

        public int getIndexVersion() {
            return 13;
        }
    }
}

