/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryFileManager
implements JavaFileManager {
    private final Map<String, List<Integer>> packages = new HashMap<String, List<Integer>>();
    private final Map<Integer, FileObjects.InferableJavaFileObject> content = new HashMap<Integer, FileObjects.InferableJavaFileObject>();
    private final AtomicInteger currentId = new AtomicInteger();

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        throw new UnsupportedOperationException();
    }

    public List<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        List<Integer> list;
        if (bl) {
            throw new UnsupportedEncodingException();
        }
        LinkedList<JavaFileObject> linkedList = new LinkedList<JavaFileObject>();
        if (location == StandardLocation.SOURCE_PATH && (list = this.packages.get(string)) != null) {
            for (Integer n : list) {
                FileObjects.InferableJavaFileObject inferableJavaFileObject = this.content.get(n);
                assert (inferableJavaFileObject != null);
                if (!set.contains((Object)inferableJavaFileObject.getKind())) continue;
                linkedList.add(inferableJavaFileObject);
            }
        }
        return linkedList;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        if (location == StandardLocation.SOURCE_PATH && javaFileObject instanceof FileObjects.InferableJavaFileObject) {
            return ((FileObjects.InferableJavaFileObject)javaFileObject).inferBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return fileObject == null ? fileObject2 == null : (fileObject2 == null ? false : fileObject.toUri().equals(fileObject2.toUri()));
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.SOURCE_PATH;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        List<Integer> list;
        String[] stringArray;
        if (location == StandardLocation.SOURCE_PATH && (stringArray = FileObjects.getPackageAndName(string)) != null && (list = this.packages.get(stringArray[0])) != null) {
            for (Integer n : list) {
                FileObjects.InferableJavaFileObject inferableJavaFileObject = this.content.get(n);
                assert (inferableJavaFileObject != null);
                if (!string.equals(inferableJavaFileObject.inferBinaryName())) continue;
                return inferableJavaFileObject;
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        List<Integer> list;
        if (location == StandardLocation.SOURCE_PATH && (list = this.packages.get(string)) != null) {
            for (Integer n : list) {
                FileObjects.InferableJavaFileObject inferableJavaFileObject = this.content.get(n);
                assert (inferableJavaFileObject != null);
                if (!string2.equals(inferableJavaFileObject.getName())) continue;
                return inferableJavaFileObject;
            }
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        throw new UnsupportedOperationException("");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.packages.clear();
        this.content.clear();
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    public boolean register(FileObjects.InferableJavaFileObject inferableJavaFileObject) {
        Parameters.notNull((CharSequence)"jfo", (Object)inferableJavaFileObject);
        String string = inferableJavaFileObject.inferBinaryName();
        String[] stringArray = FileObjects.getPackageAndName(string);
        List<Integer> list = this.packages.get(stringArray[0]);
        if (list == null) {
            list = new LinkedList<Integer>();
            this.packages.put(stringArray[0], list);
        }
        for (Integer n : list) {
            FileObjects.InferableJavaFileObject inferableJavaFileObject2 = this.content.get(n);
            assert (inferableJavaFileObject2 != null);
            if (!string.equals(inferableJavaFileObject2.inferBinaryName())) continue;
            this.content.put(n, inferableJavaFileObject);
            return true;
        }
        Integer n = this.currentId.getAndIncrement();
        this.content.put(n, inferableJavaFileObject);
        list.add(n);
        return false;
    }

    public boolean unregister(String string) {
        Parameters.notNull((CharSequence)"fqn", (Object)string);
        String[] stringArray = FileObjects.getPackageAndName(string);
        List<Integer> list = this.packages.get(stringArray[0]);
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            FileObjects.InferableJavaFileObject inferableJavaFileObject = this.content.get(n);
            assert (inferableJavaFileObject != null);
            if (!string.equals(inferableJavaFileObject.inferBinaryName())) continue;
            iterator.remove();
            this.content.remove(n);
            return true;
        }
        return false;
    }
}

