/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorAnnotator
extends AnnotationProvider {
    private static final String ERROR_BADGE_URL = "org/netbeans/modules/java/source/resources/icons/error-badge.gif";
    private static final Image ERROR_BADGE_SINGLE;
    private static final Image ERROR_BADGE_FOLDER;
    private static final int IN_ERROR_REC = 1;
    private static final int IN_ERROR_NONREC = 2;
    private static final int INVALID = 4;
    private Map<FileObject, Integer> knownFiles2Error = new WeakHashMap<FileObject, Integer>();
    private long cumulativeTime;
    private Collection<FileObject> toProcess = null;
    private final RequestProcessor.Task WORKER = new RequestProcessor("ErrorAnnotator worker", 1).create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection collection;
            long l = System.currentTimeMillis();
            ErrorAnnotator errorAnnotator = ErrorAnnotator.this;
            synchronized (errorAnnotator) {
                collection = ErrorAnnotator.this.toProcess;
                ErrorAnnotator.this.toProcess = null;
            }
            for (FileObject fileObject : collection) {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                if (fileObject.isData()) {
                    bl = bl2 = TaskCache.getDefault().isInError(fileObject, true);
                } else {
                    boolean bl3 = false;
                    object = FileOwnerQuery.getOwner((FileObject)fileObject);
                    if (object != null) {
                        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)object).getSourceGroups("java")) {
                            FileObject fileObject2 = sourceGroup.getRootFolder();
                            if (fileObject2 == null) {
                                Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.WARNING, "SourceGroup[" + sourceGroup.getDisplayName() + "].getRootFolder() returned null");
                                continue;
                            }
                            if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) && fileObject != fileObject2) continue;
                            bl = TaskCache.getDefault().isInError(fileObject2, true);
                            bl2 = TaskCache.getDefault().isInError(fileObject2, false);
                            bl3 = true;
                            break;
                        }
                    }
                    if (!bl3) {
                        bl = TaskCache.getDefault().isInError(fileObject, true);
                        bl2 = TaskCache.getDefault().isInError(fileObject, false);
                    }
                }
                Integer n = (bl ? 1 : 0) | (bl2 ? 2 : 0);
                object = ErrorAnnotator.this;
                synchronized (object) {
                    ErrorAnnotator.this.knownFiles2Error.put(fileObject, n);
                }
                ErrorAnnotator.this.fireFileStatusChanged(Collections.singleton(fileObject));
            }
            long l2 = System.currentTimeMillis();
            Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, "time spent in error annotations computation: {0}, cumulative time: {1}", new Object[]{l2 - l, ErrorAnnotator.this.cumulativeTime += l2 - l});
        }
    });

    public String annotateName(String string, Set set) {
        return null;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        Object object;
        boolean bl;
        if (!TasklistSettings.isTasklistEnabled() || !TasklistSettings.isBadgesEnabled()) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = bl = set.size() == 1;
        if (set instanceof NonRecursiveFolder) {
            object = ((NonRecursiveFolder)set).getFolder();
            bl2 = this.isInError((FileObject)object, false, true);
            bl = false;
        } else {
            for (Object object2 : set) {
                if (!(object2 instanceof FileObject)) continue;
                FileObject fileObject = (FileObject)object2;
                if (fileObject.isFolder()) {
                    bl = false;
                    if (this.isInError(fileObject, true, !bl2)) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl2) continue;
                    continue;
                }
                if (!fileObject.isData() || !"java".equals(fileObject.getExt()) || !this.isInError(fileObject, true, !bl2)) continue;
                bl2 = true;
            }
        }
        Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, "files={0}, in error={1}", new Object[]{set, bl2});
        if (bl2) {
            Object object2;
            object = ImageUtilities.mergeImages((Image)image, (Image)(bl ? ERROR_BADGE_SINGLE : ERROR_BADGE_FOLDER), (int)0, (int)8);
            object2 = Lookup.getDefault().lookupAll(AnnotationProvider.class).iterator();
            boolean bl4 = false;
            while (object2.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)object2.next();
                if (bl4) {
                    Image image2 = annotationProvider.annotateIcon((Image)object, n, set);
                    if (image2 == null) continue;
                    return image2;
                }
                bl4 = annotationProvider == this;
            }
            return object;
        }
        return null;
    }

    public String annotateNameHtml(String string, Set set) {
        return null;
    }

    public Action[] actions(Set set) {
        return null;
    }

    public InterceptionListener getInterceptionListener() {
        return null;
    }

    public void updateAllInError() {
        try {
            File[] fileArray;
            for (File file : fileArray = File.listRoots()) {
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) continue;
                this.fireFileStatusChanged(new FileStatusEvent(fileObject.getFileSystem(), true, false));
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
    }

    public synchronized void updateInError(Set<URL> set) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (FileObject fileObject : this.knownFiles2Error.keySet()) {
            try {
                if (!set.contains(fileObject.getURL())) continue;
                hashSet.add(fileObject);
                Integer n = this.knownFiles2Error.get(fileObject);
                if (n == null) continue;
                this.knownFiles2Error.put(fileObject, n | 4);
                this.enqueue(fileObject);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public void fireFileStatusChanged(Set<FileObject> set) {
        if (set.isEmpty()) {
            return;
        }
        try {
            this.fireFileStatusChanged(new FileStatusEvent(set.iterator().next().getFileSystem(), set, true, false));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
    }

    public static ErrorAnnotator getAnnotator() {
        for (AnnotationProvider annotationProvider : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
            if (annotationProvider.getClass() != ErrorAnnotator.class) continue;
            return (ErrorAnnotator)annotationProvider;
        }
        return null;
    }

    private void enqueue(FileObject fileObject) {
        if (this.toProcess == null) {
            this.toProcess = new LinkedList<FileObject>();
            this.WORKER.schedule(50);
        }
        this.toProcess.add(fileObject);
    }

    private synchronized boolean isInError(FileObject fileObject, boolean bl, boolean bl2) {
        boolean bl3 = false;
        Integer n = this.knownFiles2Error.get(fileObject);
        if (n != null) {
            boolean bl4 = bl3 = (n & (bl ? 1 : 2)) != 0;
            if ((n & 4) == 0) {
                return bl3;
            }
        }
        if (!bl2) {
            if (n == null) {
                this.knownFiles2Error.put(fileObject, null);
            }
            return bl3;
        }
        this.enqueue(fileObject);
        return bl3;
    }

    static {
        URL uRL = ErrorAnnotator.class.getClassLoader().getResource(ERROR_BADGE_URL);
        String string = "<img src=\"" + uRL + "\">&nbsp;" + NbBundle.getMessage(ErrorAnnotator.class, (String)"TP_ErrorBadgeSingle");
        ERROR_BADGE_SINGLE = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)ERROR_BADGE_URL), (String)string);
        String string2 = "<img src=\"" + uRL + "\">&nbsp;" + NbBundle.getMessage(ErrorAnnotator.class, (String)"TP_ErrorBadgeFolder");
        ERROR_BADGE_FOLDER = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)ERROR_BADGE_URL), (String)string2);
    }
}

