/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncorrectErrorBadges
implements CancellableTask<CompilationInfo> {
    private static final boolean DISABLE = Boolean.getBoolean(IncorrectErrorBadges.class.getName() + ".disable");
    private static final Logger LOG = Logger.getLogger(IncorrectErrorBadges.class.getName());
    private int invocationCount;
    private long timestamp;
    private FactoryImpl factory;
    private static final RequestProcessor WORKER = new RequestProcessor(IncorrectErrorBadges.class.getName());

    private IncorrectErrorBadges(FactoryImpl factoryImpl) {
        this.factory = factoryImpl;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        if (DISABLE) {
            LOG.fine("Disabled");
            return;
        }
        if (IndexingController.getDefault().isInProtectedMode()) {
            LOG.fine("RepositoryUpdater in protected mode");
            return;
        }
        LOG.log(Level.FINE, "invocationCount={0}, file={1}", new Object[]{this.invocationCount, compilationInfo.getFileObject()});
        if (this.invocationCount++ > 1) {
            LOG.log(Level.FINE, "Too many invocations: {0}", this.invocationCount);
            return;
        }
        try {
            Diagnostic diagnostic2;
            for (Diagnostic diagnostic2 : compilationInfo.getDiagnostics()) {
                if (diagnostic2.getKind() != Diagnostic.Kind.ERROR) continue;
                LOG.log(Level.FINE, "File contains errors: {0}", compilationInfo.getFileObject());
                return;
            }
            final FileObject fileObject = compilationInfo.getFileObject();
            diagnostic2 = DataObject.find((FileObject)fileObject);
            if (diagnostic2.isModified()) {
                LOG.log(Level.FINE, "File is modified: {0}", compilationInfo.getFileObject());
                return;
            }
            if (!TaskCache.getDefault().isInError(fileObject, false)) {
                LOG.log(Level.FINE, "No TaskCache.isInError: {0}", compilationInfo.getFileObject());
                return;
            }
            if (this.invocationCount == 1) {
                this.timestamp = fileObject.lastModified().getTime();
                LOG.log(Level.FINE, "Capturing timestamp={0}, file={1}", new Object[]{this.timestamp, compilationInfo.getFileObject()});
                WORKER.post(new Runnable(){

                    public void run() {
                        IncorrectErrorBadges.this.factory.rescheduleImpl(fileObject);
                    }
                }, 2 * IndexingController.getDefault().getFileLocksDelay());
                return;
            }
            long l = fileObject.lastModified().getTime();
            if (this.timestamp != 0L && this.timestamp != l) {
                LOG.log(Level.FINE, "File modified since last check: {0}, timestamp={1}, lastModified={2}, invocationCount={3}", new Object[]{compilationInfo.getFileObject(), this.timestamp, l, this.invocationCount});
                return;
            }
            LOG.log(Level.WARNING, "Incorrect error badges detected, file={0}.", FileUtil.getFileDisplayName((FileObject)fileObject));
            ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                LOG.log(Level.WARNING, "The file is not on its own source classpath, ignoring.");
                return;
            }
            LOG.log(Level.WARNING, "Going to recompute root={0}, files in error={1}.", new Object[]{FileUtil.getFileDisplayName((FileObject)fileObject2), TaskCache.getDefault().getAllFilesInError(fileObject2.getURL())});
            IndexingManager.getDefault().refreshIndex(fileObject2.getURL(), null);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory {
        public FactoryImpl() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.MIN);
        }

        @Override
        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new IncorrectErrorBadges(this);
        }

        void rescheduleImpl(FileObject fileObject) {
            this.reschedule(fileObject);
        }
    }
}

