/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.usages.ContainsErrorsWarning;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupport;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportEvent;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportListener;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildArtifactMapperImpl {
    private static final String ASK_BEFORE_RUN_WITH_ERRORS = "askBeforeRunWithErrors";
    private static final Logger LOG = Logger.getLogger(BuildArtifactMapperImpl.class.getName());
    private static final String TAG_FILE_NAME = ".netbeans_automatic_build";
    private static final String SIG = ".sig";
    private static final Map<URL, Set<BuildArtifactMapper.ArtifactsUpdated>> source2Listener = new HashMap<URL, Set<BuildArtifactMapper.ArtifactsUpdated>>();
    private static final long MINIMAL_TIMESTAMP = 2000L;
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
    private static Map<File, Reference<FileChangeListenerImpl>> file2Listener = new WeakHashMap<File, Reference<FileChangeListenerImpl>>();
    private static Map<FileChangeListenerImpl, File> listener2File = new WeakHashMap<FileChangeListenerImpl, File>();

    public static synchronized void addArtifactsUpdatedListener(URL uRL, BuildArtifactMapper.ArtifactsUpdated artifactsUpdated) {
        Set<BuildArtifactMapper.ArtifactsUpdated> set = source2Listener.get(uRL);
        if (set == null) {
            set = new HashSet<BuildArtifactMapper.ArtifactsUpdated>();
            source2Listener.put(uRL, set);
        }
        set.add(artifactsUpdated);
    }

    public static synchronized void removeArtifactsUpdatedListener(URL uRL, BuildArtifactMapper.ArtifactsUpdated artifactsUpdated) {
        Set<BuildArtifactMapper.ArtifactsUpdated> set = source2Listener.get(uRL);
        if (set == null) {
            return;
        }
        set.remove(artifactsUpdated);
        if (set.isEmpty()) {
            source2Listener.remove(uRL);
        }
    }

    private static boolean protectAgainstErrors(File file, FileObject[][] fileObjectArray) throws MalformedURLException {
        Preferences preferences = NbPreferences.forModule(BuildArtifactMapperImpl.class).node(BuildArtifactMapperImpl.class.getSimpleName());
        if (!preferences.getBoolean(ASK_BEFORE_RUN_WITH_ERRORS, true)) {
            return true;
        }
        BuildArtifactMapperImpl.sources(file, fileObjectArray);
        for (FileObject fileObject : fileObjectArray[0]) {
            if (!TaskCache.getDefault().isInError(fileObject, true)) continue;
            String string = NbBundle.getMessage(BuildArtifactMapperImpl.class, (String)"BTN_RunAnyway");
            String string2 = NbBundle.getMessage(BuildArtifactMapperImpl.class, (String)"BTN_Cancel");
            ContainsErrorsWarning containsErrorsWarning = new ContainsErrorsWarning();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)containsErrorsWarning, NbBundle.getMessage(BuildArtifactMapperImpl.class, (String)"TITLE_ContainsErrorsWarning"), true, new Object[]{string, string2}, (Object)string, 0, null, null);
            dialogDescriptor.setMessageType(2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == string) {
                preferences.putBoolean(ASK_BEFORE_RUN_WITH_ERRORS, containsErrorsWarning.getAskBeforeRunning());
                return true;
            }
            return false;
        }
        return true;
    }

    private static void sources(File file, FileObject[][] fileObjectArray) throws MalformedURLException {
        if (fileObjectArray[0] == null) {
            URL uRL = FileUtil.urlForArchiveOrDir((File)file);
            fileObjectArray[0] = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
        }
    }

    private static File getTarget(URL uRL) {
        BinaryForSourceQuery.Result result = BinaryForSourceQuery.findBinaryRoots((URL)uRL);
        File file = null;
        for (URL uRL2 : result.getRoots()) {
            File file2 = FileUtil.archiveOrDirForURL((URL)uRL2);
            try {
                if (FileUtil.isArchiveFile((URL)file2.toURI().toURL())) continue;
                if (file2 != null && file != null) {
                    Logger.getLogger(BuildArtifactMapperImpl.class.getName()).log(Level.WARNING, "More than one binary directory for root: {0}", uRL.toExternalForm());
                    return null;
                }
                file = file2;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return file;
    }

    public static Boolean ensureBuilt(URL uRL, boolean bl) throws IOException {
        File file = BuildArtifactMapperImpl.getTarget(uRL);
        if (file == null) {
            return null;
        }
        try {
            SourceUtils.waitScanFinished();
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.FINE, null, interruptedException);
            return false;
        }
        FileObject[][] fileObjectArrayArray = new FileObject[1][];
        if (!BuildArtifactMapperImpl.protectAgainstErrors(file, fileObjectArrayArray)) {
            return false;
        }
        File file2 = new File(file, TAG_FILE_NAME);
        if (file2.exists()) {
            return true;
        }
        BuildArtifactMapperImpl.delete(file, bl);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create destination folder: " + file.getAbsolutePath());
        }
        BuildArtifactMapperImpl.sources(file, fileObjectArrayArray);
        for (FileObject fileObject : fileObjectArrayArray[0]) {
            File file3 = JavaIndex.getClassFolder(fileObject.getURL(), true);
            if (file3 == null) {
                return false;
            }
            BuildArtifactMapperImpl.copyRecursively(file3, file);
        }
        new FileOutputStream(file2).close();
        return true;
    }

    public static Boolean clean(URL uRL) throws IOException {
        File file = BuildArtifactMapperImpl.getTarget(uRL);
        if (file == null) {
            return null;
        }
        try {
            SourceUtils.waitScanFinished();
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.FINE, null, interruptedException);
            return false;
        }
        File file2 = new File(file, TAG_FILE_NAME);
        if (!file2.exists()) {
            return null;
        }
        BuildArtifactMapperImpl.delete(file, false);
        BuildArtifactMapperImpl.delete(file2, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void classCacheUpdated(URL uRL, File file, Iterable<File> iterable, Iterable<File> iterable2) {
        Object object;
        if (!iterable.iterator().hasNext()) {
            if (!iterable2.iterator().hasNext()) return;
        }
        File file2 = BuildArtifactMapperImpl.getTarget(uRL);
        File file3 = file2;
        if (file3 == null) {
            return;
        }
        if (!new File(file3, TAG_FILE_NAME).exists()) {
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        assert (file3 != null);
        for (File file4 : iterable) {
            object = BuildArtifactMapperImpl.resolveFile(file3, BuildArtifactMapperImpl.relativizeFile(file, file4));
            ((File)object).delete();
            linkedList.add((File)object);
        }
        for (File file5 : iterable2) {
            object = BuildArtifactMapperImpl.resolveFile(file3, BuildArtifactMapperImpl.relativizeFile(file, file5));
            try {
                BuildArtifactMapperImpl.copyFile(file5, (File)object);
                linkedList.add((File)object);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (linkedList.size() <= 0) return;
        Class<BuildArtifactMapperImpl> clazz = BuildArtifactMapperImpl.class;
        synchronized (BuildArtifactMapperImpl.class) {
            HashSet hashSet = source2Listener.get(uRL);
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
            }
            // ** MonitorExit[var7_10] (shouldn't be in output)
            if (hashSet == null) return;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (BuildArtifactMapper.ArtifactsUpdated)iterator.next();
                object.artifactsUpdated(linkedList);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        IOException iOException3;
        FileOutputStream fileOutputStream;
        block12: {
            File file3 = file2.getParentFile();
            if (file3 != null && !file3.exists() && !file3.mkdirs()) {
                throw new IOException("Cannot create folder: " + file3.getAbsolutePath());
            }
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                Object var6_5 = null;
                if (fileInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var6_6 = null;
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException22) {
                        Exceptions.printStackTrace((Throwable)iOException22);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException22) {
                        Exceptions.printStackTrace((Throwable)iOException22);
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException3) {
                Exceptions.printStackTrace((Throwable)iOException3);
            }
        }
        if (fileOutputStream != null) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException3) {
                Exceptions.printStackTrace((Throwable)iOException3);
            }
        }
    }

    private static void copyRecursively(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray;
            if (!file2.exists()) {
                if (!file2.mkdirs()) {
                    throw new IOException("Cannot create folder: " + file2.getAbsolutePath());
                }
            } else if (!file2.isDirectory()) {
                throw new IOException("Cannot create folder: " + file2.getAbsolutePath() + ", already exists as a file.");
            }
            if ((fileArray = file.listFiles()) == null) {
                return;
            }
            for (File file3 : fileArray) {
                String string = file3.getName();
                if (string.endsWith(SIG)) {
                    string = string.substring(0, string.length() - "sig".length()) + "class";
                }
                BuildArtifactMapperImpl.copyRecursively(file3, new File(file2, string));
            }
        } else {
            if (file2.isDirectory()) {
                throw new IOException("Cannot create file: " + file2.getAbsolutePath() + ", already exists as a folder.");
            }
            BuildArtifactMapperImpl.copyFile(file, file2);
        }
    }

    private static void delete(File file, boolean bl) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                BuildArtifactMapperImpl.delete(file2, bl);
            }
            if (bl) {
                file.delete();
            }
        } else if (bl || file.getName().endsWith(".class")) {
            file.delete();
        }
    }

    public static File resolveFile(File file, String string) throws IllegalArgumentException {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (string.endsWith(SIG)) {
            string = string.substring(0, string.length() - "sig".length()) + "class";
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            assert (file2.isAbsolute());
        }
        return FileUtil.normalizeFile((File)file2);
    }

    public static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(BuildArtifactMapperImpl.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    private static final class FileChangeListenerImpl
    implements FileChangeSupportListener {
        private RequestProcessor NOTIFY = new RequestProcessor(FileChangeListenerImpl.class.getName());
        private Set<ChangeListener> notify = new WeakSet();

        private FileChangeListenerImpl() {
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.notifyListeners();
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.notifyListeners();
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.notifyListeners();
        }

        private synchronized void addListener(ChangeListener changeListener) {
            this.notify.add(changeListener);
        }

        private synchronized void notifyListeners() {
            final HashSet<ChangeListener> hashSet = new HashSet<ChangeListener>(this.notify);
            this.NOTIFY.post(new Runnable(){

                public void run() {
                    for (ChangeListener changeListener : hashSet) {
                        changeListener.stateChanged(null);
                    }
                }
            });
        }
    }

    private static final class FileBuiltQueryStatusImpl
    implements FileBuiltQuery.Status,
    ChangeListener {
        private final FileBuiltQuery.Status delegate;
        private final File tag;
        private final FileChangeListenerImpl fileListener;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FileBuiltQueryStatusImpl(FileBuiltQuery.Status status, File file, FileChangeListenerImpl fileChangeListenerImpl) {
            this.delegate = status;
            this.tag = file;
            this.fileListener = fileChangeListenerImpl;
            status.addChangeListener((ChangeListener)this);
            fileChangeListenerImpl.addListener(this);
        }

        public boolean isBuilt() {
            return this.delegate.isBuilt() || this.tag.canRead();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.cs.fireChange();
        }
    }

    public static final class FileBuildQueryImpl
    implements FileBuiltQueryImplementation {
        private final ThreadLocal<Boolean> recursive = new ThreadLocal();
        private final Map<FileObject, Reference<FileBuiltQuery.Status>> file2Status = new WeakHashMap<FileObject, Reference<FileBuiltQuery.Status>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized FileBuiltQuery.Status getStatus(FileObject fileObject) {
            FileObject fileObject2;
            ClassPath classPath;
            FileBuiltQuery.Status status;
            FileBuiltQuery.Status status2;
            block10: {
                block9: {
                    Reference<FileBuiltQuery.Status> reference = this.file2Status.get(fileObject);
                    FileBuiltQuery.Status status3 = status2 = reference != null ? reference.get() : null;
                    if (status2 != null) {
                        return status2;
                    }
                    if (this.recursive.get() != null) {
                        return null;
                    }
                    this.recursive.set(true);
                    status = FileBuiltQuery.getStatus((FileObject)fileObject);
                    if (status != null) break block9;
                    FileBuiltQuery.Status status4 = null;
                    Object var13_8 = null;
                    this.recursive.remove();
                    return status4;
                }
                classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                FileObject fileObject3 = fileObject2 = classPath != null ? classPath.findOwnerRoot(fileObject) : null;
                if (fileObject2 != null) break block10;
                FileBuiltQuery.Status status5 = status;
                Object var13_9 = null;
                this.recursive.remove();
                return status5;
            }
            try {
                FileChangeListenerImpl fileChangeListenerImpl;
                File file = BuildArtifactMapperImpl.getTarget(fileObject2.getURL());
                File file2 = FileUtil.normalizeFile((File)new File(file, BuildArtifactMapperImpl.TAG_FILE_NAME));
                Reference reference = (Reference)file2Listener.get(file2);
                FileChangeListenerImpl fileChangeListenerImpl2 = fileChangeListenerImpl = reference != null ? (FileChangeListenerImpl)reference.get() : null;
                if (fileChangeListenerImpl == null) {
                    fileChangeListenerImpl = new FileChangeListenerImpl();
                    file2Listener.put(file2, new WeakReference<FileChangeListenerImpl>(fileChangeListenerImpl));
                    listener2File.put(fileChangeListenerImpl, file2);
                    FileChangeSupport.DEFAULT.addListener(fileChangeListenerImpl, file2);
                }
                status2 = new FileBuiltQueryStatusImpl(status, file2, fileChangeListenerImpl);
                this.file2Status.put(fileObject, new WeakReference<FileBuiltQueryStatusImpl>((FileBuiltQueryStatusImpl)status2));
                FileBuiltQuery.Status status6 = status2;
                Object var13_10 = null;
                this.recursive.remove();
                return status6;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                try {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    classPath = null;
                    Object var13_11 = null;
                    this.recursive.remove();
                    return classPath;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    this.recursive.remove();
                    throw throwable;
                }
            }
        }
    }
}

