/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.preprocessorbridge.spi.VirtualSourceProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.Pair;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualSourceProviderQuery {
    private static final Lookup.Result<VirtualSourceProvider> result = Lookup.getDefault().lookupResult(VirtualSourceProvider.class);
    private static Map<String, VirtualSourceProvider> ext2prov;
    private static final LookupListener l;

    private VirtualSourceProviderQuery() {
    }

    public static boolean hasVirtualSource(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        String string = FileObjects.getExtension(file.getName());
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static boolean hasVirtualSource(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        String string = fileObject.getExt();
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static boolean hasVirtualSource(String string) {
        Parameters.notNull((CharSequence)"extension", (Object)string);
        return VirtualSourceProviderQuery.getExt2ProvMap().keySet().contains(string);
    }

    public static Iterable<Binding> translate(Iterable<? extends File> iterable, File file) throws IOException {
        Object object;
        VirtualSourceProvider virtualSourceProvider;
        Parameters.notNull((CharSequence)"files", iterable);
        Parameters.notNull((CharSequence)"root", (Object)file);
        HashMap hashMap = new HashMap();
        Map<String, VirtualSourceProvider> map = VirtualSourceProviderQuery.getExt2ProvMap();
        for (File object2 : iterable) {
            Object object3 = FileObjects.getExtension(object2.getName());
            virtualSourceProvider = map.get(object3);
            if (virtualSourceProvider == null) continue;
            object = (Pair)hashMap.get(object3);
            List<File> list = null;
            if (object == null) {
                list = new LinkedList();
                hashMap.put(object3, Pair.of(virtualSourceProvider, list));
            } else {
                list = (List)((Pair)object).second;
            }
            list.add(object2);
        }
        R r = new R(file);
        for (Object object3 : hashMap.values()) {
            virtualSourceProvider = (VirtualSourceProvider)((Pair)object3).first;
            object = (List)((Pair)object3).second;
            r.setProvider(virtualSourceProvider);
            virtualSourceProvider.translate((Iterable)object, file, (VirtualSourceProvider.Result)r);
        }
        return r.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, VirtualSourceProvider> getExt2ProvMap() {
        Object object = VirtualSourceProviderQuery.class;
        synchronized (VirtualSourceProviderQuery.class) {
            if (ext2prov != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ext2prov;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = new LinkedList(result.allInstances());
            Class<VirtualSourceProviderQuery> clazz = VirtualSourceProviderQuery.class;
            synchronized (VirtualSourceProviderQuery.class) {
                if (ext2prov == null) {
                    ext2prov = new HashMap<String, VirtualSourceProvider>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        VirtualSourceProvider virtualSourceProvider = (VirtualSourceProvider)iterator.next();
                        for (String string : virtualSourceProvider.getSupportedExtensions()) {
                            ext2prov.put(string, virtualSourceProvider);
                        }
                    }
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return ext2prov;
            }
        }
    }

    private static synchronized void reset() {
        ext2prov = null;
    }

    static {
        l = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                VirtualSourceProviderQuery.reset();
            }
        };
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)l, result));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R
    implements VirtualSourceProvider.Result {
        private final File root;
        private String rootURL;
        private VirtualSourceProvider currentProvider;
        final List<Binding> res = new LinkedList<Binding>();

        public R(File file) throws IOException {
            assert (file != null);
            this.root = file;
            this.rootURL = file.toURI().toURL().toString();
            if (!this.rootURL.endsWith("/")) {
                this.rootURL = this.rootURL + '/';
            }
        }

        public List<Binding> getResult() {
            this.currentProvider = null;
            return this.res;
        }

        void setProvider(VirtualSourceProvider virtualSourceProvider) {
            assert (virtualSourceProvider != null);
            this.currentProvider = virtualSourceProvider;
        }

        public void add(File file, String string, String string2, CharSequence charSequence) {
            try {
                String string3 = string2 + JavaFileObject.Kind.SOURCE.extension;
                this.res.add(new Binding(file, FileObjects.memoryFileObject(string, string3, new URI(this.rootURL + FileObjects.convertPackage2Folder(string) + '/' + string3), System.currentTimeMillis(), charSequence), this.currentProvider));
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
    }

    public static final class Binding {
        public final FileObjects.InferableJavaFileObject virtual;
        public final File original;
        public final boolean index;

        public Binding(File file, FileObjects.InferableJavaFileObject inferableJavaFileObject, VirtualSourceProvider virtualSourceProvider) {
            assert (inferableJavaFileObject != null);
            assert (file != null);
            assert (virtualSourceProvider != null);
            this.virtual = inferableJavaFileObject;
            this.original = file;
            this.index = virtualSourceProvider.index();
        }
    }
}

