/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Icons {
    private static final String ICON_BASE = "org/netbeans/modules/java/source/resources/icons/";
    private static final String GIF_EXTENSION = ".gif";
    private static final String PNG_EXTENSION = ".png";
    private static final String WAIT = "org/netbeans/modules/java/source/resources/icons/wait.png";

    private Icons() {
    }

    public static Icon getBusyIcon() {
        Image image = ImageUtilities.loadImage((String)WAIT);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon getElementIcon(ElementKind elementKind, Collection<Modifier> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        Image image = null;
        switch (elementKind) {
            case PACKAGE: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/package.gif");
                break;
            }
            case ENUM: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/enum.png");
                break;
            }
            case ANNOTATION_TYPE: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/annotation.png");
                break;
            }
            case CLASS: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/class.png");
                break;
            }
            case INTERFACE: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/interface.png");
                break;
            }
            case FIELD: {
                image = ImageUtilities.loadImage((String)Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/field", PNG_EXTENSION, collection));
                break;
            }
            case ENUM_CONSTANT: {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/source/resources/icons/constant.png");
                break;
            }
            case CONSTRUCTOR: {
                image = ImageUtilities.loadImage((String)Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/constructor", PNG_EXTENSION, collection));
                break;
            }
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                image = ImageUtilities.loadImage((String)Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/initializer", PNG_EXTENSION, collection));
                break;
            }
            case METHOD: {
                image = ImageUtilities.loadImage((String)Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/method", PNG_EXTENSION, collection));
                break;
            }
            default: {
                image = null;
            }
        }
        return image == null ? null : new ImageIcon(image);
    }

    private static String getIconName(ElementKind elementKind, String string, String string2, Collection<Modifier> collection) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (collection.contains((Object)Modifier.STATIC)) {
            stringBuffer.append("Static");
        }
        if (elementKind == ElementKind.STATIC_INIT || elementKind == ElementKind.INSTANCE_INIT) {
            return stringBuffer.append(string2).toString();
        }
        if (collection.contains((Object)Modifier.PUBLIC)) {
            return stringBuffer.append("Public").append(string2).toString();
        }
        if (collection.contains((Object)Modifier.PROTECTED)) {
            return stringBuffer.append("Protected").append(string2).toString();
        }
        if (collection.contains((Object)Modifier.PRIVATE)) {
            return stringBuffer.append("Private").append(string2).toString();
        }
        return stringBuffer.append("Package").append(string2).toString();
    }
}

