/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.hibernate.editor.DocumentContext;
import org.netbeans.modules.hibernate.editor.EditorContextFactory;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionContext {
    private ArrayList<String> existingAttributes;
    private CompletionType completionType = CompletionType.NONE;
    private Document doc;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;

    public CompletionContext(Document document, int n) {
        this.doc = document;
        this.caretOffset = n;
        this.support = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
        this.documentContext = EditorContextFactory.getDocumentContext(document, n);
        this.lastTypedChar = this.support.lastTypedChar();
        this.initContext();
    }

    private void initContext() {
        TokenItem tokenItem = this.documentContext.getCurrentToken();
        if (tokenItem == null) {
            return;
        }
        boolean bl = tokenItem.getOffset() == this.caretOffset || tokenItem.getOffset() + tokenItem.getImage().length() == this.caretOffset;
        int n = tokenItem.getTokenID().getNumericID();
        SyntaxElement syntaxElement = this.documentContext.getCurrentElement();
        switch (n) {
            case 1: {
                String string = tokenItem.getImage().trim();
                if (string != null && string.equals("") && tokenItem.getPrevious().getImage().trim().equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (string != null && string.equals("") && tokenItem.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (string != null && !string.startsWith("<") && tokenItem.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    this.typedChars = "";
                    break;
                }
                if (string != null && !string.equals("<") && tokenItem.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (string != null && string.startsWith("<")) {
                    this.typedChars = string.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 4: {
                if (syntaxElement instanceof EndTag) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (syntaxElement instanceof EmptyTag) {
                    if (tokenItem != null && tokenItem.getImage().trim().equals("/>")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    EmptyTag emptyTag = (EmptyTag)syntaxElement;
                    if (syntaxElement.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    if (this.caretOffset > syntaxElement.getElementOffset() + 1 && this.caretOffset <= syntaxElement.getElementOffset() + 1 + emptyTag.getTagName().length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = emptyTag.getTagName();
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (syntaxElement instanceof StartTag) {
                    if (tokenItem != null && tokenItem.getImage().trim().equals(">")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (tokenItem != null && tokenItem.getImage().trim().startsWith("</")) {
                        this.typedChars = "";
                        this.completionType = CompletionType.VALUE;
                        break;
                    }
                    if (syntaxElement.getElementOffset() + 1 != this.caretOffset) {
                        StartTag startTag = (StartTag)syntaxElement;
                        this.typedChars = startTag.getTagName();
                    }
                }
                if (syntaxElement instanceof Text && tokenItem != null && tokenItem.getImage().trim().startsWith("</")) {
                    this.typedChars = tokenItem.getPrevious().getImage().trim();
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 5: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = tokenItem.getImage().substring(0, this.caretOffset - tokenItem.getOffset());
                break;
            }
            case 6: 
            case 11: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case 7: {
                if (!bl) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = tokenItem.getImage().substring(1, this.caretOffset - tokenItem.getOffset());
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case 2: {
                TokenItem tokenItem2;
                this.completionType = CompletionType.NONE;
                for (tokenItem2 = tokenItem.getPrevious(); tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 2; tokenItem2 = tokenItem2.getPrevious()) {
                }
                if (tokenItem2.getTokenID().getNumericID() == 5) {
                    this.typedChars = tokenItem2.getImage();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (tokenItem2.getTokenID().getNumericID() != 7 && tokenItem2.getTokenID().getNumericID() != 4) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement syntaxElement = this.documentContext.getCurrentElement();
        return syntaxElement instanceof Tag ? (Node)syntaxElement : null;
    }

    public TokenItem getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes != null) {
            return this.existingAttributes;
        }
        this.existingAttributes = new ArrayList();
        for (TokenItem tokenItem = this.documentContext.getCurrentToken().getPrevious(); tokenItem != null && tokenItem.getTokenID().getNumericID() != 4; tokenItem = tokenItem.getPrevious()) {
            if (tokenItem.getTokenID().getNumericID() != 5) continue;
            this.existingAttributes.add(tokenItem.getImage());
        }
        return this.existingAttributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }
}

