/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MoveMappingFilePanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private final ListCellRenderer GROUP_CELL_RENDERER = new GroupCellRenderer();
    private Project project;
    private ChangeListener parent;
    private FileObject fo;
    private SourceGroup[] groups;
    private String startPackage;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JLabel labelHeadLine;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JComboBox packageComboBox;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JCheckBox updateReferencesCheckBox;

    public MoveMappingFilePanel(ChangeListener changeListener, String string, String string2, FileObject fileObject) {
        this.fo = fileObject;
        this.parent = changeListener;
        this.initComponents();
        this.setCombosEnabled(true);
        this.labelHeadLine.setText(string2);
        this.rootComboBox.setRenderer(this.GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        Component component = this.packageComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this);
        }
        this.startPackage = string;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initValues(this.startPackage);
        this.initialized = true;
    }

    public void initValues(String string) {
        this.updateRoots();
        this.updatePackages();
        if (string != null) {
            this.packageComboBox.setSelectedItem(string);
        }
    }

    public void requestFocus() {
        this.packageComboBox.requestFocus();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string;
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectTextField = new JTextField();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.labelHeadLine = new JLabel();
        this.updateReferencesCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(MoveMappingFilePanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(MoveMappingFilePanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription("null");
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(MoveMappingFilePanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.labelHeadLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 6, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.labelHeadLine, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(MoveMappingFilePanel.class).getString("LBL_MoveWithoutReferences"));
        this.updateReferencesCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.updateReferencesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MoveMappingFilePanel.this.updateReferencesCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
    }

    private void updateReferencesCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.parent.stateChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.rootComboBox == actionEvent.getSource()) {
            this.updatePackages();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    private void updatePackages() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(PackageView.createListView((SourceGroup)sourceGroup));
    }

    void setCombosEnabled(boolean bl) {
        this.packageComboBox.setEnabled(bl);
        this.rootComboBox.setEnabled(bl);
        this.updateReferencesCheckBox.setVisible(!bl);
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("resources");
        if (this.groups == null || this.groups.length == 0) {
            this.groups = sources.getSourceGroups("java");
        }
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fo == null) continue;
            try {
                if (!this.groups[i].contains(this.fo)) continue;
                n = i;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        this.rootComboBox.setSelectedIndex(n);
    }

    public Component getComponent() {
        return this;
    }

    static class GroupCellRenderer
    extends BaseCellRenderer {
        GroupCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            SourceGroup sourceGroup = (SourceGroup)object;
            this.setText(sourceGroup.getDisplayName());
            this.setIcon(sourceGroup.getIcon(false));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

