/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaManager;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaTableProvider;
import org.netbeans.modules.hibernate.wizards.support.EmptyTableProvider;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    private static final String REGEXP_XML_FILE = ".+\\.xml";
    private static final String REGEXP_CFG_XML_FILE = ".+\\.cfg\\.xml";
    private static Logger logger = Logger.getLogger(HibernateUtil.class.getName());

    public static List<String> getAllDatabaseTables(HibernateConfiguration ... hibernateConfigurationArray) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HibernateConfiguration hibernateConfiguration : hibernateConfigurationArray) {
            try {
                ResultSet resultSet;
                Connection connection;
                DatabaseConnection databaseConnection = HibernateUtil.getDBConnection(hibernateConfiguration);
                if (databaseConnection == null || (connection = databaseConnection.getJDBCConnection()) == null) continue;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet2 = databaseMetaData.getSchemas();
                if (resultSet2.next()) {
                    do {
                        resultSet = databaseMetaData.getTables(null, resultSet2.getString("TABLE_SCHEM"), null, new String[]{"TABLE"});
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("TABLE_NAME"));
                        }
                    } while (resultSet2.next());
                    continue;
                }
                resultSet = databaseMetaData.getTables(null, databaseConnection.getSchema(), null, new String[]{"TABLE"});
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("TABLE_NAME"));
                }
            }
            catch (DatabaseException databaseException) {
                Exceptions.printStackTrace((Throwable)databaseException);
            }
        }
        return arrayList;
    }

    public static List<String> getAllDatabaseTablesOnEventThread(FileObject fileObject) throws SQLException, DatabaseException, DataObjectNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBSchemaManager dBSchemaManager = new DBSchemaManager();
        DatabaseConnection databaseConnection = HibernateUtil.getDBConnection(((HibernateCfgDataObject)DataObject.find((FileObject)fileObject)).getHibernateConfiguration());
        SchemaElement schemaElement = dBSchemaManager.getSchemaElement(databaseConnection);
        TableProvider tableProvider = null;
        tableProvider = schemaElement != null ? new DBSchemaTableProvider(schemaElement) : new EmptyTableProvider();
        for (Table table : tableProvider.getTables()) {
            arrayList.add(table.getName());
        }
        return arrayList;
    }

    public static List<HibernateConfiguration> getAllHibernateConfigurations(Project project) {
        ArrayList<HibernateConfiguration> arrayList = new ArrayList<HibernateConfiguration>();
        for (FileObject fileObject : HibernateUtil.getAllHibernateConfigFileObjects(project)) {
            try {
                arrayList.add(((HibernateCfgDataObject)DataObject.find((FileObject)fileObject)).getHibernateConfiguration());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return arrayList;
    }

    public static List<FileObject> getAllHibernateConfigFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-cfg+xml");
    }

    public static List<FileObject> getDefaultHibernateConfigFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_CFG_XML_FILE, null);
    }

    public static List<FileObject> getAllHibernateMappingFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-mapping+xml");
    }

    private static FileObject createBuildFolder(File file) {
        FileObject fileObject = null;
        logger.info("Build folder does not exist. Creating it.");
        try {
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, "Cannot create build folder", iOException);
        }
        return fileObject;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
        if (sourceGroupArray.length > 0) {
            return sourceGroupArray;
        }
        SourceGroup sourceGroup = SourceGroupModifier.createSourceGroup((Project)project, (String)"resources", (String)"main");
        if (sourceGroup != null) {
            return new SourceGroup[]{sourceGroup};
        }
        return sources.getSourceGroups("java");
    }

    public static SourceGroup getFirstSourceGroup(Project project) {
        return HibernateUtil.getSourceGroups(project)[0];
    }

    public static FileObject findJavaFileObjectInProject(String string, Project project) {
        string = string.replace('.', File.separatorChar);
        string = string + ".java";
        GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
        FileObject fileObject = globalPathRegistry.findResource(string);
        return fileObject;
    }

    public static List<URL> getProjectClassPathEntries(FileObject fileObject) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        for (ClassPath.Entry entry : classPath.entries()) {
            arrayList.add(entry.getURL());
        }
        return arrayList;
    }

    public static List<URL> getProjectClassPath(Project project) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (SourceGroup sourceGroup : HibernateUtil.getSourceGroups(project)) {
            if (sourceGroup == null) continue;
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
            for (ClassPath.Entry entry : classPath.entries()) {
                arrayList.add(entry.getURL());
            }
        }
        return arrayList;
    }

    public static FileObject getBuildFO(Project project) {
        FileObject fileObject = null;
        try {
            File file;
            Object object;
            BinaryForSourceQuery.Result result;
            Object object2;
            BinaryForSourceQuery binaryForSourceQuery = (BinaryForSourceQuery)project.getLookup().lookup(BinaryForSourceQuery.class);
            if (binaryForSourceQuery == null) {
                logger.info("BinaryForSourceQueryImpl is null. trying reflection.");
                object2 = null;
                try {
                    object2 = project.getClass().getDeclaredMethod("evaluator", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Exceptions.printStackTrace((Throwable)noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    Exceptions.printStackTrace((Throwable)securityException);
                }
                if (object2 != null) {
                    try {
                        result = (PropertyEvaluator)((Method)object2).invoke((Object)project, new Object[0]);
                        object = result.getProperty("build.classes.dir");
                        if (object != null && (fileObject = project.getProjectDirectory().getFileObject((String)object)) == null) {
                            file = new File(FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)object);
                            fileObject = HibernateUtil.createBuildFolder(file);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Exceptions.printStackTrace((Throwable)illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Exceptions.printStackTrace((Throwable)illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Exceptions.printStackTrace((Throwable)invocationTargetException);
                    }
                } else {
                    logger.info("No method named 'evaluator() found in project : " + project);
                }
            } else {
                object2 = HibernateUtil.getSourceGroups(project);
                result = BinaryForSourceQuery.findBinaryRoots((URL)object2[0].getRootFolder().getURL());
                object = result.getRoots()[0];
                logger.info("Got build URL from the project sources : " + object);
                file = new File(((URL)object).getPath());
                fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    fileObject = HibernateUtil.createBuildFolder(file);
                }
            }
            if (fileObject == null) {
                object2 = HibernateUtil.getSourceGroups(project);
                result = BinaryForSourceQuery.findBinaryRoots((URL)object2[0].getRootFolder().getURL());
                object = result.getRoots()[0];
                logger.info("Got build URL from the project sources : " + object);
                file = new File(((URL)object).getPath());
                fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    fileObject = HibernateUtil.createBuildFolder(file);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        logger.info("Build Folder = " + fileObject);
        return fileObject;
    }

    public static List<String> getAllHibernateMappingsRelativeToSourcePath(Project project) {
        List<FileObject> list = HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-mapping+xml");
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        SourceGroup[] sourceGroupArray = HibernateUtil.getSourceGroups(project);
        block0: for (FileObject fileObject : list) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject2 = sourceGroup.getRootFolder();
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                if (string == null) continue;
                assert (string.length() > 0);
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList;
    }

    public static List<FileObject> getAllHibernateReverseEnggFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-reveng+xml");
    }

    public static List<TableColumn> getColumnsForTable(String string, HibernateConfiguration hibernateConfiguration) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        try {
            Connection connection = HibernateUtil.getJDBCConnection(hibernateConfiguration);
            if (connection != null) {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet2 = databaseMetaData.getPrimaryKeys(null, null, string);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (resultSet2.next()) {
                    arrayList2.add(resultSet2.getString("COLUMN_NAME"));
                }
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    TableColumn tableColumn = new TableColumn();
                    tableColumn.setColumnName(resultSetMetaData.getColumnName(i));
                    if (arrayList2.contains(tableColumn.getColumnName())) {
                        tableColumn.setPrimaryKey(true);
                    }
                    arrayList.add(tableColumn);
                }
            }
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        return arrayList;
    }

    public static String getDbConnectionDetails(HibernateConfiguration hibernateConfiguration, String string) {
        SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
        int n = 0;
        for (String string2 : sessionFactory.getProperty2()) {
            String string3;
            if (!(string3 = sessionFactory.getAttributeValue("Property2", n++, "name")).equals(string)) continue;
            return string2;
        }
        return "";
    }

    public static DatabaseConnection getDBConnection(HibernateConfiguration hibernateConfiguration) throws DatabaseException {
        try {
            DatabaseConnection[] databaseConnectionArray;
            String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
            String string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.url");
            String string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.username");
            String string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.password");
            if (string == null) {
                string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
            }
            if (string2 == null) {
                string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.url");
            }
            if (string3 == null) {
                string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.username");
            }
            if (string4 == null) {
                string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.password");
            }
            for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
                if (!databaseConnection.getDatabaseURL().equals(string2) || !databaseConnection.getUser().equals(string3)) continue;
                logger.info("Found pre-existing database connection.");
                return HibernateUtil.checkAndConnect(databaseConnection);
            }
            DatabaseConnection[] databaseConnectionArray2 = JDBCDriverManager.getDefault().getDrivers(string);
            if (databaseConnectionArray2.length == 0) {
                return null;
            }
            DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)databaseConnectionArray2[0], (String)string2, (String)string3, null, (String)string4, (boolean)true);
            ConnectionManager.getDefault().addConnection(databaseConnection);
            return HibernateUtil.checkAndConnect(databaseConnection);
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
            throw databaseException;
        }
    }

    private static DatabaseConnection checkAndConnect(final DatabaseConnection databaseConnection) {
        if (databaseConnection.getJDBCConnection() == null) {
            logger.info("Database Connection not established, connecting..");
            return (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

                public DatabaseConnection run() {
                    ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                    return databaseConnection;
                }
            });
        }
        logger.info("Database Connection is pre-established. Returning the conneciton.");
        return databaseConnection;
    }

    public static Connection getDirectDBConnection(HibernateConfiguration hibernateConfiguration) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
        String string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.url");
        String string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.username");
        String string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.password");
        if (string == null) {
            string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
        }
        if (string2 == null) {
            string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.url");
        }
        if (string3 == null) {
            string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.username");
        }
        if (string4 == null) {
            string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.password");
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
        Driver driver = (Driver)clazz.newInstance();
        Properties properties = new Properties();
        properties.setProperty("user", string3);
        properties.setProperty("password", string4);
        return driver.connect(string2, properties);
    }

    public static String getRelativeSourcePath(FileObject fileObject, FileObject fileObject2) {
        String string = "";
        try {
            String string2 = fileObject.getPath();
            String string3 = fileObject2.getPath();
            int n = string2.indexOf(string3);
            string = string2.substring(n + string3.length() + 1);
        }
        catch (Exception exception) {
            logger.info("exception while parsing relative path");
            Exceptions.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private static Connection getJDBCConnection(HibernateConfiguration hibernateConfiguration) throws DatabaseException {
        if (HibernateUtil.getDBConnection(hibernateConfiguration) == null) {
            return null;
        }
        return HibernateUtil.getDBConnection(hibernateConfiguration).getJDBCConnection();
    }

    public static List<SourceGroup> getJavaSourceGroups(Project project) {
        assert (project != null);
        SourceGroup[] sourceGroupArray = HibernateUtil.getSourceGroups(project);
        Set<SourceGroup> set = HibernateUtil.getTestSourceGroups(sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            if (set.contains(sourceGroup)) continue;
            arrayList.add(sourceGroup);
        }
        return arrayList;
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map = HibernateUtil.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            hashSet.addAll(HibernateUtil.getTestTargets(sourceGroup, map));
        }
        return hashSet;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        if (sourceGroupArray.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<FileObject, SourceGroup> hashMap = new HashMap<FileObject, SourceGroup>(2 * sourceGroupArray.length);
        for (SourceGroup sourceGroup : sourceGroupArray) {
            hashMap.put(sourceGroup.getRootFolder(), sourceGroup);
        }
        return hashMap;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map<FileObject, SourceGroup> map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return Collections.emptyList();
        }
        List<FileObject> list = HibernateUtil.getFileObjects(uRLArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(list.size());
        for (FileObject fileObject : list) {
            SourceGroup sourceGroup2 = map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(uRLArray.length);
        for (URL uRL : uRLArray) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            Exceptions.printStackTrace((Throwable)new IllegalStateException("No FileObject found for the following URL: " + uRL));
        }
        return arrayList;
    }

    private static List<FileObject> searchSourceFiles(Project project, String string, String string2) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        Set<FileObject> set = HibernateUtil.createFoldersToSourceGroupsMap(HibernateUtil.getSourceGroups(project)).keySet();
        try {
            QuerySupport querySupport = QuerySupport.forRoots((String)"org-netbeans-modules-jumpto-file-FileIndexer", (int)1, (FileObject[])set.toArray(new FileObject[set.size()]));
            Collection collection = querySupport.query("ci-file-name", string, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP, new String[0]);
            for (IndexResult indexResult : collection) {
                FileObject fileObject = indexResult.getFile();
                if (fileObject == null || !fileObject.isValid() || string2 != null && !string2.equals(FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{string2}))) continue;
                linkedList.add(fileObject);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            assert (false);
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, null, iOException);
            return Collections.emptyList();
        }
        return linkedList;
    }
}

