/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectStatement
extends SQLStatement {
    private final SQLStatementKind kind;
    int startOffset;
    int endOffset;
    private final List<List<String>> selectValues;
    private final FromClause fromClause;
    private final List<SelectStatement> subqueries;
    private final SortedMap<Integer, SelectContext> offset2Context;

    SelectStatement(SQLStatementKind sQLStatementKind, int n, int n2, List<List<String>> list, FromClause fromClause, List<SelectStatement> list2, SortedMap<Integer, SelectContext> sortedMap) {
        this.kind = sQLStatementKind;
        this.startOffset = n;
        this.endOffset = n2;
        this.selectValues = list;
        this.fromClause = fromClause;
        this.subqueries = list2;
        this.offset2Context = sortedMap;
    }

    @Override
    public SQLStatementKind getKind() {
        return this.kind;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public FromClause getTablesInEffect(int n) {
        ArrayList<SelectStatement> arrayList = new ArrayList<SelectStatement>();
        this.fillStatementPath(n, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return ((SelectStatement)arrayList.get(0)).getFromClause();
        }
        Collections.reverse(arrayList);
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (SelectStatement selectStatement : arrayList) {
            FromClause fromClause = selectStatement.getFromClause();
            if (fromClause == null) continue;
            hashSet.addAll(fromClause.getUnaliasedTableNames());
            for (Map.Entry<String, QualIdent> entry : fromClause.getAliasedTableNames().entrySet()) {
                String string = entry.getKey();
                QualIdent qualIdent = entry.getValue();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, qualIdent);
            }
        }
        return new FromClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    public List<List<String>> getSelectValues() {
        return this.selectValues;
    }

    public List<SelectStatement> getSubqueries() {
        return this.subqueries;
    }

    public SelectContext getContextAtOffset(int n) {
        SelectContext selectContext = null;
        for (Map.Entry<Integer, SelectContext> entry : this.offset2Context.entrySet()) {
            if (n < entry.getKey()) break;
            selectContext = entry.getValue();
        }
        return selectContext;
    }

    private void fillStatementPath(int n, List<SelectStatement> list) {
        if (n >= this.startOffset && n <= this.endOffset) {
            list.add(this);
            for (SelectStatement selectStatement : this.subqueries) {
                selectStatement.fillStatementPath(n, list);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectContext {
        SELECT,
        FROM,
        JOIN_CONDITION,
        WHERE,
        GROUP_BY,
        HAVING,
        ORDER_BY;

    }
}

