/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class KenaiProjectsListRenderer
extends JPanel {
    private URL url;
    private JButton detailsButton;
    private JTextArea projectDescLabel;
    private JLabel projectNameLabel;
    private JPanel repoPanel;
    private JLabel repoPathLabel;
    private JLabel repoTypeLabel;
    private JLabel tagsLabel;

    public KenaiProjectsListRenderer(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.initComponents();
        KenaiSearchPanel.KenaiProjectSearchInfo kenaiProjectSearchInfo = (KenaiSearchPanel.KenaiProjectSearchInfo)object;
        this.projectNameLabel.setText("<html><b>" + kenaiProjectSearchInfo.kenaiProject.getDisplayName() + " (" + kenaiProjectSearchInfo.kenaiProject.getName() + ")</b></html>");
        if (kenaiProjectSearchInfo.kenaiFeature != null) {
            this.repoPathLabel.setText(kenaiProjectSearchInfo.kenaiFeature.getLocation());
            this.repoTypeLabel.setText("(" + kenaiProjectSearchInfo.kenaiFeature.getService() + ")");
        }
        try {
            String string = kenaiProjectSearchInfo.kenaiProject.getDescription();
            string = string.replaceAll("\n+", " ");
            string = string.replaceAll("\t+", " ");
            this.projectDescLabel.setText(string);
            this.projectDescLabel.setRows(kenaiProjectSearchInfo.kenaiProject.getDescription().length() / 100 + 1);
            this.tagsLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.tagsLabel.text") + " " + kenaiProjectSearchInfo.kenaiProject.getTags());
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.projectDescLabel.setBackground(jList.getSelectionBackground());
            this.repoPanel.setBackground(jList.getSelectionBackground());
        } else if (n % 2 == 0) {
            this.setBackground(new Color(225, 225, 225));
            this.projectDescLabel.setBackground(new Color(225, 225, 225));
            this.repoPanel.setBackground(new Color(225, 225, 225));
        } else {
            this.setBackground(jList.getBackground());
            this.projectDescLabel.setBackground(jList.getBackground());
            this.repoPanel.setBackground(jList.getBackground());
        }
        this.url = kenaiProjectSearchInfo.kenaiProject.getWebLocation();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.tagsLabel = new JLabel();
        this.projectDescLabel = new JTextArea();
        this.detailsButton = new LinkButton(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.detailsLabel.text"), (ActionListener)new URLDisplayer());
        this.repoPanel = new JPanel();
        this.repoPathLabel = new JLabel();
        this.repoTypeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.projectNameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.tagsLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.tagsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 6, 0);
        this.add((Component)this.tagsLabel, gridBagConstraints);
        this.projectDescLabel.setLineWrap(true);
        this.projectDescLabel.setWrapStyleWord(true);
        this.projectDescLabel.setFocusable(false);
        this.projectDescLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 14);
        this.add((Component)this.projectDescLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.detailsButton, gridBagConstraints);
        this.repoPanel.setLayout(new GridBagLayout());
        this.repoPathLabel.setForeground(ColorManager.getDefault().getLinkColor());
        this.repoPathLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.repoPathLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.repoPanel.add((Component)this.repoPathLabel, gridBagConstraints);
        this.repoTypeLabel.setText(NbBundle.getMessage(KenaiProjectsListRenderer.class, (String)"KenaiProjectsListRenderer.repoTypeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.repoPanel.add((Component)this.repoTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.repoPanel, gridBagConstraints);
    }

    private class URLDisplayer
    implements ActionListener {
        private URLDisplayer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new URLDisplayerAction("", KenaiProjectsListRenderer.this.url).actionPerformed(actionEvent);
        }
    }
}

