/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NameAndLicenseWizardPanel;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanel;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewKenaiProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private transient int index;
    private Node activeNode;
    private boolean isShareExistingFolder;
    public static final String PROP_PRJ_NAME = "projectName";
    public static final String PROP_PRJ_TITLE = "projectTitle";
    public static final String PROP_PRJ_DESC = "projectDescription";
    public static final String PROP_PRJ_LICENSE = "projectLicense";
    public static final String PROP_SCM_TYPE = "projectSCMType";
    public static final String PROP_SCM_NAME = "projectSCMName";
    public static final String PROP_SCM_URL = "projectSCMUrl";
    public static final String PROP_SCM_LOCAL = "projectSCMLocal";
    public static final String PROP_ISSUES = "projectIssues";
    public static final String PROP_ISSUES_URL = "projectIssuesUrl";
    public static final String PROP_AUTO_COMMIT = "projectIssuesUrl";
    public static final String PROP_CREATE_CHAT = "projectCreateChat";
    public static final String PROP_EXC_ERR_MSG = "exceptionErrorMessage";
    public static final String NO_REPO = "none";
    public static final String NO_ISSUES = "none";
    private Logger logger = Logger.getLogger("org.netbeans.modules.kenai");

    NewKenaiProjectWizardIterator(Node node) {
        this.activeNode = node;
        this.isShareExistingFolder = true;
    }

    NewKenaiProjectWizardIterator() {
        this.isShareExistingFolder = false;
    }

    public Set<CreatedProjectInfo> instantiate(ProgressHandle progressHandle) throws IOException {
        String string;
        PasswordAuthentication passwordAuthentication;
        Boolean bl;
        String string2;
        String string3;
        block26: {
            String string4;
            progressHandle.start(6);
            string3 = (String)this.wizard.getProperty(PROP_PRJ_NAME);
            String string5 = (String)this.wizard.getProperty(PROP_PRJ_TITLE);
            String string6 = (String)this.wizard.getProperty(PROP_PRJ_DESC);
            String string7 = (String)this.wizard.getProperty(PROP_PRJ_LICENSE);
            String string8 = (String)this.wizard.getProperty(PROP_SCM_TYPE);
            String string9 = (String)this.wizard.getProperty(PROP_SCM_NAME);
            String string10 = (String)this.wizard.getProperty(PROP_SCM_URL);
            string2 = (String)this.wizard.getProperty(PROP_SCM_LOCAL);
            String string11 = (String)this.wizard.getProperty(PROP_ISSUES);
            String string12 = (String)this.wizard.getProperty("projectIssuesUrl");
            boolean bl2 = Boolean.valueOf((String)this.wizard.getProperty("projectIssuesUrl"));
            bl = (Boolean)this.wizard.getProperty(PROP_CREATE_CHAT);
            if ("subversion".equals(string8) && !Subversion.isClientAvailable((boolean)bl2)) {
                throw new IOException("SVN client unavailable");
            }
            try {
                progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingProject"), 1);
                this.logger.log(Level.FINE, "Creating Kenai Project - Name: " + string3 + ", Title: " + string5 + ", Description: " + string6 + ", License: " + string7);
                Kenai.getDefault().createProject(string3, string5, string6, new String[]{string7}, null);
            }
            catch (KenaiException kenaiException) {
                String string13 = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.projectCreationFailed"));
                ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string13);
                throw new IOException(string13);
            }
            boolean bl3 = false;
            if (!"none".equals(string8)) {
                try {
                    progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingRepo"), 2);
                    passwordAuthentication = this.getScmDisplayName(string8);
                    string = this.getScmDescription(string8);
                    string4 = "external_repository".equals(string8) ? string10 : null;
                    this.logger.log(Level.FINE, "Creating SCM Repository - Name: " + string9 + ", Type: " + string8 + ", Ext. URL: " + string10 + ", Local Folder: " + string2);
                    Kenai.getDefault().getProject(string3).createProjectFeature(string9, (String)((Object)passwordAuthentication), string, string8, null, string4, null);
                    bl3 = "subversion".equals(string8) || "mercurial".equals(string8);
                }
                catch (KenaiException kenaiException) {
                    String string14 = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repoCreationFailed"));
                    ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string14);
                    throw new IOException(string14);
                }
            } else {
                this.logger.log(Level.FINE, "SCM Repository creation skipped.");
            }
            if (!"none".equals(string11)) {
                try {
                    progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.creatingIssues"), 3);
                    passwordAuthentication = this.getIssuesDisplayName(string11);
                    string = this.getIssuesDescription(string11);
                    string4 = "external_issues".equals(string11) ? string12 : null;
                    this.logger.log(Level.FINE, "Creating Issue Tracking - Name: " + string11 + ", Ext. URL: " + string12);
                    Kenai.getDefault().getProject(string3).createProjectFeature(string3 + string11, (String)((Object)passwordAuthentication), string, string11, string4, null, null);
                }
                catch (KenaiException kenaiException) {
                    string = this.getErrorMessage(kenaiException, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.issuesCreationFailed"));
                    ((JComponent)this.current().getComponent()).putClientProperty(PROP_EXC_ERR_MSG, string);
                    throw new IOException(string);
                }
            } else {
                this.logger.log(Level.FINE, "Issue Tracking creation skipped.");
            }
            if (bl3) {
                try {
                    passwordAuthentication = Kenai.getDefault().getProject(string3).getFeatures(KenaiService.Type.SOURCE);
                    string = null;
                    string4 = null;
                    for (Object object : passwordAuthentication) {
                        if (!string9.equals(object.getName())) continue;
                        string = object.getLocation();
                        string4 = object.getService();
                    }
                    if (string == null) break block26;
                    progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCheckout"), 4);
                    this.logger.log(Level.FINE, "Checking out repository - Location: " + string + ", Local Folder: " + string2 + ", Service: " + string4);
                    PasswordAuthentication passwordAuthentication2 = Kenai.getDefault().getPasswordAuthentication();
                    if (passwordAuthentication2 == null) break block26;
                    File file = new File(string2);
                    if ("subversion".equals(string4)) {
                        try {
                            if (this.isShareExistingFolder) {
                                Object object;
                                String string15 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.initialRevision", (Object)string5);
                                object = new File(string2).getName();
                                String string16 = string.concat("/" + (String)object);
                                Subversion.mkdir((String)string16, (String)passwordAuthentication2.getUserName(), (String)new String(passwordAuthentication2.getPassword()), (String)string15);
                                Subversion.checkoutRepositoryFolder((String)string16, (String[])new String[]{"."}, (File)file, (String)passwordAuthentication2.getUserName(), (String)new String(passwordAuthentication2.getPassword()), (boolean)true, (boolean)false);
                                if (bl2) {
                                    progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProject.progress.repositoryCommit"), 5);
                                    Subversion.commit((File[])new File[]{file}, (String)passwordAuthentication2.getUserName(), (String)new String(passwordAuthentication2.getPassword()), (String)string15);
                                }
                            } else {
                                Subversion.checkoutRepositoryFolder((String)string, (String[])new String[]{"."}, (File)file, (String)passwordAuthentication2.getUserName(), (String)new String(passwordAuthentication2.getPassword()), (boolean)false);
                            }
                            break block26;
                        }
                        catch (IOException iOException) {
                            if ("SVN client unavailable".equals(iOException.getMessage())) {
                                // empty if block
                            }
                            throw iOException;
                        }
                    }
                    if ("mercurial".equals(string4)) {
                        Mercurial.cloneRepository((String)string, (File)file, (String)"", (String)"", (String)"", (String)passwordAuthentication2.getUserName(), (String)new String(passwordAuthentication2.getPassword()));
                    }
                }
                catch (KenaiException kenaiException) {
                    Exceptions.printStackTrace((Throwable)kenaiException);
                }
            }
        }
        if (bl.booleanValue()) {
            progressHandle.progress(NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_CreatingChatProgress"), 6);
            passwordAuthentication = Kenai.getDefault().getProject(string3).createProjectFeature(string3, NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomName", (Object)string3), NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"CTL_ChatRoomDescription", (Object)string3), "instant_messenger", null, null, null);
        }
        passwordAuthentication = new HashSet();
        try {
            string = Kenai.getDefault().getProject(string3);
            Dashboard.getDefault().addProject(new ProjectHandleImpl((KenaiProject)string), true);
            passwordAuthentication.add(new CreatedProjectInfo((KenaiProject)string, string2));
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        progressHandle.finish();
        return passwordAuthentication;
    }

    public Set<?> instantiate() throws IOException {
        assert (false);
        return null;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.panels = this.getPanels();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.name");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String getErrorMessage(KenaiException kenaiException, String string) {
        String string2 = null;
        if (kenaiException instanceof KenaiException) {
            KenaiException kenaiException2 = kenaiException;
            Map map = kenaiException2.getErrors();
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string + " ");
            }
            boolean bl = false;
            for (String string3 : map.keySet()) {
                stringBuffer.append((String)map.get(string3) + ". ");
                bl = true;
            }
            string2 = bl ? stringBuffer.substring(0, stringBuffer.length() - 2) : stringBuffer.toString();
        } else {
            string2 = kenaiException.getLocalizedMessage();
        }
        return string2;
    }

    private String getScmDisplayName(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionRepository");
        } else if ("mercurial".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialRepository");
        } else if ("external_repository".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalRepository");
        }
        return string2;
    }

    private String getScmDescription(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SourceCodeRepository");
        if ("subversion".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.SubversionSourceCodeRepository");
        } else if ("mercurial".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.MercurialSourceCodeRepository");
        } else if ("external_repository".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalSourceCodeRepository");
        }
        return string2;
    }

    private String getIssuesDisplayName(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.Bugzilla");
        } else if ("jira".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRA");
        } else if ("external_issues".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.External");
        }
        return string2;
    }

    private String getIssuesDescription(String string) {
        String string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.IssueTracking");
        if ("bugzilla".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.BugzillaIssueTracking");
        } else if ("jira".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.JIRAIssueTracking");
        } else if ("external_issues".equals(string)) {
            string2 = NbBundle.getMessage(NewKenaiProjectWizardIterator.class, (String)"NewKenaiProjectWizardIterator.ExternalIssueTracking");
        }
        return string2;
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private WizardDescriptor.Panel[] createPanels() {
        if (this.isShareExistingFolder) {
            return new WizardDescriptor.Panel[]{new NameAndLicenseWizardPanel(this.activeNode)};
        }
        return new WizardDescriptor.Panel[]{new NameAndLicenseWizardPanel(), new SourceAndIssuesWizardPanel()};
    }

    public static class CreatedProjectInfo {
        public KenaiProject project;
        public String localRepoPath;

        public CreatedProjectInfo(KenaiProject kenaiProject, String string) {
            this.project = kenaiProject;
            this.localRepoPath = string;
        }
    }
}

