/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.treelist.AsynchronousLeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingNode
extends AsynchronousLeafNode<MessagingHandle>
implements PropertyChangeListener {
    private final ProjectHandle project;
    private MessagingHandle messaging;
    private JPanel panel;
    private List<JLabel> labels = new ArrayList<JLabel>(5);
    private List<LinkButton> buttons = new ArrayList<LinkButton>(3);
    private final Object LOCK = new Object();

    public MessagingNode(TreeListNode treeListNode, ProjectHandle projectHandle) {
        super(treeListNode, null);
        this.project = projectHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure(JComponent jComponent, Color color, Color color2, boolean bl, boolean bl2) {
        if (this.panel == jComponent) {
            Object object = this.LOCK;
            synchronized (object) {
                for (JLabel jComponent2 : this.labels) {
                    jComponent2.setForeground(color);
                }
                for (LinkButton linkButton : this.buttons) {
                    linkButton.setForeground(color, bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent createComponent(MessagingHandle messagingHandle) {
        MessagingAccessor messagingAccessor = MessagingAccessor.getDefault();
        if (null != this.messaging) {
            this.messaging.removePropertyChangeListener(this);
        }
        this.messaging = messagingHandle;
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            JLabel jLabel = null;
            LinkButton linkButton = null;
            int n = this.messaging.getOnlineCount();
            if (n >= 0) {
                jLabel = new TreeLabel(NbBundle.getMessage(MessagingNode.class, (String)"LBL_OnlineCount", (Object)this.messaging.getOnlineCount()));
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new TreeLabel("(");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                linkButton = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_MessageCount", (Object)this.messaging.getMessageCount()), messagingAccessor.getOpenMessagesAction(this.project));
                this.buttons.add(linkButton);
                this.panel.add((Component)linkButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new TreeLabel(")");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new TreeLabel("|");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            } else if (n == -2) {
                linkButton = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_CreateChat", (Object)this.messaging.getMessageCount()), messagingAccessor.getCreateChatAction(this.project));
                this.buttons.add(linkButton);
                this.panel.add((Component)linkButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new TreeLabel("|");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            } else if (n == -3) {
                jLabel = new JLabel(NbBundle.getMessage(MessagingNode.class, (String)"LBL_ConnectionFailed"));
                jLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/error.png")));
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new JLabel("(");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                linkButton = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_Retry"), messagingAccessor.getReconnectAction(this.project));
                this.buttons.add(linkButton);
                this.panel.add((Component)linkButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new JLabel(")");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                jLabel = new JLabel("|");
                this.labels.add(jLabel);
                this.panel.add((Component)jLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            }
            linkButton = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_OpenWiki"), ProjectAccessor.getDefault().getOpenWikiAction(this.project));
            this.buttons.add(linkButton);
            this.panel.add((Component)linkButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            jLabel = new TreeLabel("|");
            this.labels.add(jLabel);
            this.panel.add((Component)jLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            linkButton = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_OpenDownloads"), ProjectAccessor.getDefault().getOpenDownloadsAction(this.project));
            this.buttons.add(linkButton);
            this.panel.add((Component)linkButton, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.messaging.addPropertyChangeListener(this);
        return this.panel;
    }

    @Override
    protected MessagingHandle load() {
        MessagingAccessor messagingAccessor = MessagingAccessor.getDefault();
        return messagingAccessor.getMessaging(this.project);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh();
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (null != this.messaging) {
            this.messaging.removePropertyChangeListener(this);
        }
    }
}

