/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.spi;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.ui.KenaiLoginTask;
import org.netbeans.modules.kenai.ui.LoginPanel;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.Scrambler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class UIUtils {
    private static final String KENAI_PASSWORD_PREF;
    private static final String KENAI_USERNAME_PREF;
    public static final String ONLINE_STATUS_PREF;

    public static void waitStartupFinished() {
        KenaiLoginTask.waitStartupFinished();
    }

    private UIUtils() {
    }

    @Deprecated
    public static final JTextPane createHTMLPane() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        StyleSheet styleSheet = ((HTMLDocument)jTextPane.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule(".green {color: green;}");
        styleSheet.addRule(".red {color: red;");
        jTextPane.setEditable(false);
        jTextPane.setBackground(UIManager.getColor("TextPane.background"));
        return jTextPane;
    }

    @Deprecated
    public static final JButton createFocusableHyperlink(String string) {
        final JButton jButton = new JButton("<html><body><a href=\"foo\">" + string + "</a>");
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setOpaque(false);
        jButton.addMouseListener(new MouseAdapter(){
            private Cursor oldCursor;

            public void mouseEntered(MouseEvent mouseEvent) {
                this.oldCursor = jButton.getCursor();
                jButton.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setCursor(this.oldCursor);
            }
        });
        return jButton;
    }

    @Deprecated
    public static synchronized boolean tryLogin() {
        if (Kenai.getDefault().getPasswordAuthentication() != null) {
            return true;
        }
        Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        String string = preferences.get(ONLINE_STATUS_PREF, "false");
        if (!Boolean.parseBoolean(string)) {
            return false;
        }
        String string2 = preferences.get(KENAI_USERNAME_PREF, null);
        if (string2 == null) {
            return false;
        }
        String string3 = preferences.get(KENAI_PASSWORD_PREF, null);
        try {
            Kenai.getDefault().login(string2, Scrambler.getInstance().descramble(string3).toCharArray());
        }
        catch (KenaiException kenaiException) {
            return false;
        }
        return true;
    }

    public static boolean showLogin() {
        final LoginPanel loginPanel = new LoginPanel();
        final Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        final String string = NbBundle.getMessage(Utilities.class, (String)"CTL_Login");
        String string2 = NbBundle.getMessage(Utilities.class, (String)"CTL_Cancel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)loginPanel, NbBundle.getMessage(Utilities.class, (String)"CTL_LoginToKenai"), true, new Object[]{string, string2}, (Object)string, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(string)) {
                    loginPanel.showProgress();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                Kenai.getDefault().login(loginPanel.getUsername(), loginPanel.getPassword());
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        Container container;
                                        JRootPane jRootPane = loginPanel.getRootPane();
                                        if (jRootPane != null && (container = jRootPane.getParent()) != null) {
                                            container.setVisible(false);
                                        }
                                    }
                                });
                            }
                            catch (KenaiException kenaiException) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        loginPanel.showError(kenaiException);
                                    }
                                });
                            }
                        }
                    });
                    if (loginPanel.isStorePassword()) {
                        preferences.put(KENAI_USERNAME_PREF, loginPanel.getUsername());
                        preferences.put(KENAI_PASSWORD_PREF, Scrambler.getInstance().scramble(new String(loginPanel.getPassword())));
                    } else {
                        preferences.remove(KENAI_USERNAME_PREF);
                        preferences.remove(KENAI_PASSWORD_PREF);
                    }
                } else {
                    loginPanel.putClientProperty("cancel", "true");
                    loginPanel.getRootPane().getParent().setVisible(false);
                }
            }
        });
        dialogDescriptor.setClosingOptions(new Object[]{string2});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        String string3 = preferences.get(KENAI_USERNAME_PREF, null);
        String string4 = preferences.get(KENAI_PASSWORD_PREF, null);
        if (string3 != null && string4 != null) {
            loginPanel.setUsername(string3);
            loginPanel.setPassword(Scrambler.getInstance().descramble(string4).toCharArray());
        }
        dialog.pack();
        dialog.setResizable(false);
        loginPanel.clearStatus();
        dialog.setVisible(true);
        return loginPanel.getClientProperty("cancel") == null;
    }

    static {
        String string = System.getProperty("kenai.com.url", "https://kenai.com");
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        KENAI_USERNAME_PREF = string2 + ".username";
        KENAI_PASSWORD_PREF = string2 + ".password";
        ONLINE_STATUS_PREF = string2 + ".online";
    }
}

