/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.explorer.propertysheet.PropertySheet;

final class RendererPanel
extends JPanel {
    static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
    private static final Border NO_FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorManager.getDefault().getDefaultBackground()), BorderFactory.createEmptyBorder(1, 1, 0, 1));
    private static Border INNER_BORDER;
    private static Color expandableRootBackground;
    private static Color expandableRootForeground;
    private static Color expandableRootSelectedBackground;
    private static Color expandableRootSelectedForeground;
    private static final Icon EMPTY_ICON;
    private final boolean isRoot;
    private final TreeListNode node;
    private JButton expander;

    public RendererPanel(final TreeListNode treeListNode) {
        super(new BorderLayout());
        if (null == expandableRootBackground) {
            RendererPanel.deriveColorsAndMargin();
        }
        this.node = treeListNode;
        this.isRoot = treeListNode.getParent() == null;
        this.setOpaque(!this.isRoot || !isAqua || !treeListNode.isExpandable());
        if (treeListNode.isExpandable()) {
            this.expander = new LinkButton(EMPTY_ICON, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    treeListNode.setExpanded(!treeListNode.isExpanded());
                }
            });
            this.add((Component)this.expander, "West");
        } else if (!this.isRoot) {
            this.add((Component)new JLabel(new EmptyIcon()), "West");
        }
    }

    public void configure(Color color, Color color2, boolean bl, boolean bl2, int n, int n2) {
        if (this.isRoot && this.node.isExpandable()) {
            color = bl ? expandableRootSelectedForeground : expandableRootForeground;
            color2 = bl ? expandableRootSelectedBackground : expandableRootBackground;
        }
        JComponent jComponent = this.node.getComponent(color, color2, bl, bl2);
        if (this.node.isExpandable() || !this.isRoot) {
            jComponent.setBorder(INNER_BORDER);
        }
        this.add((Component)jComponent, "Center");
        this.setBackground(color2);
        this.setForeground(color);
        if (null != this.expander) {
            this.expander.setIcon(this.node.isExpanded() ? RendererPanel.getExpandedIcon() : RendererPanel.getCollapsedIcon());
            this.expander.setPressedIcon(this.expander.getIcon());
        }
        Border border = null;
        if (bl2) {
            if (bl) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        }
        if (null == border) {
            border = NO_FOCUS_BORDER;
        }
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 4 + n * n2 / 2, 3, 4));
        this.setBorder(border);
    }

    public void paintComponent(Graphics graphics) {
        if (this.isRoot && isAqua && this.node.isExpandable()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight() / 2, this.getBackground()));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
        } else {
            super.paintComponent(graphics);
        }
    }

    private static void deriveColorsAndMargin() {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        new PropertySheet();
        Color color = UIManager.getColor("control");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        boolean bl = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        boolean bl2 = "Nimbus".equals(UIManager.getLookAndFeel().getID());
        expandableRootBackground = UIManager.getColor("PropSheet.setBackground");
        expandableRootSelectedBackground = UIManager.getColor("PropSheet.selectedSetBackground");
        if (bl2 || isGtk) {
            expandableRootBackground = UIManager.getColor("Menu.background");
            expandableRootSelectedBackground = UIManager.getColor("Tree.selectionBackground");
        }
        if (expandableRootBackground == null && expandableRootBackground == null) {
            n3 = RendererPanel.adjustColorComponent(color.getRed(), -25, -25);
            n2 = RendererPanel.adjustColorComponent(color.getGreen(), -25, -25);
            n = RendererPanel.adjustColorComponent(color.getBlue(), -25, -25);
            expandableRootBackground = new Color(n3, n2, n);
        }
        if (isAqua) {
            expandableRootBackground = new Color((int)Math.max(0.0, (double)expandableRootBackground.getRed() * 0.85), (int)Math.max(0.0, (double)expandableRootBackground.getGreen() * 0.85), (int)Math.max(0.0, (double)expandableRootBackground.getBlue() * 0.85));
        }
        if (expandableRootSelectedBackground == null) {
            Serializable serializable2 = serializable = bl ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (serializable == null) {
                serializable = Color.BLUE;
            }
            n3 = RendererPanel.adjustColorComponent(((Color)serializable).getRed(), -25, -25);
            n2 = RendererPanel.adjustColorComponent(((Color)serializable).getGreen(), -25, -25);
            n = RendererPanel.adjustColorComponent(((Color)serializable).getBlue(), -25, -25);
            expandableRootSelectedBackground = new Color(n3, n2, n);
        }
        expandableRootForeground = UIManager.getColor("PropSheet.setForeground");
        if (bl2 || isGtk) {
            expandableRootForeground = new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        if (expandableRootForeground == null && (expandableRootForeground = UIManager.getColor("Table.foreground")) == null && (expandableRootForeground = UIManager.getColor("textText")) == null) {
            expandableRootForeground = Color.BLACK;
        }
        if ((expandableRootSelectedForeground = UIManager.getColor("PropSheet.selectedSetForeground")) == null && (expandableRootSelectedForeground = UIManager.getColor("Table.selectionForeground")) == null) {
            expandableRootSelectedForeground = Color.WHITE;
        }
        if (isAqua) {
            expandableRootSelectedForeground = Color.black;
        }
        serializable = (Integer)UIManager.get("netbeans.ps.iconmargin");
        int n4 = 0;
        n4 = serializable != null ? (Integer)serializable : (bl ? 4 : 0);
        INNER_BORDER = BorderFactory.createEmptyBorder(0, n4, 0, 0);
    }

    private static int adjustColorComponent(int n, int n2, int n3) {
        n = n > 128 ? (n -= n2) : (n += n3);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    static Icon getExpandedIcon() {
        Icon icon = UIManager.getIcon(isGtk ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
        assert (icon != null) : "no Tree.expandedIcon found";
        return icon;
    }

    static Icon getCollapsedIcon() {
        Icon icon = UIManager.getIcon(isGtk ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
        assert (icon != null) : "no Tree.collapsedIcon found";
        return icon;
    }

    static {
        expandableRootBackground = null;
        expandableRootForeground = null;
        expandableRootSelectedBackground = null;
        expandableRootSelectedForeground = null;
        EMPTY_ICON = new EmptyIcon();
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return RendererPanel.getExpandedIcon().getIconWidth();
        }

        public int getIconHeight() {
            return RendererPanel.getExpandedIcon().getIconHeight();
        }
    }
}

