/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.treelist.TreeListListener;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeListModel
extends AbstractListModel
implements TreeListListener {
    private final ArrayList<TreeListNode> nodes = new ArrayList(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            return this.nodes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int n) {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            if (n < 0 || n >= this.nodes.size()) {
                return null;
            }
            return this.nodes.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(int n, TreeListNode treeListNode) {
        int n2 = -1;
        int n3 = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            int n4;
            if (n < 0 || n >= this.nodes.size()) {
                this.nodes.add(treeListNode);
            } else {
                this.nodes.add(n, treeListNode);
            }
            n2 = n4 = this.nodes.indexOf(treeListNode);
            if (treeListNode.isExpanded()) {
                n3 = this.addNodes(n4 + 1, treeListNode.getChildren()) - 1;
            }
            treeListNode.setListener(this);
        }
        if (n2 >= 0) {
            if (n3 < n2) {
                n3 = n2;
            }
            this.fireIntervalAdded(this, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(TreeListNode treeListNode) {
        int n = -1;
        int n2 = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            n = this.nodes.indexOf(treeListNode);
            if (n < 0) {
                treeListNode.dispose();
                return;
            }
            ArrayList<TreeListNode> arrayList2 = this.findDescendants(treeListNode);
            if (null == arrayList2) {
                arrayList2 = new ArrayList(1);
            }
            arrayList2.add(0, treeListNode);
            n2 = this.nodes.indexOf(arrayList2.get(arrayList2.size() - 1));
            for (TreeListNode treeListNode2 : arrayList2) {
                treeListNode2.dispose();
            }
            this.nodes.removeAll(arrayList2);
        }
        if (n >= 0) {
            this.fireIntervalRemoved(this, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            for (TreeListNode treeListNode : this.nodes) {
                treeListNode.dispose();
            }
            this.nodes.clear();
        }
        this.fireIntervalRemoved(this, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeListNode> getRootNodes() {
        ArrayList<TreeListNode> arrayList = new ArrayList<TreeListNode>(this.getSize());
        ArrayList<TreeListNode> arrayList2 = this.nodes;
        synchronized (arrayList2) {
            for (TreeListNode treeListNode : this.nodes) {
                if (null != treeListNode.getParent()) continue;
                arrayList.add(treeListNode);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(TreeListNode treeListNode) {
        int n = -1;
        int n2 = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            ArrayList<TreeListNode> arrayList2 = this.findDescendants(treeListNode);
            if (null == arrayList2) {
                return;
            }
            n = this.nodes.indexOf(arrayList2.get(0));
            n2 = this.nodes.indexOf(arrayList2.get(arrayList2.size() - 1));
            for (TreeListNode treeListNode2 : arrayList2) {
                treeListNode2.dispose();
            }
            this.nodes.removeAll(arrayList2);
        }
        if (n >= 0) {
            this.fireIntervalRemoved(this, n, n2);
        }
    }

    private ArrayList<TreeListNode> findDescendants(TreeListNode treeListNode) {
        TreeListNode treeListNode2;
        ArrayList<TreeListNode> arrayList = null;
        int n = this.nodes.indexOf(treeListNode);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < this.nodes.size() && (treeListNode2 = this.nodes.get(i)).isDescendantOf(treeListNode); ++i) {
            if (null == arrayList) {
                arrayList = new ArrayList<TreeListNode>(20);
            }
            arrayList.add(treeListNode2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildrenOf(TreeListNode treeListNode) {
        int n = -1;
        int n2 = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            n = this.nodes.indexOf(treeListNode);
            if (n < 0) {
                return;
            }
            n2 = this.addNodes(++n, treeListNode.getChildren()) - 1;
        }
        if (n >= 0) {
            if (n2 < n) {
                n2 = n;
            }
            this.fireIntervalAdded(this, n, n2);
        }
    }

    private int addNodes(int n, List<TreeListNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            TreeListNode treeListNode = list.get(i);
            if (this.nodes.contains(treeListNode)) continue;
            treeListNode.setListener(this);
            this.nodes.add(n++, treeListNode);
            if (!treeListNode.isExpanded()) continue;
            n = this.addNodes(n, treeListNode.getChildren());
        }
        return n;
    }

    @Override
    public void childrenRemoved(TreeListNode treeListNode) {
        this.removeChildrenOf(treeListNode);
    }

    @Override
    public void childrenAdded(TreeListNode treeListNode) {
        this.addChildrenOf(treeListNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentChanged(TreeListNode treeListNode) {
        int n = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            n = this.nodes.indexOf(treeListNode);
        }
        if (n >= 0) {
            this.fireContentsChanged(this, n, n);
        }
    }

    @Override
    protected void fireContentsChanged(final Object object, final int n, final int n2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeListModel.super.fireContentsChanged(object, n, n2);
                }
            });
        } else {
            super.fireContentsChanged(object, n, n2);
        }
    }

    @Override
    protected void fireIntervalAdded(final Object object, final int n, final int n2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeListModel.super.fireIntervalAdded(object, n, n2);
                }
            });
        } else {
            super.fireIntervalAdded(object, n, n2);
        }
    }

    @Override
    protected void fireIntervalRemoved(final Object object, final int n, final int n2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeListModel.super.fireIntervalRemoved(object, n, n2);
                }
            });
        } else {
            super.fireIntervalRemoved(object, n, n2);
        }
    }
}

