/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectUtils {
    private static final String CANNOT_FIND_SERVLET_MSG = NbBundle.getMessage(WebProjectUtils.class, (String)"WebProjectUtils_CannotFindServletMsg");
    private static final String CANNOT_FIND_SERVLET_CLASS_MSG = NbBundle.getMessage(WebProjectUtils.class, (String)"WebProjectUtils_CannotFindServletClassMsg");
    private static final String CANNOT_FIND_FILTER_CLASS_MSG = NbBundle.getMessage(WebProjectUtils.class, (String)"WebProjectUtils_CannotFindFilterClassMsg");
    private static final String CANNOT_FIND_LISTENER_CLASS_MSG = NbBundle.getMessage(WebProjectUtils.class, (String)"WebProjectUtils_CannotFindListenerClassMsg");
    private static final Map<ClientUtils.SourceCodeSelection, String> jspClass2NameMap = new HashMap<ClientUtils.SourceCodeSelection, String>();
    private static final String[][] jspServletMethods = new String[][]{{"_jspService", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"}};

    public static Document getDeploymentDescriptorDocument(FileObject fileObject) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    StringReader stringReader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource inputSource = new InputSource(stringReader);
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
            });
            document = documentBuilder.parse(FileUtil.toFile((FileObject)fileObject));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    public static Collection<Document> getDeploymentDescriptorDocuments(Project project, boolean bl) {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (FileObject fileObject : WebProjectUtils.getDeploymentDescriptorFileObjects(project, bl)) {
            arrayList.add(WebProjectUtils.getDeploymentDescriptorDocument(fileObject));
        }
        return arrayList;
    }

    public static Collection<FileObject> getDeploymentDescriptorFileObjects(Project project, boolean bl) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (WebModule webModule : WebProjectUtils.getWebModules(project, bl)) {
            arrayList.add(webModule.getDeploymentDescriptor());
        }
        return arrayList;
    }

    public static Collection<FileObject> getDocumentBaseFileObjects(Project project, boolean bl) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (WebModule webModule : WebProjectUtils.getWebModules(project, bl)) {
            arrayList.add(webModule.getDocumentBase());
        }
        return arrayList;
    }

    public static Collection<File> getDocumentBaseFiles(Project project, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileObject fileObject : WebProjectUtils.getDocumentBaseFileObjects(project, bl)) {
            arrayList.add(FileUtil.toFile((FileObject)fileObject));
        }
        return arrayList;
    }

    public static ArrayList[] getFilterClasses(Document document) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        NodeList nodeList = WebProjectUtils.getFilters(document);
        NodeList nodeList2 = WebProjectUtils.getFilterMappings(document);
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < nodeList2.getLength(); ++n) {
            string = WebProjectUtils.getElementContent((Element)nodeList2.item(n), "filter-name");
            if (string == null || vector.contains(string)) continue;
            vector.add(string);
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            string = WebProjectUtils.getElementContent((Element)nodeList.item(n), "filter-name");
            String string2 = WebProjectUtils.getElementContent((Element)nodeList.item(n), "filter-class");
            if (string != null && string2 != null && vector.contains(string)) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
                continue;
            }
            if (arrayList2.contains(string2)) continue;
            arrayList2.add(string2);
        }
        return new ArrayList[]{arrayList, arrayList2};
    }

    public static NodeList getFilterMappings(Document document) {
        return document.getElementsByTagName("filter-mapping");
    }

    public static NodeList getFilters(Document document) {
        return document.getElementsByTagName("filter");
    }

    public static boolean isHttpServlet(FileObject fileObject) {
        return SourceUtils.isInstanceOf((FileObject)fileObject, (String)"javax.servlet.http.HttpServlet");
    }

    public static boolean isJSP(FileObject fileObject) {
        return "jsp".equals(fileObject.getExt());
    }

    public static String getJSPFileContext(Project project, FileObject fileObject, boolean bl) {
        Collection<FileObject> collection = WebProjectUtils.getDocumentBaseFileObjects(project, bl);
        String string = null;
        for (FileObject fileObject2 : collection) {
            String string2;
            if (fileObject2 == null || (string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject)) == null || string != null && string.length() <= string2.length()) continue;
            string = string2;
        }
        return string;
    }

    public static ClientUtils.SourceCodeSelection getJSPFileRootMethod(Project project, FileObject fileObject) {
        return WebProjectUtils.getJSPMethodSignature(project, fileObject);
    }

    public static ClientUtils.SourceCodeSelection getJSPMethodSignature(Project project, FileObject fileObject) {
        String string = WebProjectUtils.getJSPPseudoServletClass(project, fileObject);
        if (string == null) {
            Profiler.getDefault().log(16, MessageFormat.format(CANNOT_FIND_SERVLET_MSG, FileUtil.toFile((FileObject)fileObject).getPath()));
            return null;
        }
        return WebProjectUtils.getJSPMethodSignature(string);
    }

    public static ClientUtils.SourceCodeSelection getJSPMethodSignature(String string) {
        return new ClientUtils.SourceCodeSelection(string, jspServletMethods[0][0], jspServletMethods[0][1]);
    }

    public static Set<ClientUtils.SourceCodeSelection> getJSPMethodSignatures(Project project, boolean bl) {
        HashSet<ClientUtils.SourceCodeSelection> hashSet = new HashSet<ClientUtils.SourceCodeSelection>();
        Collection<FileObject> collection = WebProjectUtils.getDocumentBaseFileObjects(project, bl);
        if (collection == null || collection.isEmpty()) {
            return hashSet;
        }
        for (FileObject fileObject : collection) {
            int n = fileObject.getPath().length();
            ArrayList arrayList = WebProjectUtils.getJSPs(fileObject);
            for (FileObject fileObject2 : arrayList) {
                ClientUtils.SourceCodeSelection sourceCodeSelection = WebProjectUtils.getJSPMethodSignature(project, fileObject2);
                if (sourceCodeSelection == null) continue;
                jspClass2NameMap.put(sourceCodeSelection, fileObject2.getPath().substring(n));
                hashSet.add(sourceCodeSelection);
            }
        }
        return hashSet;
    }

    public static String getJSPPath(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        return jspClass2NameMap.get(sourceCodeSelection);
    }

    public static String getJSPPseudoServletClass(Project project, FileObject fileObject) {
        String string = JSPServletFinder.findJSPServletFinder((FileObject)fileObject).getServletResourcePath(WebProjectUtils.getJSPFileContext(project, fileObject, true));
        if (string == null) {
            return null;
        }
        String string2 = string.substring(0, string.length() - ".java".length()).replace('/', '.');
        return string2;
    }

    public static ClientUtils.SourceCodeSelection[] getJSPRootMethods(Project project, boolean bl) {
        Set<ClientUtils.SourceCodeSelection> set = WebProjectUtils.getJSPMethodSignatures(project, bl);
        if (set == null) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        return set.toArray(new ClientUtils.SourceCodeSelection[set.size()]);
    }

    public static ArrayList getJSPs(FileObject fileObject) {
        ArrayList arrayList = new ArrayList();
        if (fileObject.isFolder()) {
            WebProjectUtils.searchForJSPs(fileObject, arrayList);
        }
        return arrayList;
    }

    public static ArrayList getListenerClasses(Document document) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = WebProjectUtils.getListeners(document);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = WebProjectUtils.getElementContent((Element)nodeList.item(i), "listener-class");
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static NodeList getListeners(Document document) {
        return document.getElementsByTagName("listener");
    }

    public static boolean isMappedServlet(FileObject fileObject, Project project, boolean bl) {
        Collection<Document> collection = WebProjectUtils.getDeploymentDescriptorDocuments(project, bl);
        for (Document document : collection) {
            if (WebProjectUtils.getServletMapping(fileObject, document) == null) continue;
            return true;
        }
        return false;
    }

    public static ArrayList[] getServletClasses(Document document) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        NodeList nodeList = WebProjectUtils.getServlets(document);
        NodeList nodeList2 = WebProjectUtils.getServletMappings(document);
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < nodeList2.getLength(); ++n) {
            string = WebProjectUtils.getElementContent((Element)nodeList2.item(n), "servlet-name");
            if (string == null || vector.contains(string)) continue;
            vector.add(string);
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            string = WebProjectUtils.getElementContent((Element)nodeList.item(n), "servlet-name");
            String string2 = WebProjectUtils.getElementContent((Element)nodeList.item(n), "servlet-class");
            if (string != null && string2 != null && vector.contains(string)) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
                continue;
            }
            if (arrayList2.contains(string2)) continue;
            arrayList2.add(string2);
        }
        return new ArrayList[]{arrayList, arrayList2};
    }

    public static String getServletMapping(FileObject fileObject, Document document) {
        String string = SourceUtils.getToplevelClassName((FileObject)fileObject);
        if (string == null || document == null) {
            return null;
        }
        NodeList nodeList = WebProjectUtils.getServlets(document);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = WebProjectUtils.getElementContent((Element)nodeList.item(i), "servlet-name");
            String string3 = WebProjectUtils.getElementContent((Element)nodeList.item(i), "servlet-class");
            if (string2 == null || string3 == null || !string.equals(string3)) continue;
            NodeList nodeList2 = WebProjectUtils.getServletMappings(document);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!string2.equals(WebProjectUtils.getElementContent((Element)nodeList2.item(j), "servlet-name"))) continue;
                return WebProjectUtils.getElementContent((Element)nodeList2.item(j), "url-pattern");
            }
            return null;
        }
        return null;
    }

    public static NodeList getServletMappings(Document document) {
        return document.getElementsByTagName("servlet-mapping");
    }

    public static NodeList getServlets(Document document) {
        return document.getElementsByTagName("servlet");
    }

    public static boolean isWebDocumentSource(FileObject fileObject, Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("doc_root");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebJavaSource(FileObject fileObject, Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }

    public static Collection<WebModule> getWebModules(Project project, boolean bl) {
        ArrayList<WebModule> arrayList = new ArrayList<WebModule>();
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            arrayList.add(webModule);
        }
        if (bl) {
            EarProvider earProvider = (EarProvider)project.getLookup().lookup(EarProvider.class);
            if (webModule == null && earProvider != null) {
                HashSet hashSet = new HashSet();
                ProjectUtilities.fetchSubprojects((Project)project, hashSet);
                for (Project project2 : hashSet) {
                    arrayList.addAll(WebProjectUtils.getWebModules(project2, bl));
                }
            }
        }
        return arrayList;
    }

    public static void resetJSPNameCache() {
        jspClass2NameMap.clear();
    }

    private static String getElementContent(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        Node node = nodeList.item(0);
        if (node == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (string2 == null) {
            return null;
        }
        return string2.trim();
    }

    private static void searchForJSPs(FileObject fileObject, ArrayList arrayList) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder()) {
                WebProjectUtils.searchForJSPs(fileObject2, arrayList);
                continue;
            }
            if (!fileObject2.isData() || !"jsp".equals(fileObject2.getExt())) continue;
            arrayList.add(fileObject2);
        }
    }
}

