/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseUtils {
    private static final String TMP_NAME = "NB___TMP___ENOUGH___UNIQUE___CONSTANT___";

    public static boolean isRegularProject(String string) {
        return string != null && EclipseUtils.isRegularProject(new File(string.trim()));
    }

    public static boolean isRegularProject(File file) {
        return file != null && FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)) != null && file.isDirectory() && new File(file, ".project").isFile();
    }

    public static boolean isRegularWorkSpace(File file) {
        assert (file == null || file.equals(FileUtil.normalizeFile((File)file))) : "#137407 problem: " + file + " vs. " + FileUtil.normalizeFile((File)file);
        return file != null && FileUtil.toFileObject((File)file) != null && file.isDirectory() && new File(file, ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs").isFile() && new File(file, ".metadata/.plugins/org.eclipse.core.resources/.projects").isDirectory();
    }

    public static boolean isWritable(String string) {
        File file = new File(string.trim(), TMP_NAME + System.currentTimeMillis());
        if (file.mkdirs()) {
            file.delete();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> loadProperties(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        try {
            properties.load(bufferedInputStream);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true);
    }

    public static String[] splitVariable(String string) {
        int n = string.replace('\\', '/').indexOf(47);
        if (n == -1) {
            n = string.length();
        }
        return new String[]{string.substring(0, n), string.substring(n)};
    }

    public static String[] splitProject(String string) {
        assert (string.startsWith("/")) : string;
        int n = string.replace('\\', '/').indexOf(47, 1);
        if (n == -1) {
            n = string.length();
        }
        return new String[]{string.substring(1, n), string.substring(n)};
    }

    public static void tryLoad(Properties properties, File file, String string) {
        if (file == null) {
            return;
        }
        File file2 = new File(file, string);
        EclipseUtils.tryLoad(properties, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoad(Properties properties, File file) {
        if (!file.isFile()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

