/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectImportModel {
    private static final Logger LOG = Logger.getLogger(ProjectImportModel.class.getName());
    private EclipseProject project;
    private File projectLocation;
    private JavaPlatform platform;
    private List<Project> alreadyImportedProjects;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraWizardPanels;
    private final Map<File, Boolean> looksLikeTests = new HashMap<File, Boolean>();

    public ProjectImportModel(EclipseProject eclipseProject, File file, JavaPlatform javaPlatform, List<Project> list) {
        this(eclipseProject, file, javaPlatform, list, null);
    }

    public ProjectImportModel(EclipseProject eclipseProject, File file, JavaPlatform javaPlatform, List<Project> list, List<WizardDescriptor.Panel<WizardDescriptor>> list2) {
        Parameters.notNull((CharSequence)"project", (Object)eclipseProject);
        this.project = eclipseProject;
        assert (file == null || file.equals(FileUtil.normalizeFile((File)file)));
        this.projectLocation = file;
        this.platform = javaPlatform;
        this.alreadyImportedProjects = list;
        this.extraWizardPanels = list2;
    }

    public Facets getFacets() {
        return this.project.getFacets();
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public File getEclipseProjectFolder() {
        return this.project.getDirectory();
    }

    public File getEclipseWorkspaceFolder() {
        Workspace workspace = this.project.getWorkspace();
        return workspace != null ? workspace.getDirectory() : null;
    }

    public File getNetBeansProjectLocation() {
        return this.projectLocation;
    }

    public Set<String> getEclipseNatures() {
        return this.project.getNatures();
    }

    public List<DotClassPathEntry> getEclipseClassPathEntries() {
        return this.project.getClassPathEntries();
    }

    public List<DotClassPathEntry> getEclipseSourceRoots() {
        return this.filterSourceRootsForTests(false);
    }

    public File[] getEclipseSourceRootsAsFileArray() {
        return ProjectImportModel.convertToFileArray(this.getEclipseSourceRoots());
    }

    public List<DotClassPathEntry> getEclipseTestSourceRoots() {
        return this.filterSourceRootsForTests(true);
    }

    public File[] getEclipseTestSourceRootsAsFileArray() {
        return ProjectImportModel.convertToFileArray(this.getEclipseTestSourceRoots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DotClassPathEntry> filterSourceRootsForTests(boolean bl) {
        List<DotClassPathEntry> list = this.project.getSourceRoots();
        if (!this.hasJUnitOnClassPath() || list.size() <= 1) {
            if (bl) {
                return Collections.emptyList();
            }
            return list;
        }
        ArrayList<DotClassPathEntry> arrayList = new ArrayList<DotClassPathEntry>(list.size());
        for (DotClassPathEntry dotClassPathEntry : list) {
            Boolean bl2;
            File file = new File(dotClassPathEntry.getAbsolutePath());
            Map<File, Boolean> map = this.looksLikeTests;
            synchronized (map) {
                bl2 = this.looksLikeTests.get(file);
                if (bl2 == null) {
                    bl2 = this.hasTests(file);
                    this.looksLikeTests.put(file, bl2);
                }
            }
            if (!(!bl ^ bl2)) continue;
            arrayList.add(dotClassPathEntry);
        }
        return arrayList;
    }

    private boolean hasJUnitOnClassPath() {
        for (DotClassPathEntry dotClassPathEntry : this.getEclipseClassPathEntries()) {
            if (!ClassPathContainerResolver.isJUnit(dotClassPathEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTests(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (!this.hasTests(file2)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.isJUnitFile(file);
    }

    private boolean isJUnitFile(File file) {
        if (!(file.getName().endsWith("Test.java") || file.getName().endsWith("Case.java") || file.getName().endsWith("Suite.java"))) {
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            return this.readJUnitFileHeader(fileObject);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readJUnitFileHeader(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.getEncoding()));
            for (int i = 100; null != (string = bufferedReader.readLine()) && i > 0; --i) {
                if (!string.contains("junit.framework.Test") && !string.contains("org.junit.Test") && !string.contains("junit.framework.*") && !string.contains("org.junit.*")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            inputStream.close();
        }
        return false;
    }

    public JavaPlatform getJavaPlatform() {
        return this.platform;
    }

    String getEclipseVersion() {
        return null;
    }

    public DotClassPathEntry getOutput() {
        return this.project.getOutput();
    }

    public List<Project> getAlreadyImportedProjects() {
        return Collections.unmodifiableList(this.alreadyImportedProjects);
    }

    private static File[] convertToFileArray(List<DotClassPathEntry> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (DotClassPathEntry dotClassPathEntry : list) {
            arrayList.add(new File(dotClassPathEntry.getAbsolutePath()));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public String getSourceLevel() {
        Properties properties = this.getPreferences("org.eclipse.jdt.core");
        String string = properties.getProperty("org.eclipse.jdt.core.compiler.compliance", "1.5");
        return properties.getProperty("org.eclipse.jdt.core.compiler.source", string);
    }

    public String getTargetLevel() {
        Properties properties = this.getPreferences("org.eclipse.jdt.core");
        String string = properties.getProperty("org.eclipse.jdt.core.compiler.compliance", "1.5");
        return properties.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", string);
    }

    public boolean isDebug() {
        Properties properties = this.getPreferences("org.eclipse.jdt.core");
        for (String string : new String[]{"lineNumber", "localVariable", "sourceFile"}) {
            if (!"generate".equals(properties.getProperty("org.eclipse.jdt.core.compiler.debug." + string))) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecation() {
        Properties properties = this.getPreferences("org.eclipse.jdt.core");
        return ProjectImportModel.warningOrError(properties.getProperty("org.eclipse.jdt.core.compiler.problem.deprecation"));
    }

    public String getCompilerArgs() {
        Properties properties = this.getPreferences("org.eclipse.jdt.core");
        StringBuilder stringBuilder = new StringBuilder();
        ProjectImportModel.maybeAddWarning(stringBuilder, properties, "org.eclipse.jdt.core.compiler.problem.fallthroughCase", "-Xlint:fallthrough");
        ProjectImportModel.maybeAddWarning(stringBuilder, properties, "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", "-Xlint:finally");
        ProjectImportModel.maybeAddWarning(stringBuilder, properties, "org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "-Xlint:serial");
        ProjectImportModel.maybeAddWarning(stringBuilder, properties, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "-Xlint:unchecked");
        return stringBuilder.toString();
    }

    private static boolean warningOrError(String string) {
        return "warning".equals(string) || "error".equals(string);
    }

    private static void maybeAddWarning(StringBuilder stringBuilder, Properties properties, String string, String string2) {
        if (ProjectImportModel.warningOrError(properties.getProperty(string))) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
        }
    }

    public String getEncoding() {
        Properties properties = this.getPreferences("org.eclipse.core.resources");
        String string = properties.getProperty("encoding/<project>");
        if (string != null) {
            return string;
        }
        string = properties.getProperty("encoding");
        if (string != null) {
            return string;
        }
        return "UTF-8";
    }

    private Properties getPreferences(String string) {
        Properties properties = new Properties();
        String string2 = ".settings/" + string + ".prefs";
        EclipseUtils.tryLoad(properties, this.getEclipseWorkspaceFolder(), ".metadata/.plugins/org.eclipse.core.runtime/" + string2);
        EclipseUtils.tryLoad(properties, this.getEclipseProjectFolder(), string2);
        return properties;
    }

    public Collection<LaunchConfiguration> getLaunchConfigurations() {
        Workspace workspace = this.project.getWorkspace();
        if (workspace == null) {
            return Collections.emptySet();
        }
        ArrayList<LaunchConfiguration> arrayList = new ArrayList<LaunchConfiguration>();
        for (LaunchConfiguration launchConfiguration : workspace.getLaunchConfigurations()) {
            if (!this.getProjectName().equals(launchConfiguration.getProjectName())) continue;
            arrayList.add(launchConfiguration);
        }
        return arrayList;
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getExtraWizardPanels() {
        return this.extraWizardPanels;
    }
}

