/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class OutputLogger
implements ISVNNotifyListener {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;
    private static final RequestProcessor rp = new RequestProcessor("SubversionOutput", 1);
    private boolean writable;
    private static final HashSet<String> openedWindows = new HashSet(5);

    public static OutputLogger getLogger(SVNUrl sVNUrl) {
        if (sVNUrl != null) {
            return new OutputLogger(sVNUrl);
        }
        return new NullLogger();
    }

    private OutputLogger(SVNUrl sVNUrl) {
        this.repositoryRootString = sVNUrl.toString();
    }

    private OutputLogger() {
    }

    public void logCommandLine(final String string) {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.logln(string, false);
                OutputLogger.this.flush();
            }
        });
    }

    private void flush() {
        if (this.writable) {
            this.getLog().getOut().flush();
        }
    }

    public void logCompleted(final String string) {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.logln(string, OutputLogger.this.ignoreCommand);
                OutputLogger.this.flush();
            }
        });
    }

    public void logError(final String string) {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.logln(string, false);
                OutputLogger.this.flush();
            }
        });
    }

    public void logMessage(final String string) {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.logln(string, OutputLogger.this.ignoreCommand);
                OutputLogger.this.flush();
            }
        });
    }

    public void logRevision(long l, String string) {
    }

    public void onNotify(File file, SVNNodeKind sVNNodeKind) {
    }

    public void setCommand(final int n) {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.ignoreCommand = n == 19 || n == 12 || n == 25 || n == 13 || n == 11;
            }
        });
    }

    public void closeLog() {
        rp.post(new Runnable(){

            public void run() {
                if (OutputLogger.this.log != null && OutputLogger.this.writable) {
                    OutputLogger.this.getLog().getOut().flush();
                    OutputLogger.this.getLog().getOut().close();
                }
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.getLog();
                OutputLogger.this.flush();
            }
        });
    }

    private void logln(String string, boolean bl) {
        this.log(string + "\n", null, bl);
    }

    private void log(String string, OutputListener outputListener, boolean bl) {
        if (bl) {
            return;
        }
        if (this.getLog().isClosed()) {
            if (SvnModuleConfig.getDefault().getAutoOpenOutput()) {
                Subversion.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
                this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
                try {
                    this.getLog().getOut().reset();
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.SEVERE, null, iOException);
                }
            } else {
                this.writable = false;
            }
        }
        if (this.writable) {
            if (outputListener != null) {
                try {
                    this.getLog().getOut().println(string, outputListener);
                }
                catch (IOException iOException) {
                    this.getLog().getOut().write(string);
                }
            } else {
                this.getLog().getOut().write(string);
            }
        }
    }

    private InputOutput getLog() {
        this.writable = true;
        if (this.log == null) {
            Subversion.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            if (!openedWindows.contains(this.repositoryRootString)) {
                this.writable = SvnModuleConfig.getDefault().getAutoOpenOutput();
                openedWindows.add(this.repositoryRootString);
                if (!this.writable) {
                    this.log.closeInputOutput();
                }
            }
        }
        return this.log;
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        public void logCommandLine(String string) {
        }

        public void logCompleted(String string) {
        }

        public void logError(String string) {
        }

        public void logMessage(String string) {
        }

        public void logRevision(long l, String string) {
        }

        public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        }

        public void setCommand(int n) {
        }

        public void closeLog() {
        }

        public void flushLog() {
        }
    }
}

