/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.api;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.hooks.spi.SvnHook;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Subversion {
    private static final String WORKINGDIR_KEY_PREFIX = "working.dir.";
    private static final String RELATIVE_PATH_ROOT = "/";
    public static final String CLIENT_UNAVAILABLE_ERROR_MESSAGE = "SVN client unavailable";

    public static String[] selectRepositoryFolders(String string, String string2) throws MalformedURLException, IOException {
        return Subversion.selectRepositoryFolders(string, string2, null, null);
    }

    public static String[] selectRepositoryFolders(String string, String string2, String string3, String string4) throws MalformedURLException, IOException {
        SVNRevision sVNRevision;
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        RepositoryConnection repositoryConnection = new RepositoryConnection(string2);
        SVNUrl sVNUrl = repositoryConnection.getSvnUrl();
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNRevision = repositoryConnection.getSvnRevision());
        Browser browser = new Browser(string, 9, repositoryFile, null, string3 != null ? string3 : "", string3 != null && string4 != null ? string4 : "", null, "org.netbeans.modules.subversion.ui.browser.checkout");
        RepositoryFile[] repositoryFileArray = browser.getRepositoryFiles();
        if (repositoryFileArray == null || repositoryFileArray.length == 0) {
            return null;
        }
        String[] stringArray = Subversion.makeRelativePaths(repositoryFile, repositoryFileArray);
        return stringArray;
    }

    public static void checkoutRepositoryFolder(String string, String[] stringArray, File file, boolean bl) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Subversion.checkoutRepositoryFolder(string, stringArray, file, null, null, false, bl);
    }

    public static void checkoutRepositoryFolder(String string, String[] stringArray, File file, boolean bl, boolean bl2) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Subversion.checkoutRepositoryFolder(string, stringArray, file, null, null, bl2);
    }

    public static void checkoutRepositoryFolder(String string, String[] stringArray, File file, String string2, String string3, boolean bl) throws MalformedURLException, IOException {
        Subversion.checkoutRepositoryFolder(string, stringArray, file, string2, string3, false, bl);
    }

    public static void checkoutRepositoryFolder(String string, String[] stringArray, File file, String string2, String string3, boolean bl, boolean bl2) throws MalformedURLException, IOException {
        int n;
        RepositoryFile[] repositoryFileArray;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        RepositoryConnection repositoryConnection = new RepositoryConnection(string);
        SVNUrl sVNUrl = repositoryConnection.getSvnUrl();
        SVNRevision sVNRevision = repositoryConnection.getSvnRevision();
        SvnClient svnClient = Subversion.getClient(sVNUrl, string2, string3);
        if (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].trim().equals("")) {
            repositoryFileArray = new RepositoryFile[]{new RepositoryFile(sVNUrl, ".", sVNRevision)};
        } else {
            repositoryFileArray = new RepositoryFile[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                String string4 = stringArray[n];
                string4 = Subversion.polishRelativePath(string4);
                repositoryFileArray[n] = new RepositoryFile(sVNUrl, string4, sVNRevision);
            }
        }
        n = file.exists() && !SvnUtils.isManaged(file) ? 1 : 0;
        CheckoutAction.performCheckout(sVNUrl, svnClient, repositoryFileArray, file, bl, bl2).waitFinished();
        try {
            Subversion.storeWorkingDir(new URL(string), file.toURI().toURL());
        }
        catch (Exception exception) {
            Logger.getLogger(Subversion.class.getName()).log(Level.FINE, "Cannot store subversion workdir preferences", exception);
        }
        if (n != 0) {
            Subversion.getSubversion().versionedFilesChanged();
            SvnUtils.refreshParents(file);
            Subversion.getSubversion().getStatusCache().refreshRecursively(file);
        }
    }

    public static void mkdir(String string, String string2, String string3, String string4) throws MalformedURLException, IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in  awt!";
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        SVNUrl sVNUrl = new SVNUrl(string);
        SvnClient svnClient = Subversion.getClient(sVNUrl, string2, string3);
        try {
            svnClient.mkdir(sVNUrl, true, string4);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, true);
            throw new IOException(sVNClientException.getMessage());
        }
    }

    public static void addRecentUrl(String string) throws MalformedURLException {
        new SVNUrl(string);
        RepositoryConnection repositoryConnection = new RepositoryConnection(string);
        SvnModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
    }

    public static void commit(final File[] fileArray, final String string, final String string2, final String string3) throws IOException {
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        FileStatusCache fileStatusCache = Subversion.getSubversion().getStatusCache();
        File[] fileArray2 = fileStatusCache.listFiles(fileArray, 6612);
        if (fileArray2.length == 0) {
            return;
        }
        SvnFileNode[] svnFileNodeArray = new SvnFileNode[fileArray2.length];
        for (int i = 0; i < fileArray2.length; ++i) {
            svnFileNodeArray[i] = new SvnFileNode(fileArray2[i]);
        }
        CommitOptions[] commitOptionsArray = SvnUtils.createDefaultCommitOptions(svnFileNodeArray, false);
        final HashMap<SvnFileNode, CommitOptions> hashMap = new HashMap<SvnFileNode, CommitOptions>(svnFileNodeArray.length);
        for (int i = 0; i < svnFileNodeArray.length; ++i) {
            hashMap.put(svnFileNodeArray[i], commitOptionsArray[i]);
        }
        try {
            final SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(fileArray[0]);
            RequestProcessor requestProcessor = Subversion.getSubversion().getRequestProcessor(sVNUrl);
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                public void perform() {
                    SvnClient svnClient;
                    try {
                        svnClient = Subversion.getSubversion().getClient(sVNUrl, string, string2, this);
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                        return;
                    }
                    CommitAction.performCommit(svnClient, string3, hashMap, new Context(fileArray), this, false, Collections.<SvnHook>emptyList());
                }
            };
            svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress")).waitFinished();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
        }
    }

    public static boolean showFileHistory(final File file, final int n) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in  awt!";
        if (!file.exists()) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Trying to show history for non-existent file {0}", file.getAbsolutePath());
            return false;
        }
        if (!file.isFile()) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Trying to show history for a folder {0}", file.getAbsolutePath());
            return false;
        }
        if (!SvnUtils.isManaged(file)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "Trying to show history for an unmanaged file {0}", file.getAbsolutePath());
            return false;
        }
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryAction.openSearch(file, n);
            }
        });
        return true;
    }

    public static boolean isRepository(String string) {
        boolean bl = false;
        if (!Subversion.isClientAvailable(false)) {
            return false;
        }
        RepositoryConnection repositoryConnection = new RepositoryConnection(string);
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = new SVNUrl(repositoryConnection.getSvnUrl().toString());
        }
        catch (MalformedURLException malformedURLException) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, "Invalid svn url " + string, malformedURLException);
        }
        if (sVNUrl != null) {
            String string2 = sVNUrl.getProtocol();
            if ("svn".equals(string2) || string2.startsWith("svn+")) {
                bl = true;
            } else {
                SvnClient svnClient = null;
                try {
                    svnClient = Subversion.getSubversion().getClient(sVNUrl, repositoryConnection.getUsername(), repositoryConnection.getPassword(), 0);
                }
                catch (SVNClientException sVNClientException) {
                    org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "Cannot create client for url: " + string, sVNClientException);
                }
                if (svnClient != null) {
                    try {
                        ISVNInfo iSVNInfo = svnClient.getInfo(sVNUrl);
                        if (iSVNInfo != null) {
                            bl = true;
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        String string3 = sVNClientException.getMessage().toLowerCase();
                        if (SvnClientExceptionHandler.isAuthentication(string3) || SvnClientExceptionHandler.isNoCertificate(string3)) {
                            bl = true;
                        }
                        org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, "Invalid url: " + string, sVNClientException);
                    }
                }
            }
        }
        return bl;
    }

    public static void openCheckoutWizard(String string) throws MalformedURLException, IOException {
        Subversion.addRecentUrl(string);
        if (!Subversion.isClientAvailable(true)) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "Subversion client is unavailable");
            throw new IOException(CLIENT_UNAVAILABLE_ERROR_MESSAGE);
        }
        ((CheckoutAction)SystemAction.get(CheckoutAction.class)).performAction();
    }

    public static boolean isClientAvailable(boolean bl) {
        if (!bl) {
            return Subversion.isClientAvailable();
        }
        if (Subversion.getSubversion().checkClientAvailable()) {
            return true;
        }
        return Subversion.isClientAvailable();
    }

    private static boolean isClientAvailable() {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            org.netbeans.modules.subversion.Subversion.LOG.log(Level.INFO, "svn client not available");
            return false;
        }
        return true;
    }

    private static org.netbeans.modules.subversion.Subversion getSubversion() {
        return org.netbeans.modules.subversion.Subversion.getInstance();
    }

    private static String[] makeRelativePaths(RepositoryFile repositoryFile, RepositoryFile[] repositoryFileArray) {
        String[] stringArray = new String[repositoryFileArray.length];
        String[] stringArray2 = repositoryFile.getPathSegments();
        for (int i = 0; i < repositoryFileArray.length; ++i) {
            RepositoryFile repositoryFile2 = repositoryFileArray[i];
            stringArray[i] = Subversion.makeRelativePath(stringArray2, repositoryFile2.getPathSegments());
        }
        return stringArray;
    }

    private static String makeRelativePath(String[] stringArray, String[] stringArray2) {
        assert (Subversion.isPrefixOf(stringArray, stringArray2));
        int n = stringArray2.length - stringArray.length;
        if (n == 0) {
            return RELATIVE_PATH_ROOT;
        }
        if (n == 1) {
            return stringArray2[stringArray2.length - 1];
        }
        StringBuilder stringBuilder = new StringBuilder(120);
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        stringBuilder.append(stringArray2[n2++]);
        for (int i = n2; i < n3; ++i) {
            stringBuilder.append('/');
            stringBuilder.append(stringArray2[i]);
        }
        return stringBuilder.toString();
    }

    private static boolean isPrefixOf(String[] stringArray, String[] stringArray2) {
        if (stringArray.length > stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static void storeWorkingDir(URL uRL, URL uRL2) {
        Preferences preferences = NbPreferences.forModule(Subversion.class);
        preferences.put(WORKINGDIR_KEY_PREFIX + uRL, uRL2.toString());
    }

    private static String polishRelativePath(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty path");
        }
        if ((string = Subversion.removeDuplicateSlashes(string)).equals(RELATIVE_PATH_ROOT)) {
            return RELATIVE_PATH_ROOT;
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static boolean isRootRelativePath(String string) {
        return string.equals(RELATIVE_PATH_ROOT);
    }

    private static String removeDuplicateSlashes(String string) {
        int n = string.length();
        StringBuilder stringBuilder = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                if (bl) {
                    if (stringBuilder != null) continue;
                    stringBuilder = new StringBuilder(n);
                    stringBuilder.append(string, 0, i);
                    continue;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    private static SvnClient getClient(SVNUrl sVNUrl, String string, String string2) {
        try {
            if (string != null) {
                string2 = string2 != null ? string2 : "";
                return Subversion.getSubversion().getClient(sVNUrl, string, string2);
            }
            return Subversion.getSubversion().getClient(sVNUrl);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, true);
            return null;
        }
    }
}

